/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.artron;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.desktop.BlockScannerData;
import me.eccentric_nz.TARDIS.desktop.UpgradeBlockScanner;
import me.eccentric_nz.TARDIS.desktop.UpgradeData;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.block.Block;

public class BeaconToggler {
    private final TARDIS plugin;

    public BeaconToggler(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void flickSwitch(UUID uuid, int id, boolean on) {
        HashMap<String, Object> whereb = new HashMap<String, Object>();
        whereb.put("tardis_id", id);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, whereb, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            Schematic schm = tardis.getSchematic();
            if (Desktops.getNO_BEACON().contains(schm)) {
                return;
            }
            String beacon = tardis.getBeacon();
            if (!beacon.isEmpty()) {
                String[] beaconData = beacon.split(":");
                if (beaconData.length > 1) {
                    Location bl = TARDISStaticLocationGetters.getLocationFromDB(beacon);
                    Block b = bl.getBlock();
                    while (!b.getChunk().isLoaded()) {
                        b.getChunk().load();
                    }
                    b.setBlockData(on ? TARDISConstants.GLASS : TARDISConstants.POWER);
                    if (!this.plugin.getGeneralKeeper().getProtectBlockMap().containsKey(bl.toString())) {
                        this.plugin.getGeneralKeeper().getProtectBlockMap().put(bl.toString(), tardis.getTardisId());
                    }
                } else {
                    this.updateBeacon(schm, uuid);
                }
            } else {
                this.updateBeacon(schm, uuid);
            }
        }
    }

    private void updateBeacon(Schematic schm, UUID uuid) {
        UpgradeData tud = new UpgradeData();
        tud.setSchematic(schm);
        tud.setPrevious(schm);
        tud.setWall("ORANGE_WOOL");
        tud.setFloor("LIGHT_GRAY_WOOL");
        UpgradeBlockScanner scanner = new UpgradeBlockScanner(this.plugin, tud, uuid);
        BlockScannerData check = scanner.check();
        if (!check.beacon().isEmpty()) {
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("beacon", check.beacon());
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("uuid", uuid.toString());
            this.plugin.getQueryFactory().doUpdate("tardis", set, where);
        }
    }
}

