/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.sonic.actions;

import com.google.common.collect.Iterables;
import java.util.Collection;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.sonic.actions.SonicRespect;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.block.Block;
import org.bukkit.block.BrushableBlock;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Brushable;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.loot.LootContext;
import org.bukkit.loot.LootTable;
import org.bukkit.plugin.Plugin;

public class SonicBrush {
    public static void dust(TARDIS plugin, Block b, Player p) {
        BlockData blockData;
        if (SonicRespect.checkBlockRespect(plugin, p, b) && (blockData = b.getBlockData()) instanceof Brushable) {
            LootContext.Builder builder;
            Collection col;
            LootTable table;
            Brushable brushable = (Brushable)blockData;
            Material material = brushable.getMaterial();
            boolean isSand = material == Material.SUSPICIOUS_SAND;
            int dusted = brushable.getDusted() + 1;
            BrushableBlock bb = (BrushableBlock)b.getState();
            ItemStack is = bb.getItem();
            if (!(dusted != 1 || is != null && is.getType() != Material.AIR || (table = bb.getLootTable()) == null || (col = table.populateLoot(TARDISConstants.RANDOM, (builder = new LootContext.Builder(b.getLocation()).killer((HumanEntity)p)).build())).isEmpty())) {
                is = (ItemStack)Iterables.get((Iterable)col, (int)0);
                bb.setItem(is);
                bb.setLootTable(null);
                bb.update();
            }
            if (dusted == 4 && is != null && is.getType() != Material.AIR) {
                p.playSound(b.getLocation(), isSand ? Sound.BLOCK_SUSPICIOUS_SAND_BREAK : Sound.BLOCK_SUSPICIOUS_GRAVEL_BREAK, 1.0f, 1.0f);
                b.getWorld().dropItemNaturally(b.getLocation(), is);
                b.setType(isSand ? Material.SAND : Material.GRAVEL);
            } else if (dusted < 4) {
                UUID uuid = p.getUniqueId();
                plugin.getTrackerKeeper().getBrushCooldown().put(uuid, System.currentTimeMillis() + 1800L);
                brushable.setDusted(dusted);
                b.setBlockData((BlockData)brushable);
                plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, () -> {
                    if (b.getType().equals((Object)material) && System.currentTimeMillis() > plugin.getTrackerKeeper().getBrushCooldown().get(uuid)) {
                        brushable.setDusted(0);
                        b.setBlockData((BlockData)brushable);
                        plugin.getTrackerKeeper().getBrushCooldown().remove(uuid);
                    }
                }, 40L);
            }
        }
    }
}

