/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic.actions;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemRegistry;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.schematic.SchematicGZip;
import me.eccentric_nz.TARDIS.schematic.getters.ArmourStandGetter;
import me.eccentric_nz.TARDIS.schematic.getters.BannerGetter;
import me.eccentric_nz.TARDIS.schematic.getters.DataPackPainting;
import me.eccentric_nz.TARDIS.schematic.getters.ItemStackGetter;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.DecoratedPot;
import org.bukkit.block.Shelf;
import org.bukkit.block.Sign;
import org.bukkit.block.Skull;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.sign.Side;
import org.bukkit.block.sign.SignSide;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.GlowItemFrame;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.Painting;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.MainHand;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;

public class SchematicSave {
    /*
     * WARNING - void declaration
     */
    public boolean act(TARDIS plugin, Player player, String which) {
        UUID uuid = player.getUniqueId();
        if (!plugin.getTrackerKeeper().getStartLocation().containsKey(uuid)) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCHM_NO_START");
            return true;
        }
        if (!plugin.getTrackerKeeper().getEndLocation().containsKey(uuid)) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCHM_NO_END");
            return true;
        }
        World w = plugin.getTrackerKeeper().getStartLocation().get(uuid).getWorld();
        String chk_w = plugin.getTrackerKeeper().getEndLocation().get(uuid).getWorld().getName();
        if (!w.getName().equals(chk_w)) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCHM_WORLD");
            return true;
        }
        int sx = plugin.getTrackerKeeper().getStartLocation().get(uuid).getBlockX();
        int sy = plugin.getTrackerKeeper().getStartLocation().get(uuid).getBlockY();
        int sz = plugin.getTrackerKeeper().getStartLocation().get(uuid).getBlockZ();
        int ex = plugin.getTrackerKeeper().getEndLocation().get(uuid).getBlockX();
        int ey = plugin.getTrackerKeeper().getEndLocation().get(uuid).getBlockY();
        int ez = plugin.getTrackerKeeper().getEndLocation().get(uuid).getBlockZ();
        int minx = Math.min(sx, ex);
        int maxx = Math.max(sx, ex);
        int miny = Math.min(sy, ey);
        int maxy = Math.max(sy, ey);
        int minz = Math.min(sz, ez);
        int maxz = Math.max(sz, ez);
        JsonObject relative = new JsonObject();
        int px = player.getLocation().getBlockX() - minx;
        int py = player.getLocation().getBlockY() - miny;
        int pz = player.getLocation().getBlockZ() - minz;
        relative.addProperty("x", (Number)px);
        relative.addProperty("y", (Number)py);
        relative.addProperty("z", (Number)pz);
        JsonObject dimensions = new JsonObject();
        int width = maxx - minx + 1;
        int height = maxy - miny + 1;
        int length = maxz - minz + 1;
        dimensions.addProperty("width", (Number)width);
        dimensions.addProperty("height", (Number)height);
        dimensions.addProperty("length", (Number)length);
        if (width != length) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCHM_SQUARE");
            plugin.getMessenger().message((CommandSender)player, TardisModule.TARDIS, "Dimensions are: (x,z)" + width + ", " + length);
            return true;
        }
        if (!(width % 16 == 0 || which.equals("zero") || which.equals("junk") || which.equals("arcade") || which.contains("dalek"))) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCHM_MULTIPLE");
            return true;
        }
        JsonArray paintings = new JsonArray();
        JsonArray armourStands = new JsonArray();
        JsonArray itemFrames = new JsonArray();
        JsonArray itemDisplays = new JsonArray();
        JsonArray interactions = new JsonArray();
        JsonArray mannequins = new JsonArray();
        ArrayList<Entity> entities = new ArrayList<Entity>();
        JsonArray levels = new JsonArray();
        for (int l = miny; l <= maxy; ++l) {
            JsonArray rows = new JsonArray();
            for (int r = minx; r <= maxx; ++r) {
                JsonArray columns = new JsonArray();
                for (int c = minz; c <= maxz; ++c) {
                    JsonObject obj = new JsonObject();
                    Block b = w.getBlockAt(r, l, c);
                    Location location = b.getLocation();
                    BoundingBox box = new BoundingBox((double)location.getBlockX(), (double)location.getBlockY(), (double)location.getBlockZ(), (double)(location.getBlockX() + 1), (double)(location.getBlockY() + 1), (double)(location.getBlockZ() + 1)).expand(0.1);
                    for (Entity entity : b.getLocation().getWorld().getNearbyEntities(box)) {
                        JsonObject loc;
                        Location entityLocation = entity.getLocation();
                        if (entity instanceof Mannequin) {
                            Mannequin mannequin = (Mannequin)entity;
                            if (!entities.contains(entity)) {
                                JsonObject jsonObject = new JsonObject();
                                loc = new JsonObject();
                                loc.addProperty("x", (Number)(entityLocation.getBlockX() - minx));
                                loc.addProperty("y", (Number)(entityLocation.getBlockY() - miny));
                                loc.addProperty("z", (Number)(entityLocation.getBlockZ() - minz));
                                jsonObject.add("rel_location", (JsonElement)loc);
                                jsonObject.addProperty("rotation", (Number)Float.valueOf(mannequin.getYaw()));
                                jsonObject.addProperty("yaw", (Number)Float.valueOf(mannequin.getBodyYaw()));
                                String type = (String)mannequin.getPersistentDataContainer().getOrDefault(plugin.getHeadBlockKey(), PersistentDataType.STRING, (Object)"roman");
                                jsonObject.addProperty("type", type);
                                if (!mannequin.getEquipment().getItemInMainHand().getType().isAir()) {
                                    jsonObject.addProperty("hand", mannequin.getMainHand() == MainHand.LEFT ? "left" : "right");
                                    jsonObject.addProperty("item", mannequin.getEquipment().getItemInMainHand().getType().toString());
                                }
                                mannequins.add((JsonElement)jsonObject);
                                entities.add(entity);
                            }
                        }
                        if (entity instanceof ArmorStand) {
                            ArmorStand stand = (ArmorStand)entity;
                            if (!entities.contains(entity)) {
                                JsonObject jsonObject = ArmourStandGetter.getJson(stand, minx, miny, minz);
                                armourStands.add((JsonElement)jsonObject);
                                entities.add(entity);
                            }
                        }
                        if (entity instanceof Painting) {
                            Painting art = (Painting)entity;
                            if (!entities.contains(entity)) {
                                JsonObject jsonObject = new JsonObject();
                                loc = new JsonObject();
                                loc.addProperty("x", (Number)(entityLocation.getBlockX() - minx));
                                loc.addProperty("y", (Number)(entityLocation.getBlockY() - miny));
                                loc.addProperty("z", (Number)(entityLocation.getBlockZ() - minz));
                                jsonObject.add("rel_location", (JsonElement)loc);
                                try {
                                    jsonObject.addProperty("art", art.getArt().assetId().toString());
                                }
                                catch (IllegalArgumentException | IllegalStateException e) {
                                    jsonObject.addProperty("art", DataPackPainting.getCustomVariant(art));
                                }
                                jsonObject.addProperty("facing", art.getFacing().toString());
                                paintings.add((JsonElement)jsonObject);
                                entities.add(entity);
                            }
                        }
                        if (entity instanceof ItemFrame) {
                            ItemFrame f = (ItemFrame)entity;
                            if (!entities.contains(entity)) {
                                JsonObject jsonObject = new JsonObject();
                                loc = new JsonObject();
                                loc.addProperty("x", (Number)(entityLocation.getBlockX() - minx));
                                loc.addProperty("y", (Number)(entityLocation.getBlockY() - miny));
                                loc.addProperty("z", (Number)(entityLocation.getBlockZ() - minz));
                                jsonObject.add("rel_location", (JsonElement)loc);
                                jsonObject.addProperty("facing", f.getFacing().toString());
                                jsonObject.addProperty("rotation", f.getRotation().toString());
                                ItemStack item = f.getItem();
                                if (!item.isEmpty()) {
                                    jsonObject.add("item", (JsonElement)ItemStackGetter.getJson(item));
                                }
                                if (f.getPersistentDataContainer().has(plugin.getCustomBlockKey(), PersistentDataType.INTEGER)) {
                                    jsonObject.addProperty("rotor", Boolean.valueOf(true));
                                }
                                if (f.getPersistentDataContainer().has(plugin.getMicroscopeKey(), PersistentDataType.INTEGER)) {
                                    jsonObject.addProperty("microscope", Boolean.valueOf(true));
                                }
                                jsonObject.addProperty("fixed", Boolean.valueOf(f.isFixed()));
                                jsonObject.addProperty("visible", Boolean.valueOf(f.isVisible()));
                                jsonObject.addProperty("rotation", f.getRotation().toString());
                                jsonObject.addProperty("glowing", Boolean.valueOf(f instanceof GlowItemFrame));
                                itemFrames.add((JsonElement)jsonObject);
                                entities.add(entity);
                            }
                        }
                        if (!(entity instanceof ItemDisplay)) continue;
                        ItemDisplay display = (ItemDisplay)entity;
                        if (entities.contains(entity)) continue;
                        JsonObject jsonObject = new JsonObject();
                        loc = new JsonObject();
                        loc.addProperty("x", (Number)(entityLocation.getX() - (double)minx));
                        loc.addProperty("y", (Number)(entityLocation.getY() - (double)miny));
                        loc.addProperty("z", (Number)(entityLocation.getZ() - (double)minz));
                        jsonObject.add("rel_location", (JsonElement)loc);
                        JsonObject stack = new JsonObject();
                        Material material = display.getItemStack().getType();
                        NamespacedKey model = null;
                        if (display.getItemStack().hasItemMeta()) {
                            ItemMeta im = display.getItemStack().getItemMeta();
                            if (im.hasDisplayName() && !im.hasItemModel()) {
                                stack.addProperty("display_name", ComponentUtils.stripColour(im.displayName()));
                            } else if (im.getPersistentDataContainer().has(plugin.getCustomBlockKey(), PersistentDataType.STRING)) {
                                String key = (String)im.getPersistentDataContainer().get(plugin.getCustomBlockKey(), PersistentDataType.STRING);
                                model = new NamespacedKey((Plugin)plugin, key);
                                stack.addProperty("cmd", model.getKey());
                            }
                        }
                        stack.addProperty("type", material.toString());
                        TARDISDisplayItem tdi = TARDISDisplayItemRegistry.getByModel(model);
                        if (tdi != null) {
                            stack.addProperty("light", Boolean.valueOf(tdi.isLight()));
                            stack.addProperty("lit", Boolean.valueOf(tdi.isLit()));
                            if (tdi.isClosedDoor()) {
                                stack.addProperty("door", Boolean.valueOf(true));
                            }
                        }
                        jsonObject.add("stack", (JsonElement)stack);
                        itemDisplays.add((JsonElement)jsonObject);
                        entities.add(entity);
                    }
                    String blockData = b.getBlockData().getAsString();
                    obj.addProperty("data", blockData);
                    if (Tag.BANNERS.isTagged((Keyed)b.getType())) {
                        JsonObject state = BannerGetter.getJson(b.getState());
                        obj.add("banner", (JsonElement)state);
                    }
                    if (b.getType().equals((Object)Material.PLAYER_HEAD) || b.getType().equals((Object)Material.PLAYER_WALL_HEAD)) {
                        JsonObject head = new JsonObject();
                        Skull skull = (Skull)b.getState();
                        if (skull.getPlayerProfile() != null) {
                            head.addProperty("uuid", skull.getPlayerProfile().getUniqueId().toString());
                            head.addProperty("texture", skull.getPlayerProfile().getTextures().getSkin().toString());
                        }
                        obj.add("head", (JsonElement)head);
                    }
                    if (b.getType().equals((Object)Material.DECORATED_POT)) {
                        JsonObject pot = new JsonObject();
                        DecoratedPot decorated = (DecoratedPot)b.getState();
                        for (Map.Entry entry : decorated.getSherds().entrySet()) {
                            pot.addProperty(((DecoratedPot.Side)entry.getKey()).toString(), ((Material)entry.getValue()).toString());
                        }
                        BlockData blockData2 = b.getBlockData();
                        if (blockData2 instanceof org.bukkit.block.data.type.DecoratedPot) {
                            org.bukkit.block.data.type.DecoratedPot dp = (org.bukkit.block.data.type.DecoratedPot)blockData2;
                            pot.addProperty("cracked", Boolean.valueOf(dp.isCracked()));
                        }
                        obj.add("pot", (JsonElement)pot);
                    }
                    if (Tag.ALL_SIGNS.isTagged((Keyed)b.getType())) {
                        JsonObject text = new JsonObject();
                        Sign sign = (Sign)b.getState();
                        SignSide front = sign.getSide(Side.FRONT);
                        if (!front.lines().isEmpty()) {
                            text.addProperty("line0", ComponentUtils.stripColour(front.line(0)));
                            text.addProperty("line1", ComponentUtils.stripColour(front.line(1)));
                            text.addProperty("line2", ComponentUtils.stripColour(front.line(2)));
                            text.addProperty("line3", ComponentUtils.stripColour(front.line(3)));
                            text.addProperty("glowing", Boolean.valueOf(front.isGlowingText()));
                            text.addProperty("colour", front.getColor().toString());
                            text.addProperty("editable", Boolean.valueOf(sign.isWaxed()));
                            JsonObject jsonObject = new JsonObject();
                            SignSide back = sign.getSide(Side.BACK);
                            jsonObject.addProperty("line0", ComponentUtils.stripColour(back.line(0)));
                            jsonObject.addProperty("line1", ComponentUtils.stripColour(back.line(1)));
                            jsonObject.addProperty("line2", ComponentUtils.stripColour(back.line(2)));
                            jsonObject.addProperty("line3", ComponentUtils.stripColour(back.line(3)));
                            jsonObject.addProperty("glowing", Boolean.valueOf(back.isGlowingText()));
                            jsonObject.addProperty("colour", back.getColor().toString());
                            text.add("back", (JsonElement)jsonObject);
                            obj.add("sign", (JsonElement)text);
                        }
                    }
                    if (Tag.WOODEN_SHELVES.isTagged((Keyed)b.getType())) {
                        void var48_62;
                        Shelf shelf = (Shelf)b.getState();
                        JsonArray items = new JsonArray();
                        ItemStack[] stack = shelf.getInventory().getContents();
                        boolean bl = false;
                        while (var48_62 < 3) {
                            items.add((JsonElement)ItemStackGetter.getJson(stack[var48_62]));
                            ++var48_62;
                        }
                        obj.add("items", (JsonElement)items);
                    }
                    columns.add((JsonElement)obj);
                }
                rows.add((JsonElement)columns);
            }
            levels.add((JsonElement)rows);
        }
        JsonObject schematic = new JsonObject();
        schematic.add("relative", (JsonElement)relative);
        schematic.add("dimensions", (JsonElement)dimensions);
        schematic.add("input", (JsonElement)levels);
        if (!mannequins.isEmpty()) {
            schematic.add("mannequins", (JsonElement)mannequins);
        }
        if (!armourStands.isEmpty()) {
            schematic.add("armour_stands", (JsonElement)armourStands);
        }
        if (!paintings.isEmpty()) {
            schematic.add("paintings", (JsonElement)paintings);
        }
        if (!itemFrames.isEmpty()) {
            schematic.add("item_frames", (JsonElement)itemFrames);
        }
        if (!itemDisplays.isEmpty()) {
            schematic.add("item_displays", (JsonElement)itemDisplays);
        }
        if (!interactions.isEmpty()) {
            schematic.add("interactions", (JsonElement)interactions);
        }
        String output = String.valueOf(plugin.getDataFolder()) + File.separator + "user_schematics" + File.separator + which + ".json";
        File file = new File(output);
        try {
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(file), 16384);){
                bw.write(schematic.toString());
            }
            SchematicGZip.zip(output, String.valueOf(plugin.getDataFolder()) + File.separator + "user_schematics" + File.separator + which + ".tschm");
            file.delete();
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCHM_SAVED", which);
        }
        catch (IOException e) {
            plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SCHM_ERROR");
        }
        return true;
    }
}

