/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.games.pong;

import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.rooms.games.GameUtils;
import me.eccentric_nz.TARDIS.rooms.games.pong.GameChar;
import me.eccentric_nz.TARDIS.rooms.games.pong.PaddlePosition;
import me.eccentric_nz.TARDIS.rooms.games.pong.Pong;
import me.eccentric_nz.TARDIS.rooms.games.tetris.GameSound;
import me.eccentric_nz.TARDIS.rooms.games.tictactoe.MatchState;

public class Ball {
    static final int WIDTH = 29;
    static final int HEIGHT = 16;
    int x = 14;
    int y;
    Pong pong;
    int vx;
    int vy;

    public Ball(int y, Pong pong) {
        this.y = y;
        this.pong = pong;
        int[] d = GameUtils.DIRECTIONS[TARDISConstants.RANDOM.nextInt(GameUtils.DIRECTIONS.length)];
        this.vx = d[0];
        this.vy = d[1];
    }

    public void update() {
        if (this.x == 0) {
            this.pong.updateScore(MatchState.TARDIS_WON);
            this.pong.playSound(GameSound.POINT);
            this.pong.reset();
            return;
        }
        if (this.x == 28) {
            this.pong.updateScore(MatchState.PLAYER_WON);
            this.pong.playSound(GameSound.POINT);
            this.pong.reducePeriod();
            this.pong.reset();
            return;
        }
        this.pong.setChar(this.y, this.x, GameChar.space);
        int nextX = this.x + this.vx;
        int nextY = this.y + this.vy;
        if (nextX < 0 || nextX >= 29) {
            this.pong.playSound(GameSound.BOUNCE);
            this.vx = -this.vx;
        }
        if (nextY < 0 || nextY >= 16) {
            this.pong.playSound(GameSound.BOUNCE);
            this.vy = -this.vy;
        }
        nextX = this.x + this.vx;
        nextY = this.y + this.vy;
        PaddlePosition position = this.detectPaddle(this.y, nextX);
        if (position == PaddlePosition.NONE) {
            this.x = nextX;
        } else {
            this.applyPaddleBounce(position);
            this.pong.playSound(GameSound.PADDLE);
        }
        this.pong.setChar(nextY, nextX, GameChar.ball);
        if (this.x == 2 && this.vx > 0) {
            this.pong.updatePaddle(position);
        }
        if (this.x == 13 || this.x == 15) {
            for (int n = 1; n < 14; n += 2) {
                this.pong.setChar(n, 14, GameChar.net);
            }
        }
        this.y = nextY;
    }

    private PaddlePosition detectPaddle(int y, int x) {
        if (this.pong.getCANVAS()[y][x] == GameChar.paddle) {
            if (y == 0 || this.pong.getCANVAS()[y - 1][x] == GameChar.space) {
                return x == 1 ? PaddlePosition.PLAYER_TOP : PaddlePosition.TARDIS_TOP;
            }
            if (y == 15 || y + 1 < 16 && this.pong.getCANVAS()[y + 1][x] == GameChar.space) {
                return x == 1 ? PaddlePosition.PLAYER_BOTTOM : PaddlePosition.TARDIS_BOTTOM;
            }
            return x == 1 ? PaddlePosition.PLAYER_MIDDLE : PaddlePosition.TARDIS_MIDDLE;
        }
        return PaddlePosition.NONE;
    }

    private void applyPaddleBounce(PaddlePosition position) {
        this.vy = switch (position) {
            case PaddlePosition.PLAYER_TOP, PaddlePosition.TARDIS_TOP -> -1;
            case PaddlePosition.PLAYER_BOTTOM, PaddlePosition.TARDIS_BOTTOM -> 1;
            default -> 0;
        };
        this.vx = -this.vx;
        if (TARDISConstants.RANDOM.nextBoolean()) {
            this.vy = this.vy == 0 ? (TARDISConstants.RANDOM.nextBoolean() ? 1 : -1) : -this.vy;
        }
    }
}

