/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.games;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.achievement.TARDISAchievementFactory;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TIPSData;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetGames;
import me.eccentric_nz.TARDIS.enumeration.Advancement;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.rooms.CondenserData;
import me.eccentric_nz.TARDIS.rooms.RoomBuilder;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class ArcadeRoomBuilder {
    private final TARDIS plugin;

    public ArcadeRoomBuilder(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void build(Player p, int tips, int id) {
        ResultSetGames rsg = new ResultSetGames(this.plugin);
        if (rsg.fromId(id)) {
            return;
        }
        if (!this.plugin.getConfig().getBoolean("allow.zero_room")) {
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "ZERO_DISABLED");
            return;
        }
        TARDISInteriorPostioning tintpos = new TARDISInteriorPostioning(this.plugin);
        int slot = tips;
        if (tips == -1) {
            slot = tintpos.getFreeSlot();
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("tips", slot);
            HashMap<String, Object> where = new HashMap<String, Object>();
            where.put("tardis_id", id);
            this.plugin.getQueryFactory().doUpdate("tardis", set, where);
        }
        TIPSData pos = tintpos.getTIPSData(slot);
        int x = pos.getCentreX();
        int y = 16;
        int z = pos.getCentreZ();
        World w = this.plugin.getServer().getWorld("TARDIS_Zero_room");
        if (w == null) {
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "ZERO_NOT_FOUND");
            return;
        }
        Location l = new Location(w, (double)x, (double)y, (double)z);
        RoomBuilder builder = new RoomBuilder(this.plugin, "ARCADE", l, COMPASS.SOUTH, p);
        if (builder.build()) {
            UUID uuid = p.getUniqueId();
            int amount = this.plugin.getRoomsConfig().getInt("rooms.ARCADE.cost");
            HashMap<String, Object> set = new HashMap<String, Object>();
            set.put("uuid", p.getUniqueId().toString());
            this.plugin.getQueryFactory().alterEnergyLevel("tardis", -amount, set, p);
            if (this.plugin.getConfig().getBoolean("growth.rooms_require_blocks")) {
                CondenserData c_data = this.plugin.getGeneralKeeper().getRoomCondenserData().get(uuid);
                c_data.getBlockIDCount().forEach((key, value) -> {
                    HashMap<String, Object> wherec = new HashMap<String, Object>();
                    wherec.put("tardis_id", c_data.getTardis_id());
                    wherec.put("block_data", key);
                    this.plugin.getQueryFactory().alterCondenserBlockCount((int)value, wherec);
                });
                this.plugin.getGeneralKeeper().getRoomCondenserData().remove(uuid);
            }
            if (this.plugin.getAchievementConfig().getBoolean("rooms.enabled")) {
                TARDISAchievementFactory taf = new TARDISAchievementFactory(this.plugin, p, Advancement.ROOMS, this.plugin.getBuildKeeper().getRoomSeeds().size());
                taf.doAchievement("ARCADE");
            }
        }
    }
}

