/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.move;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCompanions;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.mobfarming.FollowerSpawner;
import me.eccentric_nz.TARDIS.mobfarming.PetsAndFollowers;
import me.eccentric_nz.TARDIS.mobfarming.TARDISFarmer;
import me.eccentric_nz.TARDIS.move.TARDISMoveSession;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerMoveEvent;

public class AnyoneMoveListener
implements Listener {
    private final TARDIS plugin;

    public AnyoneMoveListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR)
    public void onPlayerMoveToFromTARDIS(PlayerMoveEvent event) {
        Player player = event.getPlayer();
        Location l = new Location(event.getTo().getWorld(), (double)event.getTo().getBlockX(), (double)event.getTo().getBlockY(), (double)event.getTo().getBlockZ(), 0.0f, 0.0f);
        Location loc = player.getLocation();
        TARDISMoveSession tms = this.plugin.getTrackerKeeper().getTARDISMoveSession(player);
        tms.setStaleLocation(loc);
        if (tms.isStaleLocation()) {
            return;
        }
        if (this.plugin.getTrackerKeeper().getPortals().containsKey(l)) {
            TARDISTeleportLocation tpl = this.plugin.getTrackerKeeper().getPortals().get(l);
            UUID uuid = player.getUniqueId();
            int id = tpl.getTardisId();
            Location to = tpl.getLocation();
            boolean exit = this.plugin.getConfig().getBoolean("creation.create_worlds_with_perms") && TARDISPermission.hasPermission(this.plugin.getServer().getPlayer(uuid), "tardis.create_world") ? !to.getWorld().getName().contains("TARDIS") : (this.plugin.getConfig().getBoolean("creation.default_world") ? !to.getWorld().getName().equals(this.plugin.getConfig().getString("creation.default_world_name")) : !to.getWorld().getName().contains("TARDIS"));
            float yaw = exit ? player.getLocation().getYaw() + 180.0f : player.getLocation().getYaw();
            COMPASS d = COMPASS.valueOf(TARDISStaticUtils.getPlayersDirection(player, false));
            if (!tpl.getDirection().equals((Object)d)) {
                yaw += this.plugin.getGeneralKeeper().getDoorListener().adjustYaw(d, tpl.getDirection());
            }
            to.setYaw(yaw);
            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid.toString());
            boolean hasPrefs = rsp.resultSet();
            boolean minecart = hasPrefs && rsp.isMinecartOn();
            boolean userQuotes = hasPrefs && rsp.isQuotesOn();
            boolean willFarm = hasPrefs && rsp.isFarmOn();
            PetsAndFollowers petsAndFollowers = null;
            if (this.plugin.getConfig().getBoolean("allow.mob_farming") && TARDISPermission.hasPermission(player, "tardis.farm") && !this.plugin.getTrackerKeeper().getFarming().contains(uuid) && willFarm) {
                this.plugin.getTrackerKeeper().getFarming().add(uuid);
                TARDISFarmer tf = new TARDISFarmer(this.plugin);
                petsAndFollowers = tf.farmAnimals(l, d, id, player, tpl.getLocation().getWorld().getName(), l.getWorld().getName());
            }
            this.plugin.getGeneralKeeper().getDoorListener().removeTraveller(uuid);
            if (!exit) {
                HashMap<String, Object> set = new HashMap<String, Object>();
                set.put("tardis_id", id);
                set.put("uuid", uuid.toString());
                this.plugin.getQueryFactory().doSyncInsert("travellers", set);
                if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard") && this.isCompanion(uuid, id)) {
                    HashMap<String, Object> whereo = new HashMap<String, Object>();
                    whereo.put("tardis_id", id);
                    ResultSetTardis rs = new ResultSetTardis(this.plugin, whereo, "", false);
                    if (rs.resultSet()) {
                        this.plugin.getWorldGuardUtils().addMemberToRegion(to.getWorld(), rs.getTardis().getOwner(), player.getUniqueId());
                    }
                }
            }
            this.plugin.getGeneralKeeper().getDoorListener().movePlayer(player, to, exit, l.getWorld(), userQuotes, 0, minecart, false);
            if (petsAndFollowers != null) {
                if (!petsAndFollowers.getPets().isEmpty()) {
                    this.plugin.getGeneralKeeper().getDoorListener().movePets(petsAndFollowers.getPets(), tpl.getLocation(), player, d, true);
                }
                if (!petsAndFollowers.getFollowers().isEmpty()) {
                    new FollowerSpawner(this.plugin).spawn(petsAndFollowers.getFollowers(), tpl.getLocation(), player, d, true);
                }
            }
            if (userQuotes) {
                this.plugin.getMessenger().sendStatus(player, "DOOR_REMIND");
            }
            if (exit && this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard") && this.isCompanion(uuid, id)) {
                HashMap<String, Object> whereo = new HashMap<String, Object>();
                whereo.put("tardis_id", id);
                ResultSetTardis rs = new ResultSetTardis(this.plugin, whereo, "", false);
                if (rs.resultSet()) {
                    this.plugin.getWorldGuardUtils().removeMemberFromRegion(l.getWorld(), rs.getTardis().getOwner(), player.getUniqueId());
                }
            }
        }
    }

    private boolean isCompanion(UUID uuid, int id) {
        ResultSetCompanions rsc = new ResultSetCompanions(this.plugin, id);
        if (!rsc.getCompanions().isEmpty()) {
            for (UUID cuuid : rsc.getCompanions()) {
                if (!cuuid.equals(uuid)) continue;
                return true;
            }
        }
        return false;
    }
}

