/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.lazarus;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.event.TARDISGeneticManipulatorUndisguiseEvent;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.lazarus.LazarusAdjacentInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusCharacterInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusCompanionInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusDisguise;
import me.eccentric_nz.TARDIS.lazarus.LazarusDoctorInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusGUI;
import me.eccentric_nz.TARDIS.lazarus.LazarusHostileInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusLibsDisguises;
import me.eccentric_nz.TARDIS.lazarus.LazarusMonstersInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusNeutralInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusPassiveInventory;
import me.eccentric_nz.TARDIS.lazarus.LazarusRunnable;
import me.eccentric_nz.TARDIS.lazarus.LazarusUtils;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.skins.Skin;
import me.eccentric_nz.TARDIS.skins.SkinUtils;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import net.kyori.adventure.text.Component;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;

public class LazarusSkinsListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final HashMap<UUID, Integer> skins = new HashMap();

    public LazarusSkinsListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler
    public void onSkinInventoryClick(InventoryClickEvent event) {
        InventoryHolder holder = event.getInventory().getHolder(false);
        if (!(holder instanceof LazarusDoctorInventory || holder instanceof LazarusCompanionInventory || holder instanceof LazarusCharacterInventory || holder instanceof LazarusMonstersInventory)) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        Block b = this.plugin.getTrackerKeeper().getLazarus().get(uuid);
        if (b == null) {
            return;
        }
        int slot = event.getRawSlot();
        if (slot >= 0 && slot < ((LazarusGUI)holder).getMaxSlot()) {
            ItemStack is = event.getView().getItem(slot);
            if (is != null) {
                this.skins.put(uuid, slot);
            }
        } else {
            switch (slot) {
                case 36: 
                case 44: {
                    String which;
                    LazarusUtils.pagers.add(uuid);
                    ItemStack pageButton = event.getView().getItem(slot);
                    ItemMeta pageMeta = pageButton.getItemMeta();
                    Object ih = switch (which = ComponentUtils.stripColour((Component)pageMeta.lore().getFirst())) {
                        case "Passive Mobs" -> new LazarusPassiveInventory(this.plugin);
                        case "Neutral Mobs" -> new LazarusNeutralInventory(this.plugin);
                        case "Hostile Mobs" -> new LazarusHostileInventory(this.plugin);
                        case "Hostile Adjacent Mobs" -> new LazarusAdjacentInventory(this.plugin);
                        case "Doctors" -> new LazarusDoctorInventory(this.plugin);
                        case "Companions" -> new LazarusCompanionInventory(this.plugin);
                        case "Characters" -> new LazarusCharacterInventory(this.plugin);
                        case "Monsters" -> new LazarusMonstersInventory(this.plugin);
                        default -> new LazarusInventory(this.plugin);
                    };
                    player.openInventory(ih.getInventory());
                    break;
                }
                case 40: {
                    LazarusUtils.pagers.add(uuid);
                    player.openInventory(new LazarusInventory(this.plugin).getInventory());
                    break;
                }
                case 51: {
                    this.close(player);
                    if (!this.plugin.getTrackerKeeper().getImmortalityGate().isEmpty()) {
                        this.plugin.getServer().getOnlinePlayers().forEach(p -> {
                            if (this.plugin.isDisguisesOnServer()) {
                                LazarusLibsDisguises.removeDisguise(p);
                            } else {
                                LazarusDisguise.removeDisguise(p);
                            }
                        });
                        this.plugin.getTrackerKeeper().setImmortalityGate("");
                        this.plugin.getPM().callEvent((Event)new TARDISGeneticManipulatorUndisguiseEvent(player));
                    }
                    LazarusRunnable runnable = new LazarusRunnable(this.plugin, b);
                    int taskId = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 6L, 6L);
                    runnable.setTaskID(taskId);
                    TARDISSounds.playTARDISSound(player.getLocation(), "lazarus_machine");
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        LazarusUtils.geneticModificationOff(player);
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "GENETICS_RESTORED");
                    }, 80L);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> LazarusUtils.openDoor(b), 100L);
                    break;
                }
                case 52: {
                    this.close(player);
                    LazarusRunnable runnable = new LazarusRunnable(this.plugin, b);
                    int taskId = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)runnable, 6L, 6L);
                    runnable.setTaskID(taskId);
                    TARDISSounds.playTARDISSound(player.getLocation(), "lazarus_machine");
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                        LazarusUtils.geneticModificationOff(player);
                        int rememberedSlot = this.skins.get(uuid);
                        Skin skin = LazarusUtils.skinForSlot(rememberedSlot, this.getSkinType(holder));
                        if (skin != null) {
                            this.plugin.getSkinChanger().set(player, skin);
                            SkinUtils.setExtras(player, skin);
                            SkinUtils.SKINNED.put(uuid, skin);
                        }
                    }, 80L);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> LazarusUtils.openDoor(b), 100L);
                    break;
                }
                case 53: {
                    this.close(player);
                    LazarusUtils.openDoor(b);
                    this.untrack(player.getUniqueId(), false);
                    break;
                }
            }
        }
    }

    private int getSkinType(InventoryHolder holder) {
        if (holder instanceof LazarusDoctorInventory) {
            return 0;
        }
        if (holder instanceof LazarusCompanionInventory) {
            return 1;
        }
        if (holder instanceof LazarusCharacterInventory) {
            return 2;
        }
        if (holder instanceof LazarusMonstersInventory) {
            return 3;
        }
        return 0;
    }

    private void untrack(UUID uuid, boolean remove) {
        if (!LazarusUtils.pagers.contains(uuid)) {
            this.plugin.getTrackerKeeper().getLazarus().remove(uuid);
        }
        if (remove) {
            this.plugin.getTrackerKeeper().getDisguises().remove(uuid);
        }
        this.plugin.getTrackerKeeper().getGeneticManipulation().remove(uuid);
    }
}

