/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.junk;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.WorldManager;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import org.bukkit.command.CommandSender;

class JunkFind {
    private final TARDIS plugin;

    JunkFind(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean find(CommandSender sender) {
        if (!TARDISPermission.hasPermission(sender, "tardis.junk")) {
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "JUNK_NO_PERM");
            return true;
        }
        ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
        if (rs.fromUUID("00000000-aaaa-bbbb-cccc-000000000000")) {
            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, rs.getTardisId());
            if (rsc.resultSet()) {
                Current current = rsc.getCurrent();
                String world = TARDISAliasResolver.getWorldAlias(current.location().getWorld());
                if (!this.plugin.getPlanetsConfig().getBoolean("planets." + current.location().getWorld().getName() + ".enabled") && this.plugin.getWorldManager().equals((Object)WorldManager.MULTIVERSE)) {
                    world = this.plugin.getMVHelper().getAlias(current.location().getWorld());
                }
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TARDIS_FIND", world + " at x: " + current.location().getBlockX() + " y: " + current.location().getBlockY() + " z: " + current.location().getBlockZ());
            } else {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "JUNK_NOT_FOUND");
            }
            return true;
        }
        return true;
    }
}

