/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.handles;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.handles.HandlesBlock;
import me.eccentric_nz.TARDIS.handles.HandlesCategory;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

class HandlesValidator {
    private final TARDIS plugin;
    private final ItemStack[] program;
    private final Player player;
    private int endCount = 1;
    private int eventCount = 0;

    HandlesValidator(TARDIS plugin, ItemStack[] program, Player player) {
        this.plugin = plugin;
        this.program = program;
        this.player = player;
    }

    boolean validateDisk() {
        int i = 0;
        for (ItemStack is : this.program) {
            if (is != null) {
                HandlesBlock thb = HandlesBlock.BY_NAME.get(ComponentUtils.stripColour(is.getItemMeta().displayName()));
                switch (thb) {
                    case FOR: {
                        if (this.validateFor(i + 1)) break;
                        this.plugin.getMessenger().handlesMessage(this.player, "The FOR loop does not compute!");
                        return false;
                    }
                    case IF: {
                        if (this.validateIF(i + 1)) break;
                        this.plugin.getMessenger().handlesMessage(this.player, "The IF statement does not compute!");
                        return false;
                    }
                    case VARIABLE: {
                        if (this.validateVar(i + 1)) break;
                        this.plugin.getMessenger().handlesMessage(this.player, "The Variable assignment does not compute!");
                        return false;
                    }
                    case X: 
                    case Y: 
                    case Z: {
                        if (this.validateCoordOrMath(i + 1)) break;
                        this.plugin.getMessenger().handlesMessage(this.player, "The Coordinate assignment does not compute!");
                        return false;
                    }
                    case ARTRON: 
                    case DEATH: 
                    case DEMATERIALISE: 
                    case ENTER: 
                    case EXIT: 
                    case HADS: 
                    case LOG_OUT: 
                    case MATERIALISE: 
                    case SIEGE_OFF: 
                    case SIEGE_ON: {
                        if (this.eventCount > 0) {
                            this.plugin.getMessenger().handlesMessage(this.player, "You can only have one event per program!");
                            return false;
                        }
                        ++this.eventCount;
                        break;
                    }
                    case ADDITION: 
                    case SUBTRACTION: 
                    case MULTIPLICATION: 
                    case DIVISION: 
                    case MODULO: 
                    case LESS_THAN: 
                    case LESS_THAN_EQUAL: 
                    case GREATER_THAN: 
                    case GREATER_THAN_EQUAL: {
                        if (this.validateCoordOrMath(i + 1)) break;
                        this.plugin.getMessenger().handlesMessage(this.player, "The Math operation does not compute!");
                        return false;
                    }
                    case RANDOM: {
                        ItemStack pre = this.program[i - 1];
                        HandlesBlock cede = HandlesBlock.BY_NAME.get(ComponentUtils.stripColour(pre.getItemMeta().displayName()));
                        if (HandlesBlock.TRAVEL.equals((Object)cede) || this.validateCoordOrMath(i + 1)) break;
                        this.plugin.getMessenger().handlesMessage(this.player, "The Math operation does not compute!");
                        return false;
                    }
                    case DOOR: {
                        if (this.validateDoor(i + 1)) break;
                        this.plugin.getMessenger().handlesMessage(this.player, "The Door action does not compute!");
                        return false;
                    }
                    case LIGHTS: 
                    case SIEGE: {
                        if (this.validateOnOff(i + 1)) break;
                        this.plugin.getMessenger().handlesMessage(this.player, "The ON / OFF action does not compute!");
                        return false;
                    }
                    case POWER: {
                        if (this.validatePower(i + 1)) break;
                        this.plugin.getMessenger().handlesMessage(this.player, "The Power action does not compute!");
                        return false;
                    }
                    case TRAVEL: {
                        if (this.validateTravel(i + 1)) break;
                        this.plugin.getMessenger().handlesMessage(this.player, "The Travel destination does not compute!");
                        return false;
                    }
                }
            }
            ++i;
        }
        return true;
    }

    private boolean validateVar(int start) {
        ItemStack op = this.program[start];
        if (op == null) {
            return false;
        }
        HandlesBlock thb = HandlesBlock.BY_NAME.get(ComponentUtils.stripColour(op.getItemMeta().displayName()));
        if (!thb.getCategory().equals((Object)HandlesCategory.OPERATOR)) {
            return false;
        }
        ItemStack val = this.program[start];
        if (val == null) {
            return false;
        }
        HandlesBlock thbv = HandlesBlock.BY_NAME.get(ComponentUtils.stripColour(val.getItemMeta().displayName()));
        return thbv.getCategory().equals((Object)HandlesCategory.NUMBER);
    }

    private boolean validateCoordOrMath(int start) {
        ItemStack op = this.program[start];
        if (op == null) {
            return false;
        }
        HandlesBlock thb = HandlesBlock.BY_NAME.get(ComponentUtils.stripColour(op.getItemMeta().displayName()));
        return thb.getCategory().equals((Object)HandlesCategory.NUMBER) || thb.equals((Object)HandlesBlock.SUBTRACTION);
    }

    private boolean validateDoor(int start) {
        ItemStack op = this.program[start];
        if (op == null) {
            return false;
        }
        HandlesBlock thb = HandlesBlock.BY_NAME.get(ComponentUtils.stripColour(op.getItemMeta().displayName()));
        return thb.equals((Object)HandlesBlock.ASSIGNMENT) || thb.equals((Object)HandlesBlock.EQUALS) || thb.equals((Object)HandlesBlock.OPEN) || thb.equals((Object)HandlesBlock.CLOSE) || thb.equals((Object)HandlesBlock.LOCK) || thb.equals((Object)HandlesBlock.UNLOCK);
    }

    private boolean validateOnOff(int start) {
        ItemStack op = this.program[start];
        if (op == null) {
            return false;
        }
        HandlesBlock thb = HandlesBlock.BY_NAME.get(ComponentUtils.stripColour(op.getItemMeta().displayName()));
        return thb.equals((Object)HandlesBlock.ASSIGNMENT) || thb.equals((Object)HandlesBlock.EQUALS) || thb.equals((Object)HandlesBlock.ON) || thb.equals((Object)HandlesBlock.OFF);
    }

    private boolean validatePower(int start) {
        ItemStack op = this.program[start];
        if (op == null) {
            return false;
        }
        HandlesBlock thb = HandlesBlock.BY_NAME.get(ComponentUtils.stripColour(op.getItemMeta().displayName()));
        return thb.equals((Object)HandlesBlock.ASSIGNMENT) || thb.equals((Object)HandlesBlock.EQUALS) || thb.equals((Object)HandlesBlock.ON) || thb.equals((Object)HandlesBlock.OFF) || thb.equals((Object)HandlesBlock.SHOW) || thb.equals((Object)HandlesBlock.REDSTONE);
    }

    private boolean validateTravel(int start) {
        ItemStack op = this.program[start];
        if (op == null) {
            return false;
        }
        HandlesBlock thb = HandlesBlock.BY_NAME.get(ComponentUtils.stripColour(op.getItemMeta().displayName()));
        Material record = op.getType();
        return thb.equals((Object)HandlesBlock.HOME) || thb.equals((Object)HandlesBlock.RECHARGER) || thb.equals((Object)HandlesBlock.X) || thb.equals((Object)HandlesBlock.Y) || thb.equals((Object)HandlesBlock.Z) || thb.equals((Object)HandlesBlock.RANDOM) || record.equals((Object)Material.MUSIC_DISC_CHIRP) || record.equals((Object)Material.MUSIC_DISC_WAIT) || record.equals((Object)Material.MUSIC_DISC_CAT) || record.equals((Object)Material.MUSIC_DISC_BLOCKS);
    }

    private boolean validateFor(int start) {
        int found = 0;
        block7: for (int i = start; i < 36; ++i) {
            ItemStack is = this.program[i];
            if (is == null) {
                if (i != 35) continue;
                return found == this.endCount;
            }
            HandlesBlock thb = HandlesBlock.BY_NAME.get(ComponentUtils.stripColour(is.getItemMeta().displayName()));
            switch (i - start) {
                case 0: {
                    if (thb.getCategory().equals((Object)HandlesCategory.VARIABLE)) continue block7;
                    return false;
                }
                case 1: {
                    if (thb.getDisplayName().equals("Assignment operator")) continue block7;
                    return false;
                }
                case 2: 
                case 4: {
                    if (thb.getCategory().equals((Object)HandlesCategory.NUMBER)) continue block7;
                    return false;
                }
                case 3: {
                    if (thb.equals((Object)HandlesBlock.TO)) continue block7;
                    return false;
                }
                case 5: {
                    if (thb.equals((Object)HandlesBlock.DO)) continue block7;
                    return false;
                }
                default: {
                    if (thb.equals((Object)HandlesBlock.IF)) {
                        ++this.endCount;
                    }
                    if (!thb.equals((Object)HandlesBlock.END) || found++ != this.endCount) continue block7;
                    return true;
                }
            }
        }
        return true;
    }

    private boolean validateIF(int start) {
        boolean twoConditions = false;
        int found = 0;
        block10: for (int i = start; i < 36; ++i) {
            ItemStack is = this.program[i];
            if (is == null) {
                if (i != 35) continue;
                return found == this.endCount;
            }
            HandlesBlock thb = HandlesBlock.BY_NAME.get(ComponentUtils.stripColour(is.getItemMeta().displayName()));
            switch (i - start) {
                case 0: {
                    if (thb.getCategory().equals((Object)HandlesCategory.VARIABLE) || thb.getCategory().equals((Object)HandlesCategory.SELECTOR) || thb.getCategory().equals((Object)HandlesCategory.EVENT)) continue block10;
                    return false;
                }
                case 1: {
                    if (thb.getCategory().equals((Object)HandlesCategory.OPERATOR)) continue block10;
                    return false;
                }
                case 2: {
                    if (thb.getCategory().equals((Object)HandlesCategory.NUMBER) || thb.getCategory().equals((Object)HandlesCategory.EVENT) || thb.getCategory().equals((Object)HandlesCategory.VARIABLE)) continue block10;
                    return false;
                }
                case 3: {
                    if (thb.equals((Object)HandlesBlock.AND) || thb.equals((Object)HandlesBlock.OR)) {
                        twoConditions = true;
                        continue block10;
                    }
                    if (thb.equals((Object)HandlesBlock.DO)) continue block10;
                    return false;
                }
                case 4: {
                    if (twoConditions && !thb.getCategory().equals((Object)HandlesCategory.VARIABLE) && !thb.getCategory().equals((Object)HandlesCategory.SELECTOR) && !thb.getCategory().equals((Object)HandlesCategory.EVENT)) {
                        return false;
                    }
                    if (thb.equals((Object)HandlesBlock.IF)) {
                        ++this.endCount;
                    }
                    if (!thb.equals((Object)HandlesBlock.END) || found++ != this.endCount) continue block10;
                    return true;
                }
                case 5: {
                    if (twoConditions && !thb.getCategory().equals((Object)HandlesCategory.OPERATOR)) {
                        return false;
                    }
                    if (thb.equals((Object)HandlesBlock.IF)) {
                        ++this.endCount;
                    }
                    if (!thb.equals((Object)HandlesBlock.END) || found++ != this.endCount) continue block10;
                    return true;
                }
                case 6: {
                    if (twoConditions && !thb.getCategory().equals((Object)HandlesCategory.NUMBER) && !thb.getCategory().equals((Object)HandlesCategory.EVENT) && !thb.getCategory().equals((Object)HandlesCategory.VARIABLE)) {
                        return false;
                    }
                    if (thb.equals((Object)HandlesBlock.IF)) {
                        ++this.endCount;
                    }
                    if (!thb.equals((Object)HandlesBlock.END) || found++ != this.endCount) continue block10;
                    return true;
                }
                case 7: {
                    if (twoConditions && !thb.equals((Object)HandlesBlock.DO)) {
                        return false;
                    }
                    if (thb.equals((Object)HandlesBlock.IF)) {
                        ++this.endCount;
                    }
                    if (!thb.equals((Object)HandlesBlock.END) || found++ != this.endCount) continue block10;
                    return true;
                }
                default: {
                    if (thb.equals((Object)HandlesBlock.IF)) {
                        ++this.endCount;
                    }
                    if (!thb.equals((Object)HandlesBlock.END) || found++ != this.endCount) continue block10;
                    return true;
                }
            }
        }
        return true;
    }
}

