/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.desktop.DesktopThemeProcessor;
import me.eccentric_nz.TARDIS.desktop.UpgradeData;
import me.eccentric_nz.TARDIS.rooms.TARDISWalls;
import org.bukkit.Material;
import org.geysermc.cumulus.form.CustomForm;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.response.CustomFormResponse;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateWallFloorForm {
    private final TARDIS plugin;
    private final UUID uuid;
    private final String which;
    private final List<String> blocks = new ArrayList<String>();

    public FloodgateWallFloorForm(TARDIS plugin, UUID uuid, String which) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.which = which;
        this.blocks.add("Default");
        for (Material mat : TARDISWalls.BLOCKS) {
            this.blocks.add(mat.toString());
        }
    }

    public void send() {
        CustomForm form = (CustomForm)((CustomForm.Builder)((CustomForm.Builder)CustomForm.builder().title("TARDIS " + this.which + " Menu")).dropdown("Material", this.blocks).validResultHandler(this::handleResponse)).build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(CustomFormResponse response) {
        UpgradeData tud = this.plugin.getTrackerKeeper().getUpgrades().get(this.uuid);
        String m = this.blocks.get(response.asDropdown(0));
        if (m.equals("Default")) {
            String string = m = this.which.equals("Wall") ? "ORANGE_WOOL" : "LIGHT_GRAY_WOOL";
        }
        if (this.which.equals("Wall")) {
            tud.setWall(m);
            new FloodgateWallFloorForm(this.plugin, this.uuid, "Floor").send();
        } else {
            tud.setFloor(m);
            new DesktopThemeProcessor(this.plugin, this.uuid).changeDesktop();
        }
    }
}

