/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.enumeration;

import java.util.HashMap;

public enum Control {
    HANDBRAKE(0, "handbrake", false, true),
    RANDOM(1, "button", false, true),
    WORLD(2, "world-repeater", false, false),
    X(3, "x-repeater", false, false),
    Z(4, "z-repeater", false, false),
    MULTIPLIER(5, "y-repeater", false, false),
    ARTRON(6, "artron", false, false),
    KEYBOARD(7, "keyboard", false, false),
    BACK(8, "back", false, true),
    TERMINAL(9, "terminal", false, true),
    ARS(10, "ars", false, true),
    TEMPORAL(11, "temporal", false, false),
    LIGHT_SWITCH(12, "light", false, true),
    TARDIS_INFORMATION_SYSTEM(13, "info", true, false),
    DISK_CIRCUIT_STORAGE(14, "storage", false, false),
    ADVANCED_CONSOLE(15, "advanced", false, false),
    ZERO_ENTRY(16, "zero", false, true),
    ZERO_EXIT(17, "", true, false),
    DIRECTION(18, "direction", false, true),
    LAZARUS_DEVICE(19, "", false, true),
    DOOR_TOGGLE_WOOL(20, "toggle_wool", false, true),
    SIEGE(21, "siege", false, false),
    CONTROLS(22, "control", true, false),
    TELEPATHIC_CIRCUIT(23, "telepathic", false, false),
    SONIC_GENERATOR(24, "generator", false, true),
    SHELL(25, "shell", false, true),
    HANDLES(26, "handles", false, false),
    FRAME(27, "frame", false, false),
    DISPENSER(28, "dispenser", false, false),
    FORCE_FIELD(29, "forcefield", false, true),
    FLIGHT(30, "flight", false, false),
    CHAMELEON(31, "chameleon", false, true),
    SAVES(32, "save-sign", false, true),
    SCANNER(33, "scanner", false, false),
    CONDENSER(34, "condenser", false, false),
    CLOISTER_BELL(35, "bell", true, false),
    ROTOR(36, "", false, false),
    MAP(37, "map", false, false),
    WEATHER(38, "weather", false, false),
    THROTTLE(39, "throttle", false, true),
    MAZE_NORTH(40, "", true, false),
    MAZE_WEST(41, "", true, false),
    MAZE_EAST(42, "", true, false),
    MAZE_SOUTH(43, "", true, false),
    MAZE_SPAWN(44, "", false, false),
    MONITOR(45, "monitor", false, false),
    MONITOR_FRAME(46, "monitor-frame", true, false),
    RELATIVITY_DIFFERENTIATOR(47, "relativity-differentiator", false, true),
    SONIC_DOCK(48, "sonic-dock", false, true),
    EXTERIOR_LAMP(49, "exterior-lamp", false, true),
    LIGHT_LEVEL(50, "light-level", false, true),
    SCREEN(51, "screen", true, false),
    JUNK_FIND(52, "", true, false),
    EYE(53, "", true, false),
    EYE_STORAGE(54, "", true, false),
    TELEVISION(55, "television", false, false),
    CONSOLE_LAMP(56, "console-lamp", false, false),
    CONSOLE_LAMP_SWITCH(57, "console-lamp-switch", false, false),
    HAPPY_GHAST_DOCK_LEVER(58, "happy-ghast-dock-lever", false, false),
    ARCHITECTURAL(59, "", false, false),
    NAUTILUS(60, "nautilus", false, true),
    WASHING_MACHINE(61, "washing-machine", false, false),
    COMPUTER_MOUSE(62, "computer-mouse", false, false);

    private static final HashMap<String, Integer> UPDATE_CONTROLS;
    private static final HashMap<Integer, Control> BY_ID;
    private final int id;
    private final String update;
    private final boolean unpowered;
    private final boolean noSiege;

    private Control(int id, String update, boolean unpowered, boolean noSiege) {
        this.id = id;
        this.update = update;
        this.unpowered = unpowered;
        this.noSiege = noSiege;
    }

    public static HashMap<String, Integer> getUPDATE_CONTROLS() {
        return UPDATE_CONTROLS;
    }

    public static HashMap<Integer, Control> getById() {
        return BY_ID;
    }

    public int getId() {
        return this.id;
    }

    public boolean allowUnpowered() {
        return this.unpowered;
    }

    public boolean isNoSiege() {
        return this.noSiege;
    }

    static {
        UPDATE_CONTROLS = new HashMap();
        BY_ID = new HashMap();
        for (Control control : Control.values()) {
            if (!control.update.isEmpty()) {
                UPDATE_CONTROLS.put(control.update, control.id);
            }
            BY_ID.put(control.id, control);
        }
    }
}

