/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.converters;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;

public class ShopTransfer {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final String prefix;

    public ShopTransfer(TARDIS plugin) {
        this.plugin = plugin;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean transferData() {
        Connection shop = this.getSQLiteConnection();
        if (shop != null) {
            int i = 0;
            PreparedStatement statement = null;
            Statement ps = null;
            ResultSet rs = null;
            String queryItem = "SELECT * FROM items";
            String insertItem = "INSERT INTO " + this.prefix + "items (`item`, `location`, `cost`) VALUES (?, ?, ?)";
            try {
                this.connection.setAutoCommit(false);
                statement = shop.prepareStatement(queryItem);
                ps = this.connection.prepareStatement(insertItem);
                rs = statement.executeQuery();
                if (rs.isBeforeFirst()) {
                    while (rs.next()) {
                        ps.setString(1, rs.getString("item"));
                        ps.setString(2, rs.getString("location"));
                        ps.setFloat(3, rs.getFloat("cost"));
                        ps.addBatch();
                        ++i;
                    }
                }
                if (i > 0) {
                    ps.executeBatch();
                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "Transferred " + i + " shop items to database");
                }
                this.connection.commit();
                boolean bl = true;
                return bl;
            }
            catch (SQLException e) {
                this.plugin.debug("Transfer error for items table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (ps != null) {
                        ps.close();
                    }
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                    this.connection.setAutoCommit(true);
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing items transfer! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public Connection getSQLiteConnection() {
        Connection sqlite = null;
        String path = String.valueOf(this.plugin.getServer().getWorldContainer()) + File.separator + "plugins" + File.separator + "TARDISShop" + File.separator + "TARDISShop.db";
        File file = new File(path);
        if (file.exists()) {
            try {
                Class.forName("org.sqlite.JDBC");
                sqlite = DriverManager.getConnection("jdbc:sqlite:" + path);
                sqlite.setAutoCommit(true);
            }
            catch (ClassNotFoundException | SQLException e) {
                this.plugin.debug("Cannot connect the Vortex Manipulator database! " + e.getMessage());
            }
        }
        return sqlite;
    }
}

