/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.customblocks;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemRegistry;
import me.eccentric_nz.TARDIS.database.data.Lamp;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLamps;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Chunk;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.Levelled;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Display;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Mannequin;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;

public class TARDISDisplayItemUtils {
    public static TARDISDisplayItem get(ItemDisplay display) {
        ItemStack is = display.getItemStack();
        if (is != null) {
            TARDISDisplayItem displayItem;
            ItemMeta im = is.getItemMeta();
            if (im.hasItemModel()) {
                if (Tag.ITEMS_DECORATED_POT_SHERDS.isTagged((Keyed)is.getType())) {
                    return TARDISBlockDisplayItem.CUSTOM_DOOR;
                }
                return TARDISDisplayItemRegistry.getByModel(im.getItemModel());
            }
            if (im.hasDisplayName() && (displayItem = TARDISDisplayItemRegistry.getByDisplayName(im.displayName())) != null) {
                return displayItem;
            }
            if (im.getPersistentDataContainer().has(TARDIS.plugin.getCustomBlockKey())) {
                String str = (String)im.getPersistentDataContainer().get(TARDIS.plugin.getCustomBlockKey(), PersistentDataType.STRING);
                NamespacedKey nsk = new NamespacedKey((Plugin)TARDIS.plugin, str);
                return TARDISDisplayItemRegistry.getByModel(nsk);
            }
        }
        return null;
    }

    public static ItemDisplay get(Block block) {
        for (Entity e : block.getWorld().getNearbyEntities(block.getBoundingBox().expand(0.1), d -> d.getType() == EntityType.ITEM_DISPLAY)) {
            if (!(e instanceof ItemDisplay)) continue;
            ItemDisplay display = (ItemDisplay)e;
            return display;
        }
        return null;
    }

    public static Set<ItemDisplay> getAll(Block block) {
        HashSet<ItemDisplay> displays = new HashSet<ItemDisplay>();
        int x = block.getLocation().getBlockX();
        int y = block.getLocation().getBlockY();
        int z = block.getLocation().getBlockZ();
        BoundingBox box = new BoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        for (Entity e : block.getWorld().getNearbyEntities(box.expand(0.1), d -> d.getType() == EntityType.ITEM_DISPLAY)) {
            if (!(e instanceof ItemDisplay)) continue;
            ItemDisplay display = (ItemDisplay)e;
            displays.add(display);
        }
        return displays;
    }

    public static Set<ItemDisplay> getAll(Interaction interaction) {
        HashSet<ItemDisplay> displays = new HashSet<ItemDisplay>();
        for (Entity e : interaction.getWorld().getNearbyEntities(interaction.getBoundingBox().expand(0.1), d -> d.getType() == EntityType.ITEM_DISPLAY)) {
            if (!(e instanceof ItemDisplay)) continue;
            ItemDisplay display = (ItemDisplay)e;
            displays.add(display);
        }
        return displays;
    }

    public static ItemDisplay getFromBoundingBox(Block block) {
        while (!block.getChunk().isLoaded()) {
            block.getChunk().load();
        }
        int x = block.getLocation().getBlockX();
        int y = block.getLocation().getBlockY();
        int z = block.getLocation().getBlockZ();
        BoundingBox box = new BoundingBox((double)x, (double)y, (double)z, (double)(x + 1), (double)(y + 1), (double)(z + 1));
        for (Entity e : block.getWorld().getNearbyEntities(box.expand(0.1), d -> d.getType() == EntityType.ITEM_DISPLAY)) {
            if (!(e instanceof ItemDisplay)) continue;
            ItemDisplay display = (ItemDisplay)e;
            return display;
        }
        return null;
    }

    public static void remove(Block block) {
        for (Entity e : block.getWorld().getNearbyEntities(block.getLocation().add(0.5, 0.5, 0.5), 0.55, 0.55, 0.55, d -> d.getType() == EntityType.INTERACTION || d.getType() == EntityType.ITEM_DISPLAY || d.getType() == EntityType.TEXT_DISPLAY || d.getType() == EntityType.ITEM_FRAME || d.getType() == EntityType.GLOW_ITEM_FRAME || d.getType() == EntityType.MANNEQUIN)) {
            if (!(e instanceof Interaction) && !(e instanceof ItemDisplay) && !(e instanceof TextDisplay) && !(e instanceof ItemFrame) && !(e instanceof Mannequin)) continue;
            e.remove();
        }
    }

    public static ItemDisplay get(Interaction interaction) {
        for (Entity e : interaction.getWorld().getNearbyEntities(interaction.getBoundingBox().expand(0.1), d -> d.getType() == EntityType.ITEM_DISPLAY)) {
            if (!(e instanceof ItemDisplay)) continue;
            ItemDisplay display = (ItemDisplay)e;
            return display;
        }
        return null;
    }

    public static ItemDisplay getSonic(Interaction interaction) {
        for (Entity e : interaction.getWorld().getNearbyEntities(interaction.getBoundingBox().expand(0.75), d -> d.getType() == EntityType.ITEM_DISPLAY)) {
            ItemDisplay display;
            ItemStack is;
            if (!(e instanceof ItemDisplay) || !TARDISStaticUtils.isSonic(is = (display = (ItemDisplay)e).getItemStack())) continue;
            return display;
        }
        return null;
    }

    public static TextDisplay getText(Interaction interaction) {
        for (Entity e : interaction.getWorld().getNearbyEntities(interaction.getBoundingBox().expand(0.1), d -> d.getType() == EntityType.TEXT_DISPLAY)) {
            if (!(e instanceof TextDisplay)) continue;
            TextDisplay display = (TextDisplay)e;
            return display;
        }
        return null;
    }

    public static Interaction getInteraction(Location location) {
        while (!location.getChunk().isLoaded()) {
            location.getChunk().load();
        }
        for (Entity e : location.getWorld().getNearbyEntities(location, 1.5, 3.0, 1.5, d -> d.getType() == EntityType.INTERACTION)) {
            if (!(e instanceof Interaction)) continue;
            Interaction interaction = (Interaction)e;
            return interaction;
        }
        return null;
    }

    public static Interaction getInteraction(Block block) {
        Location location = block.getLocation().clone();
        while (!location.getChunk().isLoaded()) {
            location.getChunk().load();
        }
        for (Entity e : block.getWorld().getNearbyEntities(block.getLocation().add(0.5, 0.5, 0.5), 0.55, 0.55, 0.55, d -> d.getType() == EntityType.INTERACTION)) {
            if (!(e instanceof Interaction)) continue;
            Interaction interaction = (Interaction)e;
            return interaction;
        }
        return null;
    }

    public static void set(TARDISDisplayItem tdi, World world, int x, int y, int z) {
        ItemStack is = ItemStack.of((Material)tdi.getMaterial(), (int)1);
        ItemMeta im = is.getItemMeta();
        if (tdi.isSeed()) {
            im.displayName((Component)ComponentUtils.toGold(tdi.getDisplayName()));
        } else {
            im.displayName((Component)ComponentUtils.toWhite(tdi.getDisplayName()));
        }
        im.getPersistentDataContainer().set(TARDIS.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)tdi.getCustomModel().getKey());
        is.setItemMeta(im);
        Location l = new Location(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        ItemDisplay display = (ItemDisplay)world.spawnEntity(l, EntityType.ITEM_DISPLAY);
        display.setItemStack(is);
        display.setPersistent(true);
        display.setInvulnerable(true);
        display.getPersistentDataContainer().set(TARDIS.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)tdi.getCustomModel().getKey());
    }

    public static ItemStack setAndReturnStack(TARDISDisplayItem tdi, World world, int x, int y, int z) {
        ItemStack is = ItemStack.of((Material)tdi.getMaterial(), (int)1);
        ItemMeta im = is.getItemMeta();
        if (tdi.isSeed()) {
            im.displayName((Component)ComponentUtils.toGold(tdi.getDisplayName()));
        } else {
            im.displayName((Component)ComponentUtils.toWhite(tdi.getDisplayName()));
        }
        im.getPersistentDataContainer().set(TARDIS.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)tdi.getCustomModel().getKey());
        is.setItemMeta(im);
        Location l = new Location(world, (double)x + 0.5, (double)y + 0.5, (double)z + 0.5);
        ItemDisplay display = (ItemDisplay)world.spawnEntity(l, EntityType.ITEM_DISPLAY);
        display.setItemStack(is);
        display.setPersistent(true);
        display.setInvulnerable(true);
        display.getPersistentDataContainer().set(TARDIS.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)tdi.getCustomModel().getKey());
        return is;
    }

    public static ItemDisplay set(TARDISDisplayItem tdi, Block block, int id) {
        NamespacedKey namespacedKey = tdi.getCustomModel();
        if (namespacedKey == null) {
            namespacedKey = tdi.getMaterial().getKey();
        }
        if (tdi.isClosedDoor() || tdi.isLight()) {
            Interaction interaction = (Interaction)block.getWorld().spawnEntity(block.getLocation().clone().add(0.5, 0.0, 0.5), EntityType.INTERACTION);
            interaction.setResponsive(true);
            interaction.getPersistentDataContainer().set(TARDIS.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)namespacedKey.getKey());
            interaction.setPersistent(true);
            if (tdi == TARDISBlockDisplayItem.DOOR) {
                interaction.setInteractionHeight(2.0f);
                interaction.setInteractionWidth(1.0f);
                interaction.getPersistentDataContainer().set(TARDIS.plugin.getTardisIdKey(), PersistentDataType.INTEGER, (Object)id);
            }
            if (tdi == TARDISBlockDisplayItem.CLASSIC_DOOR || tdi == TARDISBlockDisplayItem.BONE_DOOR || tdi == TARDISBlockDisplayItem.SIDRAT_DOOR) {
                interaction.setInteractionHeight(3.0f);
                interaction.setInteractionWidth(1.0f);
                interaction.getPersistentDataContainer().set(TARDIS.plugin.getTardisIdKey(), PersistentDataType.INTEGER, (Object)id);
            }
            if (tdi.isLight()) {
                Levelled light = TARDISConstants.LIGHT;
                HashMap<String, Object> whereLight = new HashMap<String, Object>();
                whereLight.put("location", block.getLocation());
                ResultSetLamps rsl = new ResultSetLamps(TARDIS.plugin, whereLight, false);
                if (rsl.getLamp() != null) {
                    Lamp l = rsl.getLamp();
                    light.setLevel(tdi.isLit() ? Math.round(15.0f * l.percentage()) : 0);
                } else {
                    light.setLevel(tdi.isLit() ? 15 : 0);
                }
                block.setBlockData((BlockData)light);
            }
        } else if (tdi != TARDISBlockDisplayItem.ARTRON_FURNACE && tdi != TARDISBlockDisplayItem.SONIC_GENERATOR) {
            block.setBlockData(TARDISConstants.BARRIER);
        }
        Material material = tdi == TARDISBlockDisplayItem.CLASSIC_DOOR || tdi == TARDISBlockDisplayItem.BONE_DOOR || tdi == TARDISBlockDisplayItem.SIDRAT_DOOR ? tdi.getCraftMaterial() : tdi.getMaterial();
        ItemStack is = ItemStack.of((Material)material, (int)1);
        ItemMeta im = is.getItemMeta();
        im.displayName((Component)ComponentUtils.toWhite(tdi.getDisplayName()));
        im.getPersistentDataContainer().set(TARDIS.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)namespacedKey.getKey());
        if (tdi.isDoor()) {
            im.setItemModel(tdi.getCustomModel());
        }
        is.setItemMeta(im);
        double ay = tdi.isClosedDoor() ? 0.0 : 0.5;
        ItemDisplay display = (ItemDisplay)block.getWorld().spawnEntity(block.getLocation().add(0.5, ay, 0.5), EntityType.ITEM_DISPLAY);
        display.setItemStack(is);
        if (tdi.isClosedDoor() || tdi == TARDISBlockDisplayItem.UNTEMPERED_SCHISM) {
            display.setItemDisplayTransform(ItemDisplay.ItemDisplayTransform.FIXED);
        }
        display.setPersistent(true);
        display.setInvulnerable(true);
        display.getPersistentDataContainer().set(TARDIS.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)tdi.getCustomModel().getKey());
        if (tdi == TARDISBlockDisplayItem.ARTRON_FURNACE) {
            display.setBrightness(new Display.Brightness(15, 15));
        }
        return display;
    }

    public static void setSeed(TARDISDisplayItem tdi, Block block, ItemMeta im) {
        block.setBlockData(TARDISConstants.BARRIER);
        ItemStack is = ItemStack.of((Material)tdi.getMaterial(), (int)1);
        is.setItemMeta(im);
        ItemDisplay display = (ItemDisplay)block.getWorld().spawnEntity(block.getLocation().add(0.5, 0.5, 0.5), EntityType.ITEM_DISPLAY);
        display.setItemStack(is);
        display.setPersistent(true);
        display.setInvulnerable(true);
    }

    public static void set(Location location, String key, boolean isDoor) {
        Interaction interaction = (Interaction)location.getWorld().spawnEntity(location.clone().add(0.5, 0.0, 0.5), EntityType.INTERACTION);
        interaction.getPersistentDataContainer().set(TARDIS.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)key);
        interaction.setResponsive(true);
        interaction.setPersistent(true);
        interaction.setInvulnerable(true);
        if (isDoor) {
            interaction.setInteractionHeight(2.0f);
            interaction.setInteractionWidth(1.0f);
        }
    }

    public static void setInteraction(ArmorStand stand, int id) {
        Location location = stand.getLocation();
        Interaction interaction = (Interaction)location.getWorld().spawnEntity(location, EntityType.INTERACTION);
        interaction.getPersistentDataContainer().set(TARDIS.plugin.getTardisIdKey(), PersistentDataType.INTEGER, (Object)id);
        interaction.getPersistentDataContainer().set(TARDIS.plugin.getStandUuidKey(), TARDIS.plugin.getPersistentDataTypeUUID(), (Object)stand.getUniqueId());
        interaction.setResponsive(true);
        interaction.setPersistent(true);
        interaction.setInvulnerable(true);
        interaction.setInteractionHeight(2.5f);
        interaction.setInteractionWidth(1.5f);
    }

    public static void setInteraction(Block block, int id) {
        Location location = block.getLocation().clone().add(0.5, 0.0, 0.5);
        Interaction interaction = (Interaction)location.getWorld().spawnEntity(location, EntityType.INTERACTION);
        interaction.getPersistentDataContainer().set(TARDIS.plugin.getTardisIdKey(), PersistentDataType.INTEGER, (Object)id);
        interaction.setResponsive(true);
        interaction.setPersistent(true);
        interaction.setInvulnerable(true);
        interaction.setInteractionHeight(4.0f);
        interaction.setInteractionWidth(3.0f);
    }

    public static void removeEntitiesInChunk(Chunk chunk, int lower, int upper) {
        for (Entity entity : chunk.getEntities()) {
            int y;
            if (!(entity instanceof ItemDisplay) && !(entity instanceof Interaction) && !(entity instanceof ItemFrame) && !(entity instanceof Mannequin) && !(entity instanceof ArmorStand) || (y = entity.getLocation().getBlockY()) < lower || y > upper) continue;
            entity.remove();
        }
    }
}

