/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.control.actions;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.siegemode.SiegeMode;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

public class SiegeAction {
    private final TARDIS plugin;

    public SiegeAction(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void clickButton(CircuitChecker tcc, Player player, boolean powered, int id) {
        if (tcc != null && !tcc.hasMaterialisation()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_MAT_CIRCUIT");
            return;
        }
        if (!this.plugin.getConfig().getBoolean("siege.enabled")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_DISABLED");
            return;
        }
        UUID uuid = player.getUniqueId();
        if (this.plugin.getTrackerKeeper().getRebuildCooldown().containsKey(uuid)) {
            long now = System.currentTimeMillis();
            long cooldown = this.plugin.getConfig().getLong("police_box.rebuild_cooldown");
            long then = this.plugin.getTrackerKeeper().getRebuildCooldown().get(uuid) + cooldown;
            if (now < then) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COOLDOWN", String.format("%d", cooldown / 1000L));
                return;
            }
        }
        if (this.plugin.getConfig().getBoolean("allow.power_down") && !powered) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
            return;
        }
        HashMap<String, Object> wherein = new HashMap<String, Object>();
        wherein.put("uuid", uuid.toString());
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wherein, false);
        if (rst.resultSet() && this.plugin.getTrackerKeeper().getHasDestination().containsKey(id)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TARDIS_NO_REBUILD");
            return;
        }
        if (this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
            this.plugin.getMessenger().send((CommandSender)player.getPlayer(), TardisModule.TARDIS, "NOT_IN_VORTEX");
            return;
        }
        if (this.plugin.getTrackerKeeper().getInVortex().contains(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getDematerialising().contains(id)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_WHILE_MAT");
            return;
        }
        if (this.plugin.getTrackerKeeper().getIsSiegeCube().contains(id)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SIEGE_CUBED");
            return;
        }
        this.plugin.getTrackerKeeper().getRebuildCooldown().put(uuid, System.currentTimeMillis());
        new SiegeMode(this.plugin).toggleViaSwitch(id, player);
    }
}

