/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.control;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.artron.AdaptiveBoxLampToggler;
import me.eccentric_nz.TARDIS.artron.BeaconToggler;
import me.eccentric_nz.TARDIS.artron.PresetLampToggler;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetLightLevelLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Control;
import me.eccentric_nz.TARDIS.enumeration.TardisLight;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.sensor.PowerSensor;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.BoundingBox;

public class TARDISPowerButton {
    private final TARDIS plugin;
    private final int id;
    private final Player player;
    private final ChameleonPreset preset;
    private final boolean powered;
    private final boolean hidden;
    private final boolean lights;
    private final Location loc;
    private final int level;
    private final TardisLight light;

    public TARDISPowerButton(TARDIS plugin, int id, Player player, ChameleonPreset preset, boolean powered, boolean hidden, boolean lights, Location loc, int level, TardisLight light) {
        this.plugin = plugin;
        this.id = id;
        this.player = player;
        this.preset = preset;
        this.powered = powered;
        this.hidden = hidden;
        this.lights = lights;
        this.loc = loc;
        this.level = level;
        this.light = light;
    }

    public void clickButton() {
        Location location;
        ItemFrame frame;
        ResultSetLightLevelLocation rsllx;
        Location location2;
        ItemFrame frame2;
        HashMap<String, Object> wherep = new HashMap<String, Object>();
        wherep.put("tardis_id", this.id);
        HashMap<String, Object> setp = new HashMap<String, Object>();
        boolean isAdaptive = this.preset.equals((Object)ChameleonPreset.ADAPTIVE);
        UUID uuid = this.player.getUniqueId();
        if (this.powered) {
            if (this.isTravelling(this.id)) {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "POWER_NO");
                return;
            }
            TARDISSounds.playTARDISSound(this.loc, "power_down");
            setp.put("powered_on", 0);
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "POWER_OFF");
            long delay = 0L;
            if (this.hidden) {
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "tardisremote " + this.player.getName() + " rebuild");
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "POWER_FAIL");
                delay = 20L;
            }
            if (isAdaptive || this.preset.usesArmourStand()) {
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new AdaptiveBoxLampToggler(this.plugin).toggleLamp(this.id, false, this.preset), delay);
            }
            if (this.lights) {
                new PresetLampToggler(this.plugin).flickSwitch(this.id, uuid, true, this.light);
            }
            new BeaconToggler(this.plugin).flickSwitch(uuid, this.id, false);
            if (this.plugin.getTrackerKeeper().getActiveForceFields().containsKey(uuid)) {
                this.plugin.getTrackerKeeper().getActiveForceFields().remove(uuid);
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "FORCE_FIELD", "OFF");
            }
        } else {
            if (this.level <= this.plugin.getArtronConfig().getInt("standby")) {
                this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "POWER_LOW");
                return;
            }
            TARDISSounds.playTARDISSound(this.loc, "power_up");
            setp.put("powered_on", 1);
            this.plugin.getMessenger().send((CommandSender)this.player, TardisModule.TARDIS, "POWER_ON");
            if (this.lights) {
                new PresetLampToggler(this.plugin).flickSwitch(this.id, uuid, false, this.light);
            }
            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid.toString());
            boolean beacon_on = true;
            if (rsp.resultSet()) {
                beacon_on = rsp.isBeaconOn();
            }
            if (beacon_on) {
                new BeaconToggler(this.plugin).flickSwitch(uuid, this.id, true);
            }
            if (isAdaptive || this.preset.usesArmourStand()) {
                new AdaptiveBoxLampToggler(this.plugin).toggleLamp(this.id, true, this.preset);
            }
        }
        new PowerSensor(this.plugin, this.id).toggle();
        this.plugin.getQueryFactory().doUpdate("tardis", setp, wherep);
        ResultSetLightLevelLocation rslls = new ResultSetLightLevelLocation(this.plugin, this.id, 50);
        if (rslls.resultSet() && (frame2 = this.getFrame((location2 = TARDISStaticLocationGetters.getLocationFromBukkitString(rslls.getLocation())).getBlock())) != null) {
            this.setFrame(frame2, !this.powered, Control.LIGHT_LEVEL);
        }
        if ((rsllx = new ResultSetLightLevelLocation(this.plugin, this.id, 49)).resultSet() && (frame = this.getFrame((location = TARDISStaticLocationGetters.getLocationFromBukkitString(rsllx.getLocation())).getBlock())) != null) {
            this.setFrame(frame, !this.powered, Control.EXTERIOR_LAMP);
        }
    }

    private boolean isTravelling(int id) {
        return this.plugin.getTrackerKeeper().getDematerialising().contains(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getInVortex().contains(id);
    }

    private ItemFrame getFrame(Block block) {
        BoundingBox box = new BoundingBox((double)block.getX(), (double)block.getY(), (double)block.getZ(), (double)(block.getX() + 1), (double)(block.getY() + 1), (double)(block.getZ() + 1)).expand(0.1);
        for (Entity e : block.getWorld().getNearbyEntities(box, d -> d.getType() == EntityType.ITEM_FRAME)) {
            if (!(e instanceof ItemFrame)) continue;
            ItemFrame frame = (ItemFrame)e;
            return frame;
        }
        return null;
    }

    private void setFrame(ItemFrame frame, boolean on, Control control) {
        ItemStack is = frame.getItem();
        ItemMeta im = is.getItemMeta();
        NamespacedKey model = im.getItemModel();
        String key = control == Control.LIGHT_LEVEL ? (model == null ? (on ? "block/control/light_0" : "block/control/light_0_off") : model.getKey()) : (model == null ? (on ? "block/control/lamp_0" : "block/control/lamp_0_off") : model.getKey());
        NamespacedKey nsk = on ? new NamespacedKey((Plugin)this.plugin, key.replace("_off", "")) : new NamespacedKey((Plugin)this.plugin, key + "_off");
        im.setItemModel(nsk);
        is.setItemMeta(im);
        frame.setItem(is);
    }
}

