/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.tardis;

import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.advanced.CircuitChecker;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.utility.ZeroRoomBuilder;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCondenser;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.messaging.TARDISRoomLister;
import me.eccentric_nz.TARDIS.rooms.CondenserData;
import me.eccentric_nz.TARDIS.rooms.RoomSeedData;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

class RoomCommand {
    private final TARDIS plugin;

    RoomCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    boolean startRoom(Player player, String[] args) {
        UUID uuid = player.getUniqueId();
        if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(uuid.toString(), SystemTree.ROOM_GROWING)) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Room Growing");
            return true;
        }
        if (args.length < 2) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TOO_FEW_ARGS");
            return false;
        }
        String room = args[1].toUpperCase(Locale.ROOT);
        if (room.equals("ARCADE")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "GAME_ARCADE");
            return true;
        }
        if (room.equals("HELP") || !this.plugin.getGeneralKeeper().getRoomArgs().contains(room)) {
            new TARDISRoomLister(this.plugin, player).list();
            return true;
        }
        String perm = "tardis.room." + args[1].toLowerCase(Locale.ROOT);
        if (!TARDISPermission.hasPermission(player, perm) && !TARDISPermission.hasPermission(player, "tardis.room")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERM_ROOM_TYPE");
            return true;
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (!rs.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_A_TIMELORD");
            return true;
        }
        Tardis tardis = rs.getTardis();
        if (this.plugin.getConfig().getBoolean("allow.power_down") && !tardis.isPoweredOn()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_DOWN");
            return true;
        }
        if (!this.plugin.getUtils().canGrowRooms(tardis.getChunk())) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ROOM_OWN_WORLD");
            return true;
        }
        if (!tardis.getRenderer().isEmpty() && room.equals("RENDERER")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "RENDER_EXISTS");
            return true;
        }
        int id = tardis.getTardisId();
        CircuitChecker tcc = null;
        if (this.plugin.getConfig().getBoolean("difficulty.circuits") && !this.plugin.getUtils().inGracePeriod(player, true)) {
            tcc = new CircuitChecker(this.plugin, id);
            tcc.getCircuits();
        }
        if (tcc != null && !tcc.hasARS()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ARS_MISSING");
            return true;
        }
        int level = tardis.getArtronLevel();
        String chunk = tardis.getChunk();
        Schematic schm = tardis.getSchematic();
        int tips = tardis.getTIPS();
        HashMap<String, Object> wheret = new HashMap<String, Object>();
        wheret.put("uuid", uuid.toString());
        wheret.put("tardis_id", id);
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheret, false);
        if (!rst.resultSet()) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_IN_TARDIS");
            return true;
        }
        if (level < this.plugin.getRoomsConfig().getInt("rooms." + room + ".cost")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_NO_ROOM");
            return true;
        }
        if (this.plugin.getConfig().getBoolean("growth.rooms_require_blocks")) {
            boolean hasRequired = true;
            HashMap<String, Integer> roomBlocks = this.plugin.getBuildKeeper().getRoomBlockCounts().get(room);
            String wall = "ORANGE_WOOL";
            String floor = "LIGHT_GRAY_WOOL";
            boolean hasPrefs = false;
            ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid.toString());
            if (rsp.resultSet()) {
                hasPrefs = true;
                wall = rsp.getWall();
                floor = rsp.getFloor();
            }
            HashMap<String, Integer> item_counts = new HashMap<String, Integer>();
            for (Map.Entry<String, Integer> entry : roomBlocks.entrySet()) {
                int required;
                String mat;
                String[] block_data = entry.getKey().split(":");
                String bid = block_data[0];
                String block_id = hasPrefs && block_data.length == 2 && (block_data[1].equals("1") || block_data[1].equals("8")) ? (mat = block_data[1].equals("1") ? wall : floor) : bid;
                int tmp = Math.round((float)entry.getValue().intValue() / 100.0f * (float)this.plugin.getConfig().getInt("growth.rooms_condenser_percent"));
                int n = required = tmp > 0 ? tmp : 1;
                if (item_counts.containsKey(block_id)) {
                    item_counts.put(block_id, item_counts.get(block_id) + required);
                    continue;
                }
                item_counts.put(block_id, required);
            }
            for (Map.Entry<String, Integer> entry : item_counts.entrySet()) {
                HashMap<String, Object> wherec = new HashMap<String, Object>();
                wherec.put("tardis_id", id);
                wherec.put("block_data", entry.getKey());
                ResultSetCondenser rsc = new ResultSetCondenser(this.plugin, wherec);
                if (rsc.resultSet()) {
                    if (rsc.getBlock_count() >= entry.getValue()) continue;
                    hasRequired = false;
                    int diff = entry.getValue() - rsc.getBlock_count();
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CONDENSE_MORE", String.format("%d", diff), Material.getMaterial((String)entry.getKey()).toString());
                    continue;
                }
                hasRequired = false;
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "CONDENSE_MIN", String.format("%d", entry.getValue()), Material.getMaterial((String)entry.getKey()).toString());
            }
            if (!hasRequired) {
                player.sendMessage("-----------------------------");
                this.plugin.getTrackerKeeper().getRoomSeed().remove(uuid);
                return true;
            }
            CondenserData c_data = new CondenserData();
            c_data.setBlockIDCount(item_counts);
            c_data.setTardis_id(id);
            this.plugin.getGeneralKeeper().getRoomCondenserData().put(uuid, c_data);
        }
        if (room.equals("ZERO")) {
            return new ZeroRoomBuilder(this.plugin).build(player, tips, id);
        }
        RoomSeedData sd = new RoomSeedData();
        sd.setId(id);
        sd.setRoom(room);
        sd.setSchematic(schm);
        sd.setChunkMinMax(chunk);
        this.plugin.getTrackerKeeper().getRoomSeed().put(uuid, sd);
        if (room.equals("STAIRCASE")) {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ROOM_SEED_STAIRCASE");
        } else {
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ROOM_SEED_INFO", room, this.plugin.getRoomsConfig().getString("rooms." + room + ".seed"));
        }
        return true;
    }
}

