/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.dev;

import com.google.common.collect.Multimap;
import com.google.common.collect.Multimaps;
import com.google.common.collect.Sets;
import io.papermc.paper.dialog.Dialog;
import io.papermc.paper.registry.RegistryAccess;
import io.papermc.paper.registry.RegistryKey;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.achievement.TARDISAchievementFactory;
import me.eccentric_nz.TARDIS.bStats.ARSRoomCounts;
import me.eccentric_nz.TARDIS.blueprints.BlueprintRoom;
import me.eccentric_nz.TARDIS.commands.TARDISCommandHelper;
import me.eccentric_nz.TARDIS.commands.dev.AddRegionsCommand;
import me.eccentric_nz.TARDIS.commands.dev.BiomeCommand;
import me.eccentric_nz.TARDIS.commands.dev.BleachCommand;
import me.eccentric_nz.TARDIS.commands.dev.BoxCommand;
import me.eccentric_nz.TARDIS.commands.dev.ChainCommand;
import me.eccentric_nz.TARDIS.commands.dev.ChunksCommand;
import me.eccentric_nz.TARDIS.commands.dev.CircuitCommand;
import me.eccentric_nz.TARDIS.commands.dev.ComponentCommand;
import me.eccentric_nz.TARDIS.commands.dev.ConsoleTextCommand;
import me.eccentric_nz.TARDIS.commands.dev.DebugCommand;
import me.eccentric_nz.TARDIS.commands.dev.DisplayItemCommand;
import me.eccentric_nz.TARDIS.commands.dev.EffectCommand;
import me.eccentric_nz.TARDIS.commands.dev.FixStorageCommand;
import me.eccentric_nz.TARDIS.commands.dev.FrameCommand;
import me.eccentric_nz.TARDIS.commands.dev.FurnaceCommand;
import me.eccentric_nz.TARDIS.commands.dev.HappyCommand;
import me.eccentric_nz.TARDIS.commands.dev.HeadCommand;
import me.eccentric_nz.TARDIS.commands.dev.InfoCommand;
import me.eccentric_nz.TARDIS.commands.dev.InteractionCommand;
import me.eccentric_nz.TARDIS.commands.dev.LabelCommand;
import me.eccentric_nz.TARDIS.commands.dev.ListCommand;
import me.eccentric_nz.TARDIS.commands.dev.MannequinCommand;
import me.eccentric_nz.TARDIS.commands.dev.MountCommand;
import me.eccentric_nz.TARDIS.commands.dev.NMSCommand;
import me.eccentric_nz.TARDIS.commands.dev.PaintingCommand;
import me.eccentric_nz.TARDIS.commands.dev.ResourcePackConverterCommand;
import me.eccentric_nz.TARDIS.commands.dev.RomanCommand;
import me.eccentric_nz.TARDIS.commands.dev.RoomsCommand;
import me.eccentric_nz.TARDIS.commands.dev.ShelfCommand;
import me.eccentric_nz.TARDIS.commands.dev.StaircaseCommand;
import me.eccentric_nz.TARDIS.commands.dev.StorageContents;
import me.eccentric_nz.TARDIS.commands.dev.SystemTreeCommand;
import me.eccentric_nz.TARDIS.commands.dev.TIPSPreviewSlotInfo;
import me.eccentric_nz.TARDIS.commands.dev.TreeCommand;
import me.eccentric_nz.TARDIS.commands.dev.UpdateBlockStateCommand;
import me.eccentric_nz.TARDIS.commands.dev.wiki.WikiRecipeCommand;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetGames;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.monitor.MonitorSnapshot;
import me.eccentric_nz.TARDIS.move.TARDISTeleportLocation;
import me.eccentric_nz.TARDIS.playerprefs.PreferencesDialog;
import me.eccentric_nz.TARDIS.rooms.games.pong.GameDisplay;
import me.eccentric_nz.TARDIS.rooms.games.rockpaperscissors.Letters;
import me.eccentric_nz.TARDIS.skins.ArchSkins;
import me.eccentric_nz.TARDIS.skins.DoctorSkins;
import me.eccentric_nz.TARDIS.skins.tv.TVInventory;
import me.eccentric_nz.TARDIS.utility.Pluraliser;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import me.eccentric_nz.tardisregeneration.Regenerator;
import me.eccentric_nz.tardisweepingangels.equip.MonsterArmour;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import net.kyori.adventure.audience.Audience;
import net.kyori.adventure.dialog.DialogLike;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Art;
import org.bukkit.Color;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.Registry;
import org.bukkit.block.Block;
import org.bukkit.block.BlockState;
import org.bukkit.block.BrushableBlock;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.TextDisplay;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemFlag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.RecipeChoice;
import org.bukkit.inventory.ShapelessRecipe;
import org.bukkit.inventory.meta.BlockStateMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.LeatherArmorMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.inventory.meta.components.EquippableComponent;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class TARDISDevCommand
implements CommandExecutor {
    private final Set<String> firstsStr = Sets.newHashSet((Object[])new String[]{"add_regions", "advancements", "armour", "banner", "biome", "bleach", "blueprint", "box", "brushable", "chain", "chunks", "chunky", "circuit", "component", "dalek", "debug", "dialog", "dismount", "displayitem", "effect", "empty", "frame", "furnace", "gravity", "give", "happy", "head", "interaction", "label", "leather", "list", "mannequin", "monster", "mount", "ntc", "nms", "painting", "plurals", "pong", "recipe", "regen", "registry", "roman", "rooms", "screen", "shelf", "siege", "skin", "snapshot", "staircase", "stats", "systree", "text", "tis", "tips", "tree", "unmount", "update"});
    private final TARDIS plugin;

    public TARDISDevCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        block260: {
            block261: {
                if (!cmd.getName().equalsIgnoreCase("tardisdev")) break block260;
                if (!(sender instanceof ConsoleCommandSender) && !sender.hasPermission("tardis.admin")) break block261;
                if (args.length == 0) {
                    new TARDISCommandHelper(this.plugin).getCommand("tardisadmin", sender);
                    return true;
                }
                String first = args[0].toLowerCase(Locale.ROOT);
                if (!this.firstsStr.contains(first)) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "ARG_NOT_VALID");
                    return false;
                }
                if (args.length == 1) {
                    switch (first) {
                        case "siege": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                ItemStack cube = player.getInventory().getItemInMainHand();
                                ItemMeta im = cube.getItemMeta();
                                im.getPersistentDataContainer().set(this.plugin.getCustomBlockKey(), PersistentDataType.STRING, (Object)TARDISBlockDisplayItem.SIEGE_CUBE.getCustomModel().getKey());
                                ArrayList<TextComponent> lore = new ArrayList<TextComponent>();
                                lore.add(Component.text((String)"Time Lord: eccentric_nz"));
                                lore.add(Component.text((String)"ID: 1"));
                                im.lore(lore);
                                cube.setItemMeta(im);
                                this.plugin.getTrackerKeeper().getIsSiegeCube().add(1);
                                this.plugin.getTrackerKeeper().getSiegeCarrying().put(player.getUniqueId(), 1);
                            }
                            return true;
                        }
                        case "text": {
                            ResultSetGames rsg;
                            Player player;
                            ResultSetTardisID rs;
                            if (sender instanceof Player && (rs = new ResultSetTardisID(this.plugin)).fromUUID((player = (Player)sender).getUniqueId().toString()) && (rsg = new ResultSetGames(this.plugin)).fromId(rs.getTardisId())) {
                                List<UUID> uuids = rsg.getPongUUIDs();
                                for (Entity e : player.getLocation().getChunk().getEntities()) {
                                    if (!(e instanceof TextDisplay)) continue;
                                    TextDisplay display = (TextDisplay)e;
                                    this.plugin.debug(display.getUniqueId().toString());
                                    if (!uuids.contains(display.getUniqueId())) continue;
                                    this.plugin.debug("found!");
                                }
                            }
                            return true;
                        }
                        case "banner": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                Letters.giveAll(player);
                            }
                            return true;
                        }
                        case "pong": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                Block targetBlock = player.getTargetBlock(this.plugin.getGeneralKeeper().getTransparent(), 16);
                                String uuids = GameDisplay.create(targetBlock.getLocation().add(0.5, 2.0, 0.5));
                                this.plugin.debug(uuids);
                            }
                            return true;
                        }
                        case "update": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                return new UpdateBlockStateCommand(this.plugin).refresh(player);
                            }
                            return true;
                        }
                        case "shelf": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                return new ShelfCommand(this.plugin).putItems(player);
                            }
                            return true;
                        }
                        case "bleach": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                return new BleachCommand(this.plugin).setDisplay(player);
                            }
                            return true;
                        }
                        case "painting": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                return new PaintingCommand(this.plugin).getLocation(player);
                            }
                            return true;
                        }
                        case "blueprint": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                String uuid = player.getUniqueId().toString();
                                for (BlueprintRoom bpr : BlueprintRoom.values()) {
                                    HashMap<String, Object> set = new HashMap<String, Object>();
                                    set.put("uuid", uuid);
                                    set.put("permission", bpr.getPermission());
                                    this.plugin.getQueryFactory().doInsert("blueprint", set);
                                }
                            }
                            return true;
                        }
                        case "mount": 
                        case "unmount": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                return new MountCommand(this.plugin).test(player, first.equals("mount"));
                            }
                            return true;
                        }
                        case "add_regions": {
                            return new AddRegionsCommand(this.plugin).doCheck(sender);
                        }
                        case "biome": {
                            return new BiomeCommand().reset(sender);
                        }
                        case "chain": {
                            return new ChainCommand(this.plugin).checkSchematics();
                        }
                        case "dalek": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                Location eyeLocation = player.getTargetBlock(null, 16).getLocation();
                                eyeLocation.add(0.5, 1.25, 0.5);
                                eyeLocation.setYaw(player.getLocation().getYaw() - 180.0f);
                                Skeleton skeleton = (Skeleton)eyeLocation.getWorld().spawnEntity(eyeLocation, EntityType.SKELETON);
                                EntityEquipment ee = skeleton.getEquipment();
                                ItemStack head = ItemStack.of((Material)Material.SLIME_BALL);
                                ItemMeta him = head.getItemMeta();
                                him.setItemModel(new NamespacedKey((Plugin)this.plugin, "dalek_independent_head"));
                                EquippableComponent component = him.getEquippable();
                                component.setSlot(EquipmentSlot.HEAD);
                                component.setAllowedEntities(EntityType.SKELETON);
                                him.setEquippable(component);
                                head.setItemMeta(him);
                                ee.setHelmet(head);
                                ItemStack body = ItemStack.of((Material)Material.SLIME_BALL);
                                ItemMeta bim = body.getItemMeta();
                                bim.setItemModel(new NamespacedKey((Plugin)this.plugin, "dalek_body"));
                                body.setItemMeta(bim);
                                ee.setItemInMainHand(body);
                                PotionEffect invisibility = new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 1, false, false);
                                skeleton.addPotionEffect(invisibility);
                                PotionEffect resistance = new PotionEffect(PotionEffectType.FIRE_RESISTANCE, 360000, 3, false, false);
                                skeleton.addPotionEffect(resistance);
                            }
                            return true;
                        }
                        case "dialog": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                Dialog dialog = new PreferencesDialog(this.plugin, player.getUniqueId()).create();
                                Audience.audience((Audience[])new Audience[]{player}).showDialog((DialogLike)dialog);
                            }
                            return true;
                        }
                        case "empty": {
                            return new FixStorageCommand(this.plugin).convertStacks();
                        }
                        case "staircase": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                return new StaircaseCommand().spiral(player);
                            }
                            return true;
                        }
                        case "furnace": {
                            return new FurnaceCommand(this.plugin).list();
                        }
                        case "gravity": {
                            if (sender instanceof Player) {
                                Player player;
                                player.setGravity(!(player = (Player)sender).hasGravity());
                            }
                            return true;
                        }
                        case "give": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                new StorageContents(this.plugin).give(player);
                            }
                            return true;
                        }
                        case "happy": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                new HappyCommand().leash(player);
                            }
                            return true;
                        }
                        case "head": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                new HeadCommand(this.plugin).giveAPIHead(player);
                            }
                            return true;
                        }
                        case "interaction": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                return new InteractionCommand(this.plugin).process(player.getUniqueId());
                            }
                            return false;
                        }
                        case "leather": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                ItemStack is = ItemStack.of((Material)Material.LEATHER_HORSE_ARMOR);
                                LeatherArmorMeta im = (LeatherArmorMeta)is.getItemMeta();
                                im.setColor(Color.fromRGB((int)255, (int)0, (int)0));
                                im.addItemFlags(ItemFlag.values());
                                im.setAttributeModifiers((Multimap)Multimaps.forMap(Map.of()));
                                im.setEquippable(null);
                                CustomModelDataComponent cmdc = im.getCustomModelDataComponent();
                                List<String> strings = List.of("chameleon_tint");
                                cmdc.setStrings(strings);
                                im.setCustomModelDataComponent(cmdc);
                                is.setItemMeta((ItemMeta)im);
                                player.getInventory().addItem(new ItemStack[]{is});
                                return true;
                            }
                            return false;
                        }
                        case "monster": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                for (Map.Entry<Location, TARDISTeleportLocation> map : this.plugin.getTrackerKeeper().getPortals().entrySet()) {
                                    if (map.getKey().getWorld().getName().contains("TARDIS") || map.getValue().isAbandoned()) continue;
                                    this.plugin.getMessenger().message((CommandSender)player, "tardisId => " + map.getValue().getTardisId());
                                }
                                this.plugin.getMessenger().message((CommandSender)player, "End of open portal list.");
                                return true;
                            }
                            return false;
                        }
                        case "ntc": {
                            TARDISStaticUtils.getColor((Component)Component.text((String)"test", (TextColor)NamedTextColor.AQUA));
                            return true;
                        }
                        case "regen": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                new Regenerator().dev(this.plugin, player, args);
                            }
                            return true;
                        }
                        case "registry": {
                            Registry variants = RegistryAccess.registryAccess().getRegistry(RegistryKey.PAINTING_VARIANT);
                            for (Art a : variants) {
                                try {
                                    this.plugin.debug(String.valueOf(a) + " " + variants.getKey((Keyed)a).getKey());
                                }
                                catch (NoSuchMethodError | NullPointerException | NoSuchElementException cmdc) {}
                            }
                            return true;
                        }
                        case "skin": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                this.plugin.getSkinChanger().remove(player);
                            }
                            return true;
                        }
                        case "stats": {
                            ARSRoomCounts arsRoomCounts = new ARSRoomCounts(this.plugin);
                            for (Map.Entry<String, Integer> entry : arsRoomCounts.getRoomCounts().entrySet()) {
                                this.plugin.debug(entry.getKey() + ": " + String.valueOf(entry.getValue()));
                            }
                            this.plugin.debug("Median per TARDIS: " + arsRoomCounts.getMedian());
                            return true;
                        }
                        case "systree": {
                            if (sender instanceof Player) {
                                Player player = (Player)sender;
                                return new SystemTreeCommand(this.plugin).open(player);
                            }
                            return false;
                        }
                        case "tips": {
                            return new TIPSPreviewSlotInfo(this.plugin).display();
                        }
                    }
                }
                switch (first) {
                    case "bleach": {
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            ShapelessRecipe recipe = this.plugin.getIncomposita().getShapelessRecipes().get("Bleached Bed");
                            for (RecipeChoice choice : recipe.getChoiceList()) {
                                if (!(choice instanceof RecipeChoice.ExactChoice)) continue;
                                RecipeChoice.ExactChoice exact = (RecipeChoice.ExactChoice)choice;
                                ItemStack ec = exact.getItemStack();
                                player.getInventory().addItem(new ItemStack[]{ec});
                            }
                        }
                        return true;
                    }
                    case "text": {
                        Player player;
                        ResultSetTardisID rs;
                        if (sender instanceof Player && (rs = new ResultSetTardisID(this.plugin)).fromUUID((player = (Player)sender).getUniqueId().toString())) {
                            if (args[1].equals("tp")) {
                                ResultSetGames rsg;
                                if (rs.fromUUID(player.getUniqueId().toString()) && (rsg = new ResultSetGames(this.plugin)).fromId(rs.getTardisId())) {
                                    String playerLocation = rsg.getPlayerLocation();
                                    Location tp = TARDISStaticLocationGetters.getLocationFromBukkitString(playerLocation);
                                    tp.setYaw(180.0f);
                                    player.teleport(tp);
                                }
                            } else {
                                int y = args[2].equals("up") ? 1 : -1;
                                ResultSetGames rsg = new ResultSetGames(this.plugin);
                                if (rsg.fromId(rs.getTardisId())) {
                                    List<UUID> uuids = rsg.getPongUUIDs();
                                    for (UUID u : uuids) {
                                        Entity e = player.getWorld().getEntity(u);
                                        if (!(e instanceof TextDisplay)) continue;
                                        TextDisplay display = (TextDisplay)e;
                                        display.teleport(display.getLocation().add(0.0, (double)y, 0.0));
                                    }
                                }
                            }
                        }
                        return true;
                    }
                    case "banner": {
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            Letters.makeCode(player);
                        }
                        return true;
                    }
                    case "head": {
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            new HeadCommand(this.plugin).getHeadProperties(player);
                        }
                        return true;
                    }
                    case "staircase": {
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            switch (args[1]) {
                                case "mark": {
                                    return new StaircaseCommand().mark(player);
                                }
                                case "scan": {
                                    return new StaircaseCommand().scan(player);
                                }
                            }
                            return new StaircaseCommand().smaller(player);
                        }
                        return false;
                    }
                    case "advancements": {
                        TARDISAchievementFactory.checkAdvancement(args[1]);
                        return true;
                    }
                    case "armour": {
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            try {
                                Monster monster = Monster.valueOf(args[1].toUpperCase(Locale.ROOT));
                                EquipmentSlot slot = EquipmentSlot.valueOf((String)args[2].toUpperCase(Locale.ROOT));
                                if (slot != EquipmentSlot.CHEST && slot != EquipmentSlot.LEGS) {
                                    return false;
                                }
                                ItemStack a = MonsterArmour.makeEquippable(monster, slot);
                                player.getInventory().addItem(new ItemStack[]{a});
                            }
                            catch (IllegalArgumentException monster) {
                                // empty catch block
                            }
                        }
                        return true;
                    }
                    case "biome": {
                        return new BiomeCommand().getName(sender);
                    }
                    case "box": {
                        return new BoxCommand(this.plugin).setPreset(sender, args);
                    }
                    case "component": {
                        switch (args[1].toLowerCase(Locale.ROOT)) {
                            case "ars": {
                                new ComponentCommand(this.plugin).writeARS();
                                break;
                            }
                            case "repeater": {
                                new ComponentCommand(this.plugin).writeRepeater();
                                break;
                            }
                            case "key": {
                                new ComponentCommand(this.plugin).writeKey();
                                break;
                            }
                            case "pack": {
                                new ResourcePackConverterCommand(this.plugin).process(sender, args);
                                break;
                            }
                            case "extra": {
                                new ComponentCommand(this.plugin).writeExtra(sender);
                                break;
                            }
                        }
                        return true;
                    }
                    case "debug": {
                        return new DebugCommand(this.plugin).process(sender, args);
                    }
                    case "label": {
                        return new LabelCommand(this.plugin).catalog(sender);
                    }
                    case "nms": {
                        return new NMSCommand(this.plugin).spawn(sender, args);
                    }
                    case "circuit": {
                        return new CircuitCommand(this.plugin).give(sender);
                    }
                    case "tis": {
                        return new InfoCommand(this.plugin).test(sender);
                    }
                    case "list": {
                        return new ListCommand(this.plugin).listStuff(sender, args);
                    }
                    case "tree": {
                        return new TreeCommand(this.plugin).grow(sender, args);
                    }
                    case "recipe": {
                        return new WikiRecipeCommand(this.plugin).write(sender, args);
                    }
                    case "rooms": {
                        return new RoomsCommand(this.plugin).build(sender, args);
                    }
                    case "roman": {
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            new RomanCommand().equip(player, args[1]);
                        }
                        return true;
                    }
                    case "mannequin": {
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            new MannequinCommand().equip(player, args[1]);
                        }
                        return true;
                    }
                    case "plurals": {
                        for (Material m : Material.values()) {
                            String str = m.toString().toLowerCase(Locale.ROOT).replace("_", " ");
                            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, str + " --> " + Pluraliser.pluralise(str));
                        }
                        return true;
                    }
                    case "chunks": {
                        return new ChunksCommand(this.plugin).list(sender);
                    }
                    case "chunky": {
                        if (!this.plugin.getPM().isPluginEnabled("Chunky")) {
                            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.WARNING, "Chunky plugin is not enabled!");
                            return true;
                        }
                        String radius = args.length > 2 ? args[2] : "250";
                        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "chunky world " + args[1]);
                        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "chunky radius " + radius);
                        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "chunky spawn");
                        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "chunky start");
                        this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "chunky confirm");
                        return true;
                    }
                    case "screen": {
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            return new ConsoleTextCommand(this.plugin).move(player, args);
                        }
                        break block260;
                    }
                    case "skin": {
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            if (TARDISNumberParsers.isSimpleNumber(args[1])) {
                                this.plugin.getSkinChanger().set(player, switch (args[1]) {
                                    case "1" -> DoctorSkins.FIRST;
                                    case "2" -> DoctorSkins.SECOND;
                                    case "3" -> DoctorSkins.THIRD;
                                    case "4" -> DoctorSkins.FOURTH;
                                    case "5" -> DoctorSkins.FIFTH;
                                    case "6" -> DoctorSkins.SIXTH;
                                    case "7" -> DoctorSkins.SEVENTH;
                                    case "8" -> DoctorSkins.EIGHTH;
                                    case "9" -> DoctorSkins.NINTH;
                                    case "10" -> DoctorSkins.TENTH;
                                    case "11" -> DoctorSkins.ELEVENTH;
                                    case "12" -> DoctorSkins.TWELFTH;
                                    case "13" -> DoctorSkins.THIRTEENTH;
                                    case "14" -> DoctorSkins.FOURTEENTH;
                                    case "15" -> DoctorSkins.FIFTEENTH;
                                    case "16" -> DoctorSkins.WAR;
                                    default -> ArchSkins.HEROBRINE;
                                });
                            } else {
                                player.openInventory(new TVInventory(this.plugin).getInventory());
                            }
                        }
                        return true;
                    }
                    case "snapshot": {
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            if (args[1].equals("c")) {
                                player.performCommand("minecraft:clear @s minecraft:filled_map");
                            } else {
                                new MonitorSnapshot(this.plugin).get(args[1].equals("in"), player);
                            }
                        }
                        return true;
                    }
                    case "displayitem": {
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            return new DisplayItemCommand(this.plugin).display(player, args);
                        }
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
                        return true;
                    }
                    case "frame": {
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            return new FrameCommand(this.plugin).toggle(player, args[1].equalsIgnoreCase("lock"), args.length == 3);
                        }
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_PLAYER");
                        return true;
                    }
                    case "brushable": {
                        if (sender instanceof Player) {
                            Player player = (Player)sender;
                            if (args.length == 2) {
                                Block block = player.getTargetBlock(null, 8);
                                sender.sendMessage(block.getState().toString());
                            } else {
                                ItemStack sand = ItemStack.of((Material)Material.SUSPICIOUS_SAND);
                                BlockStateMeta sandMeta = (BlockStateMeta)sand.getItemMeta();
                                BrushableBlock blockState = (BrushableBlock)sandMeta.getBlockState();
                                blockState.setItem(player.getInventory().getItemInMainHand());
                                sandMeta.setBlockState((BlockState)blockState);
                                sand.setItemMeta((ItemMeta)sandMeta);
                                player.getInventory().addItem(new ItemStack[]{sand});
                            }
                        }
                        return true;
                    }
                    case "dismount": {
                        Player player;
                        if (sender instanceof Player && (player = (Player)sender).getVehicle() != null) {
                            player.getVehicle().eject();
                        }
                        return true;
                    }
                    case "effect": {
                        if (!(sender instanceof Player)) break;
                        Player player = (Player)sender;
                        return new EffectCommand(this.plugin).show(player, args);
                    }
                }
                break block260;
            }
            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_ADMIN");
            return false;
        }
        return false;
    }
}

