/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.camera;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.camera.CameraLocation;
import me.eccentric_nz.TARDIS.camera.CameraTracker;
import me.eccentric_nz.TARDIS.custommodels.keys.ChameleonVariant;
import me.eccentric_nz.TARDIS.custommodels.keys.ColouredVariant;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import org.bukkit.Location;
import org.bukkit.NamespacedKey;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;

public class TARDISCamera {
    private final TARDIS plugin;

    public TARDISCamera(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void viewExterior(Player player, int id) {
        Location playerLocation = player.getLocation();
        CameraTracker.SPECTATING.put(player.getUniqueId(), new CameraLocation(playerLocation, id, playerLocation.getChunk().isForceLoaded()));
        CameraTracker.CAMERA_IN_USE.add(id);
        playerLocation.getChunk().addPluginChunkTicket((Plugin)this.plugin);
        ResultSetCurrentFromId rs = new ResultSetCurrentFromId(this.plugin, id);
        if (!rs.resultSet()) {
            this.plugin.debug("No current location");
            return;
        }
        Location location = rs.getCurrent().location().clone();
        while (!location.getChunk().isLoaded()) {
            location.getChunk().load();
        }
        location.setYaw(player.getLocation().getYaw());
        location.setPitch(player.getLocation().getPitch());
        player.teleport(location);
        for (Entity e : location.getWorld().getNearbyEntities(location, 1.0, 1.0, 1.0, s -> s.getType() == EntityType.ARMOR_STAND)) {
            if (!(e instanceof ArmorStand)) continue;
            ArmorStand stand = (ArmorStand)e;
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                NamespacedKey viewing;
                EntityEquipment ee = stand.getEquipment();
                ItemStack is = ee.getHelmet();
                ItemMeta im = is.getItemMeta();
                switch (is.getType()) {
                    case BLACK_DYE: {
                        NamespacedKey namespacedKey = ChameleonVariant.BLACK_CAMERA.getKey();
                        break;
                    }
                    case RED_DYE: {
                        NamespacedKey namespacedKey = ChameleonVariant.RED_CAMERA.getKey();
                        break;
                    }
                    case BROWN_DYE: {
                        NamespacedKey namespacedKey = ChameleonVariant.BROWN_CAMERA.getKey();
                        break;
                    }
                    case GREEN_DYE: {
                        NamespacedKey namespacedKey = ChameleonVariant.GREEN_CAMERA.getKey();
                        break;
                    }
                    case PURPLE_DYE: {
                        NamespacedKey namespacedKey = ChameleonVariant.PURPLE_CAMERA.getKey();
                        break;
                    }
                    case CYAN_DYE: {
                        NamespacedKey namespacedKey = ChameleonVariant.CYAN_CAMERA.getKey();
                        break;
                    }
                    case LIGHT_GRAY_DYE: {
                        NamespacedKey namespacedKey = ChameleonVariant.LIGHT_GRAY_CAMERA.getKey();
                        break;
                    }
                    case GRAY_DYE: {
                        NamespacedKey namespacedKey = ChameleonVariant.GRAY_CAMERA.getKey();
                        break;
                    }
                    case PINK_DYE: {
                        NamespacedKey namespacedKey = ChameleonVariant.PINK_CAMERA.getKey();
                        break;
                    }
                    case LIME_DYE: {
                        NamespacedKey namespacedKey = ChameleonVariant.LIME_CAMERA.getKey();
                        break;
                    }
                    case YELLOW_DYE: {
                        NamespacedKey namespacedKey = ChameleonVariant.YELLOW_CAMERA.getKey();
                        break;
                    }
                    case LIGHT_BLUE_DYE: {
                        NamespacedKey namespacedKey = ChameleonVariant.LIGHT_BLUE_CAMERA.getKey();
                        break;
                    }
                    case MAGENTA_DYE: {
                        NamespacedKey namespacedKey = ChameleonVariant.MAGENTA_CAMERA.getKey();
                        break;
                    }
                    case ORANGE_DYE: {
                        NamespacedKey namespacedKey = ChameleonVariant.ORANGE_CAMERA.getKey();
                        break;
                    }
                    case WHITE_DYE: {
                        NamespacedKey namespacedKey = ChameleonVariant.WHITE_CAMERA.getKey();
                        break;
                    }
                    case CYAN_STAINED_GLASS_PANE: {
                        NamespacedKey namespacedKey = ChameleonVariant.TENNANT_CAMERA.getKey();
                        break;
                    }
                    case LEATHER_HORSE_ARMOR: {
                        NamespacedKey namespacedKey = ColouredVariant.TINTED_CAMERA.getKey();
                        break;
                    }
                    case WOLF_SPAWN_EGG: {
                        NamespacedKey namespacedKey = ChameleonVariant.BAD_WOLF_CAMERA.getKey();
                        break;
                    }
                    case CLAY_BALL: {
                        NamespacedKey namespacedKey = ChameleonVariant.TYPE_40_CAMERA.getKey();
                        break;
                    }
                    default: {
                        NamespacedKey namespacedKey = viewing = null;
                    }
                }
                if (viewing != null) {
                    im.setItemModel(viewing);
                }
                is.setItemMeta(im);
                ee.setHelmet(is);
                player.addPotionEffect(new PotionEffect(PotionEffectType.INVISIBILITY, Integer.MAX_VALUE, 15));
                while (!stand.addPassenger((Entity)player)) {
                    this.plugin.debug("addPassenger FAILED!");
                }
            }, 2L);
        }
    }

    public void stopViewing(Player player, ArmorStand stand) {
        UUID uuid = player.getUniqueId();
        CameraLocation data = CameraTracker.SPECTATING.get(uuid);
        if (data != null) {
            NamespacedKey notviewing;
            player.getLocation().getChunk().removePluginChunkTicket((Plugin)this.plugin);
            EntityEquipment ee = stand.getEquipment();
            ItemStack is = ee.getHelmet();
            ItemMeta im = is.getItemMeta();
            switch (is.getType()) {
                case BLACK_DYE: {
                    NamespacedKey namespacedKey = ChameleonVariant.BLACK_CLOSED.getKey();
                    break;
                }
                case RED_DYE: {
                    NamespacedKey namespacedKey = ChameleonVariant.RED_CLOSED.getKey();
                    break;
                }
                case BROWN_DYE: {
                    NamespacedKey namespacedKey = ChameleonVariant.BROWN_CLOSED.getKey();
                    break;
                }
                case GREEN_DYE: {
                    NamespacedKey namespacedKey = ChameleonVariant.GREEN_CLOSED.getKey();
                    break;
                }
                case BLUE_DYE: {
                    NamespacedKey namespacedKey = ChameleonVariant.BLUE_CLOSED.getKey();
                    break;
                }
                case PURPLE_DYE: {
                    NamespacedKey namespacedKey = ChameleonVariant.PURPLE_CLOSED.getKey();
                    break;
                }
                case CYAN_DYE: {
                    NamespacedKey namespacedKey = ChameleonVariant.CYAN_CLOSED.getKey();
                    break;
                }
                case LIGHT_GRAY_DYE: {
                    NamespacedKey namespacedKey = ChameleonVariant.LIGHT_GRAY_CLOSED.getKey();
                    break;
                }
                case GRAY_DYE: {
                    NamespacedKey namespacedKey = ChameleonVariant.GRAY_CLOSED.getKey();
                    break;
                }
                case PINK_DYE: {
                    NamespacedKey namespacedKey = ChameleonVariant.PINK_CLOSED.getKey();
                    break;
                }
                case LIME_DYE: {
                    NamespacedKey namespacedKey = ChameleonVariant.LIME_CLOSED.getKey();
                    break;
                }
                case YELLOW_DYE: {
                    NamespacedKey namespacedKey = ChameleonVariant.YELLOW_CLOSED.getKey();
                    break;
                }
                case LIGHT_BLUE_DYE: {
                    NamespacedKey namespacedKey = ChameleonVariant.LIGHT_BLUE_CLOSED.getKey();
                    break;
                }
                case MAGENTA_DYE: {
                    NamespacedKey namespacedKey = ChameleonVariant.MAGENTA_CLOSED.getKey();
                    break;
                }
                case ORANGE_DYE: {
                    NamespacedKey namespacedKey = ChameleonVariant.ORANGE_CLOSED.getKey();
                    break;
                }
                case WHITE_DYE: {
                    NamespacedKey namespacedKey = ChameleonVariant.WHITE_CLOSED.getKey();
                    break;
                }
                case CYAN_STAINED_GLASS_PANE: {
                    NamespacedKey namespacedKey = ChameleonVariant.TENNANT_CLOSED.getKey();
                    break;
                }
                case LEATHER_HORSE_ARMOR: {
                    NamespacedKey namespacedKey = ColouredVariant.TINTED_CLOSED.getKey();
                    break;
                }
                case WOLF_SPAWN_EGG: {
                    NamespacedKey namespacedKey = ChameleonVariant.BAD_WOLF_CLOSED.getKey();
                    break;
                }
                case CLAY_BALL: {
                    NamespacedKey namespacedKey = ChameleonVariant.TYPE_40_CLOSED.getKey();
                    break;
                }
                default: {
                    NamespacedKey namespacedKey = notviewing = null;
                }
            }
            if (notviewing != null) {
                im.setItemModel(notviewing);
            }
            is.setItemMeta(im);
            ee.setHelmet(is);
            Location interior = data.location();
            while (!interior.getChunk().isLoaded()) {
                interior.getChunk().load();
            }
            player.teleport(interior);
            if (player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                player.removePotionEffect(PotionEffectType.INVISIBILITY);
            }
            HashMap<String, Object> sett = new HashMap<String, Object>();
            sett.put("tardis_id", data.id());
            sett.put("uuid", uuid.toString());
            this.plugin.getQueryFactory().doSyncInsert("travellers", sett);
            CameraTracker.SPECTATING.remove(uuid);
            CameraTracker.CAMERA_IN_USE.remove(data.id());
            if (data.forceLoaded()) {
                interior.getChunk().addPluginChunkTicket((Plugin)this.plugin);
            } else {
                interior.getChunk().removePluginChunkTicket((Plugin)this.plugin);
            }
        }
    }
}

