/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.autonomous;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.api.event.TARDISTravelEvent;
import me.eccentric_nz.TARDIS.artron.AdaptiveBoxLampToggler;
import me.eccentric_nz.TARDIS.artron.BeaconToggler;
import me.eccentric_nz.TARDIS.artron.PresetLampToggler;
import me.eccentric_nz.TARDIS.autonomous.AutonomousUtils;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.data.Current;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetDestinations;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetHomeLocation;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisPreset;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.desktop.UpgradeData;
import me.eccentric_nz.TARDIS.desktop.WallFloorRunnable;
import me.eccentric_nz.TARDIS.destroyers.DestroyData;
import me.eccentric_nz.TARDIS.doors.inner.Inner;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.inner.InnerDoor;
import me.eccentric_nz.TARDIS.doors.inner.InnerMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDoor;
import me.eccentric_nz.TARDIS.doors.outer.OuterMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.enumeration.Autonomous;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.TravelType;
import me.eccentric_nz.TARDIS.hads.CloisterBell;
import me.eccentric_nz.TARDIS.siegemode.SiegeArea;
import me.eccentric_nz.TARDIS.travel.TARDISEPSRunnable;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;

public class AutonomousDeath {
    private final TARDIS plugin;

    public AutonomousDeath(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void automate(Player player) {
        UUID uuid = player.getUniqueId();
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("uuid", uuid.toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, where, "", false);
        if (rs.resultSet()) {
            Tardis tardis = rs.getTardis();
            if (tardis.isPoweredOn()) {
                int id = tardis.getTardisId();
                String eps = tardis.getEps();
                String creeper = tardis.getCreeper();
                ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, uuid.toString());
                if (rsp.resultSet()) {
                    SpaceTimeThrottle spaceTimeThrottle = SpaceTimeThrottle.getByDelay().get(rsp.getThrottle());
                    if (rsp.isAutoOn() && !tardis.isSiegeOn() && !this.plugin.getTrackerKeeper().getDispersedTARDII().contains(id)) {
                        boolean isHomeDefault = rsp.getAutoDefault() == Autonomous.Default.HOME;
                        ResultSetTardisPreset rstp = new ResultSetTardisPreset(this.plugin);
                        if (rstp.fromID(id)) {
                            boolean outerDisplayDoor = rstp.getPreset().usesArmourStand();
                            Inner innerDisplayDoor = new InnerDoor(this.plugin, id).get();
                            UUID playerUUID = player.getUniqueId();
                            if (innerDisplayDoor.display()) {
                                new InnerDisplayDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, playerUUID, true);
                            } else {
                                new InnerMinecraftDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, playerUUID);
                            }
                            if (outerDisplayDoor) {
                                new OuterDisplayDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getDisplay(), id, playerUUID, false);
                            } else if (rstp.getPreset().hasDoor()) {
                                new OuterMinecraftDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getMinecraft(), id, playerUUID);
                            }
                        }
                        Location death_loc = player.getLocation();
                        int amount = Math.round((float)this.plugin.getArtronConfig().getInt("autonomous") * spaceTimeThrottle.getArtronMultiplier());
                        if (tardis.getArtronLevel() > amount) {
                            Location goto_loc;
                            if (this.plugin.getConfig().getBoolean("allow.emergency_npc") && rsp.isEpsOn()) {
                                List<UUID> data;
                                HashMap<String, Object> wherev = new HashMap<String, Object>();
                                wherev.put("tardis_id", id);
                                ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wherev, true);
                                if (rst.resultSet() && !(data = rst.getData()).isEmpty() && !data.contains(uuid)) {
                                    TARDISEPSRunnable EPS_runnable = new TARDISEPSRunnable(this.plugin, rsp.getEpsMessage(), player, data, id, eps, creeper);
                                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)EPS_runnable, 20L);
                                }
                            }
                            String death_world = death_loc.getWorld().getName();
                            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                            if (!rsc.resultSet()) {
                                this.plugin.debug("Current record not found!");
                                return;
                            }
                            Current current = rsc.getCurrent();
                            COMPASS cd = current.direction();
                            HashMap<String, Object> wherehl = new HashMap<String, Object>();
                            wherehl.put("tardis_id", id);
                            ResultSetHomeLocation rsh = new ResultSetHomeLocation(this.plugin, wherehl);
                            if (!rsh.resultSet()) {
                                this.plugin.debug("Home record not found!");
                                return;
                            }
                            World hw = rsh.getWorld();
                            Location home_loc = new Location(hw, (double)rsh.getX(), (double)rsh.getY(), (double)rsh.getZ());
                            COMPASS hd = rsh.getDirection();
                            boolean sub = rsh.isSubmarine();
                            boolean going_home = false;
                            Autonomous autonomous = rsp.getAutoType();
                            switch (autonomous) {
                                case HOME: {
                                    going_home = true;
                                    goto_loc = home_loc;
                                    break;
                                }
                                case AREAS: {
                                    goto_loc = AutonomousUtils.getRecharger(death_world, player);
                                    if (goto_loc != null || !isHomeDefault) break;
                                    goto_loc = home_loc;
                                    going_home = true;
                                    break;
                                }
                                case CONFIGURED_AREAS: {
                                    goto_loc = AutonomousUtils.getConfiguredRecharger(player);
                                    if (goto_loc != null || !isHomeDefault) break;
                                    goto_loc = home_loc;
                                    going_home = true;
                                    break;
                                }
                                case CLOSEST: {
                                    if (!hw.getName().equals(death_world)) {
                                        goto_loc = AutonomousUtils.getRecharger(death_world, player);
                                        if (goto_loc != null) break;
                                        goto_loc = home_loc;
                                        going_home = true;
                                        break;
                                    }
                                    Location recharger = AutonomousUtils.getRecharger(death_world, player);
                                    if (recharger != null) {
                                        boolean closer = death_loc.distanceSquared(home_loc) > death_loc.distanceSquared(recharger);
                                        Location location = goto_loc = closer ? recharger : home_loc;
                                        if (closer) break;
                                        going_home = true;
                                        break;
                                    }
                                    goto_loc = home_loc;
                                    going_home = true;
                                    break;
                                }
                                default: {
                                    World world;
                                    goto_loc = null;
                                    HashMap<String, Object> whered = new HashMap<String, Object>();
                                    whered.put("tardis_id", id);
                                    whered.put("autonomous", 1);
                                    ResultSetDestinations rsd = new ResultSetDestinations(this.plugin, whered, false);
                                    if (rsd.resultSet() && (world = this.plugin.getServer().getWorld(rsd.getWorld())) != null) {
                                        goto_loc = new Location(world, (double)rsd.getX(), (double)rsd.getY(), (double)rsd.getZ());
                                    }
                                    if (goto_loc != null) break;
                                    goto_loc = home_loc;
                                    going_home = true;
                                }
                            }
                            if (goto_loc != null && !AutonomousUtils.compareCurrentToHome(current.location(), rsh)) {
                                COMPASS fd;
                                if (!this.plugin.getConfig().getString("creation.area", "none").equals("none") && this.plugin.getTardisArea().areaCheckLocPlayer(player, goto_loc)) {
                                    this.plugin.getTrackerKeeper().getPerm().remove(player.getUniqueId());
                                    return;
                                }
                                COMPASS cOMPASS = fd = going_home ? hd : cd;
                                if (!this.plugin.getTrackerKeeper().getDestinationVortex().containsKey(id)) {
                                    DestroyData dd = new DestroyData();
                                    dd.setDirection(cd);
                                    dd.setLocation(current.location());
                                    dd.setPlayer((OfflinePlayer)player);
                                    dd.setHide(false);
                                    dd.setOutside(false);
                                    dd.setSubmarine(current.submarine());
                                    dd.setTardisID(id);
                                    dd.setThrottle(spaceTimeThrottle);
                                    HashMap<String, Object> set = new HashMap<String, Object>();
                                    set.put("handbrake_on", 0);
                                    HashMap<String, Object> tid = new HashMap<String, Object>();
                                    tid.put("tardis_id", id);
                                    if (!tardis.isHidden()) {
                                        this.plugin.getPresetDestroyer().destroyPreset(dd);
                                        this.plugin.getTrackerKeeper().getDematerialising().add(dd.getTardisID());
                                        this.plugin.getTrackerKeeper().getInVortex().add(id);
                                        TARDISSounds.playTARDISSound(current.location(), "tardis_takeoff");
                                        CloisterBell bell = new CloisterBell(this.plugin, 5, id, current.location(), this.plugin.getServer().getPlayer(uuid), true, "Time Lord death", false);
                                        int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)bell, 2L, 70L);
                                        bell.setTask(taskID);
                                        this.plugin.getTrackerKeeper().getCloisterBells().put(id, taskID);
                                    } else {
                                        this.plugin.getPresetDestroyer().removeBlockProtection(id);
                                        set.put("hidden", 0);
                                    }
                                    this.plugin.getQueryFactory().doUpdate("tardis", set, tid);
                                }
                                BuildData bd = new BuildData(uuid.toString());
                                bd.setDirection(fd);
                                bd.setLocation(goto_loc);
                                bd.setMalfunction(false);
                                bd.setPlayer((OfflinePlayer)player);
                                bd.setRebuild(false);
                                bd.setOutside(false);
                                bd.setSubmarine(sub);
                                bd.setTardisID(id);
                                bd.setThrottle(spaceTimeThrottle);
                                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                                    this.plugin.getPresetBuilder().buildPreset(bd);
                                    this.plugin.getTrackerKeeper().getInVortex().add(id);
                                    TARDISSounds.playTARDISSound(bd.getLocation(), "tardis_land");
                                    CloisterBell bell = new CloisterBell(this.plugin, 6, id, current.location(), this.plugin.getServer().getPlayer(uuid), false, "", true);
                                    int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)bell, 2L, 70L);
                                    bell.setTask(taskID);
                                    this.plugin.getTrackerKeeper().getCloisterBells().put(id, taskID);
                                    HashMap<String, Object> seth = new HashMap<String, Object>();
                                    seth.put("handbrake_on", 1);
                                    HashMap<String, Object> wheret = new HashMap<String, Object>();
                                    wheret.put("tardis_id", id);
                                    this.plugin.getQueryFactory().doUpdate("tardis", seth, wheret);
                                    this.plugin.getPM().callEvent((Event)new TARDISTravelEvent(player, null, TravelType.AUTONOMOUS, id));
                                }, 500L);
                                HashMap<String, Object> setc = new HashMap<String, Object>();
                                setc.put("world", goto_loc.getWorld().getName());
                                setc.put("x", goto_loc.getBlockX());
                                setc.put("y", goto_loc.getBlockY());
                                setc.put("z", goto_loc.getBlockZ());
                                setc.put("direction", fd.toString());
                                setc.put("submarine", sub ? 1 : 0);
                                HashMap<String, Object> wherec = new HashMap<String, Object>();
                                wherec.put("tardis_id", id);
                                this.plugin.getQueryFactory().doUpdate("current", setc, wherec);
                                HashMap<String, Object> setb = new HashMap<String, Object>();
                                setb.put("world", current.location().getWorld().getName());
                                setb.put("x", current.location().getBlockX());
                                setb.put("y", current.location().getBlockY());
                                setb.put("z", current.location().getBlockZ());
                                setb.put("direction", current.direction().toString());
                                setb.put("submarine", current.submarine() ? 1 : 0);
                                HashMap<String, Object> whereb = new HashMap<String, Object>();
                                whereb.put("tardis_id", id);
                                this.plugin.getQueryFactory().doUpdate("back", setb, whereb);
                                HashMap<String, Object> wherea = new HashMap<String, Object>();
                                wherea.put("tardis_id", id);
                                this.plugin.getQueryFactory().alterEnergyLevel("tardis", -amount, wherea, player);
                                if (this.plugin.getConfig().getBoolean("allow.power_down")) {
                                    HashMap<String, Object> wherep = new HashMap<String, Object>();
                                    wherep.put("tardis_id", id);
                                    HashMap<String, Object> setp = new HashMap<String, Object>();
                                    setp.put("powered_on", 0);
                                    if (tardis.getPreset().equals((Object)ChameleonPreset.ADAPTIVE) || tardis.getPreset().usesArmourStand()) {
                                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new AdaptiveBoxLampToggler(this.plugin).toggleLamp(id, false, tardis.getPreset()), 1L);
                                    }
                                    new PresetLampToggler(this.plugin).flickSwitch(id, player.getUniqueId(), true, tardis.getSchematic().getLights());
                                    new BeaconToggler(this.plugin).flickSwitch(player.getUniqueId(), id, false);
                                    this.plugin.getQueryFactory().doUpdate("tardis", setp, wherep);
                                }
                            }
                        } else if (this.plugin.getConfig().getBoolean("siege.enabled") && rsp.isAutoSiegeOn()) {
                            ResultSetCurrentFromId rsc = new ResultSetCurrentFromId(this.plugin, id);
                            if (!rsc.resultSet()) {
                                this.plugin.debug("Current record not found!");
                                return;
                            }
                            Current current = rsc.getCurrent();
                            Block siege = current.location().getBlock();
                            HashMap<String, Object> wheres = new HashMap<String, Object>();
                            wheres.put("tardis_id", id);
                            HashMap<String, Object> set = new HashMap<String, Object>();
                            DestroyData dd = new DestroyData();
                            dd.setDirection(current.direction());
                            dd.setLocation(current.location());
                            dd.setPlayer((OfflinePlayer)player);
                            dd.setHide(false);
                            dd.setOutside(false);
                            dd.setSubmarine(current.submarine());
                            dd.setTardisID(id);
                            dd.setThrottle(spaceTimeThrottle);
                            this.plugin.getPresetDestroyer().destroyPreset(dd);
                            CloisterBell bell = new CloisterBell(this.plugin, 7, id, current.location(), this.plugin.getServer().getPlayer(uuid), true, "Siege mode engaged", false);
                            int taskID = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)bell, 2L, 70L);
                            bell.setTask(taskID);
                            this.plugin.getTrackerKeeper().getCloisterBells().put(id, taskID);
                            siege.setBlockData(TARDISConstants.BARRIER);
                            TARDISDisplayItemUtils.remove(siege);
                            TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.SIEGE_CUBE, siege, id);
                            this.plugin.getTrackerKeeper().getInSiegeMode().add(id);
                            set.put("siege_on", 1);
                            if (this.plugin.getConfig().getInt("siege.breeding") > 0 || this.plugin.getConfig().getInt("siege.growth") > 0) {
                                Chunk c = this.plugin.getLocationUtils().getTARDISChunk(id);
                                SiegeArea tsa = new SiegeArea(id, c);
                                if (this.plugin.getConfig().getInt("siege.breeding") > 0) {
                                    List<SiegeArea> breeding_areas = this.plugin.getTrackerKeeper().getSiegeBreedingAreas().get(c.getWorld().getName());
                                    if (breeding_areas == null) {
                                        breeding_areas = new ArrayList<SiegeArea>();
                                    }
                                    breeding_areas.add(tsa);
                                    this.plugin.getTrackerKeeper().getSiegeBreedingAreas().put(c.getWorld().getName(), breeding_areas);
                                }
                                if (this.plugin.getConfig().getInt("siege.growth") > 0) {
                                    List<SiegeArea> growth_areas = this.plugin.getTrackerKeeper().getSiegeGrowthAreas().get(c.getWorld().getName());
                                    if (growth_areas == null) {
                                        growth_areas = new ArrayList<SiegeArea>();
                                    }
                                    growth_areas.add(tsa);
                                    this.plugin.getTrackerKeeper().getSiegeGrowthAreas().put(c.getWorld().getName(), growth_areas);
                                }
                            }
                            if (this.plugin.getConfig().getBoolean("siege.texture")) {
                                Schematic schm = tardis.getSchematic();
                                UpgradeData tud = new UpgradeData();
                                tud.setFloor("BLACK_WOOL");
                                tud.setWall("GRAY_WOOL");
                                tud.setSchematic(schm);
                                tud.setPrevious(schm);
                                WallFloorRunnable ttr = new WallFloorRunnable(this.plugin, player.getUniqueId(), tud);
                                long delay = Math.round(20.0 / this.plugin.getConfig().getDouble("growth.room_speed"));
                                int task = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)ttr, 5L, delay);
                                ttr.setTaskID(task);
                            }
                            this.plugin.getQueryFactory().doUpdate("tardis", set, wheres);
                        } else if (player.isOnline()) {
                            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "ENERGY_NOT_AUTO");
                        }
                    }
                }
            } else if (player.isOnline()) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "AUTO_POWER");
            }
        }
    }
}

