/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.artron.costs;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.artron.costs.ArtronValues;
import me.eccentric_nz.TARDIS.artron.costs.CostData;
import me.eccentric_nz.TARDIS.artron.costs.Highest;
import me.eccentric_nz.TARDIS.enumeration.ConsoleSize;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.schematic.SchematicGZip;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;

public class Processor {
    private final TARDIS plugin;
    private final HashMap<String, HashMap<String, Integer>> consoleBlockCounts = new HashMap();
    private final Set<String> notThese = new HashSet<String>(){
        {
            this.add("archive");
            this.add("junk");
            this.add("medium");
            this.add("small");
            this.add("tall");
        }
    };

    public Processor(TARDIS plugin) {
        this.plugin = plugin;
    }

    public ArtronValues getValues() {
        for (String fileName : Desktops.getBY_PERMS().keySet()) {
            if (this.notThese.contains(fileName)) continue;
            HashMap<String, Integer> blockTypes = new HashMap<String, Integer>();
            JsonObject obj = SchematicGZip.getObject(this.plugin, "consoles", fileName, false);
            if (obj == null) {
                this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, "The supplied file [" + fileName + ".tschm] is not a TARDIS JSON schematic!");
            } else {
                JsonObject dimensions = obj.get("dimensions").getAsJsonObject();
                int h = dimensions.get("height").getAsInt();
                int w = dimensions.get("width").getAsInt();
                int l = dimensions.get("length").getAsInt();
                JsonArray arr = obj.get("input").getAsJsonArray();
                for (int level = 0; level < h; ++level) {
                    JsonArray floor = arr.get(level).getAsJsonArray();
                    for (int row = 0; row < w; ++row) {
                        JsonArray r = floor.get(row).getAsJsonArray();
                        for (int col = 0; col < l; ++col) {
                            JsonObject c = r.get(col).getAsJsonObject();
                            String bid = this.getMaterialAsString(c.get("data").getAsString());
                            if (this.plugin.getBuildKeeper().getIgnoreBlocks().contains(bid)) continue;
                            if (blockTypes.containsKey(bid)) {
                                Integer count = (Integer)blockTypes.get(bid) + 1;
                                blockTypes.put(bid, count);
                                continue;
                            }
                            blockTypes.put(bid, 1);
                        }
                    }
                }
            }
            this.consoleBlockCounts.put(fileName, blockTypes);
        }
        Highest highest = new Highest(0, 0, 0, 0, 0);
        ArrayList<CostData> calculated = new ArrayList<CostData>();
        for (Map.Entry<String, HashMap<String, Integer>> c : this.consoleBlockCounts.entrySet()) {
            int cost = 0;
            for (Map.Entry<String, Integer> entry : c.getValue().entrySet()) {
                String bid = entry.getKey();
                if (this.plugin.getCondensables().containsKey(bid)) {
                    int value = entry.getValue() * this.plugin.getCondensables().get(bid);
                    cost += value;
                    continue;
                }
                this.plugin.debug("Not in condensables: " + entry.getKey());
            }
            int artron_cost = Math.round((float)cost / 2.0f);
            float tmp_cost = (float)artron_cost / 10.0f;
            int config_cost = (int)tmp_cost / 25 * 25;
            int current_cost = this.plugin.getArtronConfig().getInt("upgrades." + c.getKey());
            ConsoleSize size = Desktops.getBY_PERMS().get(c.getKey()).getConsoleSize();
            switch (size) {
                case SMALL: {
                    if (artron_cost <= highest.getSmall()) break;
                    highest.setSmall(artron_cost);
                    break;
                }
                case MEDIUM: {
                    if (artron_cost <= highest.getMedium()) break;
                    highest.setMedium(artron_cost);
                    break;
                }
                case TALL: {
                    if (artron_cost <= highest.getTall()) break;
                    highest.setTall(artron_cost);
                    break;
                }
                case WIDE: {
                    if (artron_cost <= highest.getWide()) break;
                    highest.setWide(artron_cost);
                    break;
                }
                default: {
                    if (artron_cost <= highest.getMassive()) break;
                    highest.setMassive(artron_cost);
                }
            }
            calculated.add(new CostData(TARDISStringUtils.capitalise(c.getKey()), artron_cost, config_cost, current_cost, size));
        }
        return new ArtronValues(calculated, highest);
    }

    private String getMaterialAsString(String data) {
        try {
            BlockData block = this.plugin.getServer().createBlockData(data);
            String bid = block.getMaterial().toString();
            return this.plugin.getBuildKeeper().getBlockConversion().getOrDefault(bid, bid);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            return "STONE";
        }
    }
}

