/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.sonic.actions;

import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.NoSuchElementException;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.keys.SonicVariant;
import me.eccentric_nz.TARDIS.enumeration.SonicScrewdriver;
import me.eccentric_nz.TARDIS.recipes.shaped.SonicScrewdriverRecipe;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.PlayerInventory;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;
import org.bukkit.plugin.Plugin;

public class SonicSound {
    private static final HashMap<UUID, Long> timeout = new HashMap();

    public static void playSonicSound(TARDIS plugin, Player player, long now, long cooldown, String sound) {
        if (!timeout.containsKey(player.getUniqueId()) || timeout.get(player.getUniqueId()) < now) {
            float f;
            ItemMeta im = player.getInventory().getItemInMainHand().getItemMeta();
            CustomModelDataComponent component = im.getCustomModelDataComponent();
            try {
                f = ((Float)component.getFloats().getFirst()).floatValue();
            }
            catch (NoSuchElementException e) {
                List<Float> sonicModel = SonicScrewdriverRecipe.sonicModelLookup.getOrDefault(plugin.getConfig().getString("sonic.default_model").toLowerCase(Locale.ROOT), SonicVariant.ELEVENTH.getFloats());
                f = sonicModel.getFirst().floatValue();
            }
            SonicScrewdriver screwdriver = SonicScrewdriver.getByFloat(f);
            component.setFloats(screwdriver.getActive());
            im.setCustomModelDataComponent(component);
            player.getInventory().getItemInMainHand().setItemMeta(im);
            timeout.put(player.getUniqueId(), now + cooldown);
            TARDISSounds.playTARDISSound(player.getLocation(), sound);
            plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)plugin, () -> {
                ItemStack is = player.getInventory().getItemInMainHand();
                if (is.hasItemMeta()) {
                    ItemMeta meta = is.getItemMeta();
                    if (meta.hasDisplayName() && ComponentUtils.endsWith(meta.displayName(), "Sonic Screwdriver")) {
                        player.getInventory().getItemInMainHand().getEnchantments().keySet().forEach(e -> player.getInventory().getItemInMainHand().removeEnchantment(e));
                        meta.setEnchantmentGlintOverride(null);
                        CustomModelDataComponent scomponent = meta.getCustomModelDataComponent();
                        scomponent.setFloats(screwdriver.getModel());
                        meta.setCustomModelDataComponent(scomponent);
                        is.setItemMeta(meta);
                    } else {
                        SonicSound.revertSonic(player.getInventory(), screwdriver.getModel());
                    }
                } else {
                    SonicSound.revertSonic(player.getInventory(), screwdriver.getModel());
                }
            }, cooldown / 50L);
        }
    }

    private static void revertSonic(PlayerInventory inv, List<Float> model) {
        int first = inv.first(Material.BLAZE_ROD);
        if (first < 0) {
            return;
        }
        ItemStack stack = inv.getItem(first);
        if (stack == null) {
            return;
        }
        ItemMeta meta = stack.getItemMeta();
        if (meta.hasDisplayName() && ComponentUtils.endsWith(meta.displayName(), "Sonic Screwdriver")) {
            CustomModelDataComponent component = meta.getCustomModelDataComponent();
            component.setFloats(model);
            meta.setCustomModelDataComponent(component);
            meta.setEnchantmentGlintOverride(null);
            stack.setItemMeta(meta);
            if (stack.containsEnchantment(Enchantment.UNBREAKING)) {
                stack.getEnchantments().keySet().forEach(arg_0 -> ((ItemStack)stack).removeEnchantment(arg_0));
            }
        }
    }
}

