/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.schematic.getters;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import me.eccentric_nz.TARDIS.schematic.getters.BannerGetter;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.BannerMeta;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.ShieldMeta;

public class ItemStackGetter {
    public static JsonObject getJson(ItemStack item) {
        JsonObject object = new JsonObject();
        if (item != null) {
            Material type = item.getType();
            object.addProperty("item", type.toString());
            if (item.hasItemMeta()) {
                JsonObject state;
                BannerMeta bsm;
                ItemMeta im = item.getItemMeta();
                if (im.hasItemModel()) {
                    object.addProperty("cmd", im.getItemModel().getKey());
                }
                if (im.hasDisplayName()) {
                    object.addProperty("name", ComponentUtils.stripColour(im.displayName()));
                }
                if (im.hasLore()) {
                    JsonArray lore = new JsonArray();
                    for (Component component : im.lore()) {
                        lore.add(ComponentUtils.stripColour(component));
                    }
                    object.add("lore", (JsonElement)lore);
                }
                if (Tag.ITEMS_BANNERS.isTagged((Keyed)type) && im instanceof BannerMeta) {
                    bsm = (BannerMeta)im;
                    state = BannerGetter.getJson(bsm, type);
                    object.add("banner", (JsonElement)state);
                }
                if (type == Material.SHIELD && im instanceof ShieldMeta) {
                    bsm = (ShieldMeta)im;
                    state = BannerGetter.getJson((ShieldMeta)bsm);
                    object.add("banner", (JsonElement)state);
                }
            }
        }
        return object;
    }
}

