/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms.architectural;

import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.companionGUI.VanishChecker;
import me.eccentric_nz.TARDIS.custommodels.GUIArs;
import me.eccentric_nz.TARDIS.custommodels.GUIChemistry;
import me.eccentric_nz.TARDIS.custommodels.GUIMap;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetBlueprint;
import me.eccentric_nz.TARDIS.rooms.architectural.TreeBlueprints;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.SkullMeta;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;

public class ArchitecturalBlueprintsInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final Player player;
    private final Inventory inventory;

    public ArchitecturalBlueprintsInventory(TARDIS plugin, Player player) {
        this.plugin = plugin;
        this.player = player;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"Architectural Blueprints", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack[] items = new ItemStack[54];
        int i = 0;
        ResultSetBlueprint rsb = new ResultSetBlueprint(this.plugin);
        List<String> perms = rsb.getRoomBlueprints(this.player.getUniqueId().toString());
        ItemStack[][] disks = TreeBlueprints.getBlueprints();
        for (int r = 0; r < 3; ++r) {
            for (int c = 0; c < 9; ++c) {
                ItemStack is = disks[r][c];
                ItemMeta im = is.getItemMeta();
                PersistentDataContainer pdc = im.getPersistentDataContainer();
                String perm = (String)pdc.get(TARDIS.plugin.getBlueprintKey(), PersistentDataType.STRING);
                items[i] = !perms.contains(perm) ? is.withType(Material.MUSIC_DISC_RELIC) : is;
                ++i;
            }
        }
        ItemStack scroll_up = ItemStack.of((Material)GUIChemistry.SCROLL_UP.material(), (int)1);
        ItemMeta uim = scroll_up.getItemMeta();
        uim.displayName((Component)Component.text((String)"Scroll up"));
        uim.setItemModel(GUIChemistry.SCROLL_UP.key());
        scroll_up.setItemMeta(uim);
        items[27] = scroll_up;
        ItemStack scroll_down = ItemStack.of((Material)GUIChemistry.SCROLL_DOWN.material(), (int)1);
        ItemMeta dim = scroll_down.getItemMeta();
        dim.displayName((Component)Component.text((String)"Scroll down"));
        dim.setItemModel(GUIChemistry.SCROLL_DOWN.key());
        scroll_down.setItemMeta(dim);
        items[28] = scroll_down;
        i = 36;
        for (Player p : this.plugin.getServer().getOnlinePlayers()) {
            UUID uuid = p.getUniqueId();
            if (i >= 45 || uuid == this.player.getUniqueId() || !VanishChecker.canSee(this.player, p)) continue;
            ItemStack head = ItemStack.of((Material)Material.PLAYER_HEAD, (int)1);
            SkullMeta skull = (SkullMeta)head.getItemMeta();
            skull.setOwningPlayer((OfflinePlayer)p);
            skull.displayName((Component)Component.text((String)p.getName()));
            skull.lore(List.of(Component.text((String)p.getUniqueId().toString())));
            head.setItemMeta((ItemMeta)skull);
            items[i] = head;
            ++i;
        }
        if (i == 36) {
            ItemStack players = ItemStack.of((Material)Material.GRAY_TERRACOTTA, (int)1);
            ItemMeta pim = players.getItemMeta();
            pim.displayName((Component)Component.text((String)"No players online"));
            players.setItemMeta(pim);
            items[36] = players;
        }
        ItemStack scroll_left = ItemStack.of((Material)GUIArs.BUTTON_SCROLL_L.material(), (int)1);
        ItemMeta nim = scroll_left.getItemMeta();
        nim.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_SCROLL_L", "Scroll left")));
        scroll_left.setItemMeta(nim);
        items[45] = scroll_left;
        ItemStack scroll_right = ItemStack.of((Material)GUIArs.BUTTON_SCROLL_R.material(), (int)1);
        ItemMeta pim = scroll_right.getItemMeta();
        pim.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_SCROLL_R", "Scroll right")));
        scroll_right.setItemMeta(pim);
        items[46] = scroll_right;
        ItemStack give = ItemStack.of((Material)Material.GILDED_BLACKSTONE, (int)1);
        ItemMeta gim = give.getItemMeta();
        gim.displayName((Component)Component.text((String)"Give blueprint disc"));
        give.setItemMeta(gim);
        items[49] = give;
        ItemStack close = ItemStack.of((Material)GUIMap.BUTTON_CLOSE.material(), (int)1);
        ItemMeta gui = close.getItemMeta();
        gui.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close.setItemMeta(gui);
        items[53] = close;
        return items;
    }
}

