/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.achievement.TARDISBook;
import me.eccentric_nz.TARDIS.arch.ArchPersister;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.camera.CameraLocation;
import me.eccentric_nz.TARDIS.camera.CameraTracker;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAchievements;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCount;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.floodgate.TARDISFloodgate;
import me.eccentric_nz.TARDIS.skins.SkinUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Chunk;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;
import org.bukkit.plugin.Plugin;
import org.bukkit.potion.PotionEffectType;

public class TARDISJoinListener
implements Listener {
    private final TARDIS plugin;

    public TARDISJoinListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onJoin(PlayerJoinEvent event) {
        ResultSetCount rsc;
        HashMap<String, Object> set;
        ResultSetAchievements rsa;
        HashMap<String, Object> where;
        Player player = event.getPlayer();
        if (this.plugin.getConfig().getBoolean("modules.regeneration")) {
            player.setInvulnerable(false);
        }
        if (this.plugin.getConfig().getBoolean("desktop.previews") && this.plugin.getTrackerKeeper().getPreviewers().containsKey(player.getUniqueId())) {
            player.setGameMode(GameMode.ADVENTURE);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PREVIEW_DONE");
        }
        UUID uuid = player.getUniqueId();
        if (this.plugin.getKitsConfig().getBoolean("give.join.enabled") && TARDISPermission.hasPermission(player, "tardis.kit.join")) {
            where = new HashMap<String, Object>();
            where.put("uuid", uuid);
            where.put("name", "joinkit");
            rsa = new ResultSetAchievements(this.plugin, where);
            if (!rsa.resultSet()) {
                set = new HashMap<String, Object>();
                set.put("uuid", uuid);
                set.put("name", "joinkit");
                this.plugin.getQueryFactory().doInsert("achievements", set);
                String kit = this.plugin.getKitsConfig().getString("give.join.kit");
                this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "tardisgive " + player.getName() + " kit " + kit);
            }
        }
        if (this.plugin.getConfig().getBoolean("allow.achievements") && TARDISPermission.hasPermission(player, "tardis.book")) {
            where = new HashMap();
            where.put("uuid", uuid);
            where.put("name", "tardis");
            rsa = new ResultSetAchievements(this.plugin, where);
            if (!rsa.resultSet()) {
                set = new HashMap();
                set.put("uuid", uuid);
                set.put("name", "tardis");
                this.plugin.getQueryFactory().doInsert("achievements", set);
                TARDISBook book = new TARDISBook(this.plugin);
                book.writeBook("Get transport", "Rassilon", "tardis", player);
            }
        }
        if (this.plugin.getConfig().getInt("travel.grace_period") > 0 && TARDISPermission.hasPermission(player, "tardis.create") && !(rsc = new ResultSetCount(this.plugin, uuid.toString())).resultSet()) {
            HashMap<String, Object> setc = new HashMap<String, Object>();
            setc.put("uuid", uuid);
            setc.put("player", player.getName());
            this.plugin.getQueryFactory().doInsert("t_count", setc);
        }
        where = new HashMap();
        where.put("uuid", uuid);
        ResultSetTravellers rst = new ResultSetTravellers(this.plugin, where, false);
        if (rst.resultSet()) {
            ResultSetCurrentFromId rsc2 = new ResultSetCurrentFromId(this.plugin, rst.getTardis_id());
            if (!rsc2.resultSet()) {
                Location teleport = player.getRespawnLocation() != null ? player.getRespawnLocation() : ((World)this.plugin.getServer().getWorlds().getFirst()).getSpawnLocation();
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> player.teleport(teleport), 1L);
                HashMap<String, Object> delete = new HashMap<String, Object>();
                delete.put("traveller_id", rst.getTraveller_id());
                this.plugin.getQueryFactory().doDelete("travellers", delete);
            } else if (this.plugin.getConfig().getBoolean("creation.keep_night")) {
                player.setPlayerTime(18000L, false);
            }
        }
        HashMap<String, Object> wherep = new HashMap<String, Object>();
        wherep.put("uuid", uuid);
        ResultSetTardis rs = new ResultSetTardis(this.plugin, wherep, "", false);
        if (rs.resultSet()) {
            World w;
            ResultSetCurrentFromId rsc3;
            Tardis tardis = rs.getTardis();
            int id = tardis.getTardisId();
            String owner = tardis.getOwner();
            String last_known_name = tardis.getLastKnownName();
            if (this.plugin.getConfig().getBoolean("police_box.keep_chunk_force_loaded") && (rsc3 = new ResultSetCurrentFromId(this.plugin, id)).resultSet() && (w = rsc3.getCurrent().location().getWorld()) != null) {
                Chunk chunk = w.getChunkAt(rsc3.getCurrent().location());
                while (!chunk.isLoaded()) {
                    chunk.load();
                }
                chunk.addPluginChunkTicket((Plugin)this.plugin);
            }
            long now = TARDISPermission.hasPermission(player, "tardis.prune.bypass") ? Long.MAX_VALUE : System.currentTimeMillis();
            HashMap<String, Object> set2 = new HashMap<String, Object>();
            set2.put("lastuse", now);
            set2.put("monsters", 0);
            set2.put("bedrock", TARDISFloodgate.isFloodgateEnabled() && TARDISFloodgate.isBedrockPlayer(player.getUniqueId()) ? 1 : 0);
            if (!last_known_name.equals(player.getName())) {
                if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard")) {
                    World cw = TARDISStaticLocationGetters.getWorldFromSplitString(tardis.getChunk());
                    this.plugin.getWorldGuardUtils().updateRegionForNameChange(cw, owner, player.getUniqueId(), "tardis");
                }
                set2.put("last_known_name", player.getName());
            }
            HashMap<String, Object> wherel = new HashMap<String, Object>();
            wherel.put("tardis_id", id);
            this.plugin.getQueryFactory().doUpdate("tardis", set2, wherel);
        }
        if (this.plugin.isDisguisesOnServer() && this.plugin.getConfig().getBoolean("arch.enabled")) {
            new ArchPersister(this.plugin).reArch(player.getUniqueId());
        }
        if (this.plugin.getConfig().getBoolean("allow.perception_filter")) {
            this.plugin.getFilter().addPlayer(player);
        }
        if (this.plugin.getConfig().getBoolean("allow.zero_room") && player.getLocation().getWorld().getName().equals("TARDIS_Zero_Room")) {
            this.plugin.getTrackerKeeper().getZeroRoomOccupants().add(player.getUniqueId());
        }
        if (SkinUtils.SKINNED.containsKey(player.getUniqueId())) {
            this.plugin.getSkinChanger().set(player, SkinUtils.SKINNED.get(player.getUniqueId()));
        }
        if (this.plugin.getTrackerKeeper().getJunkRelog().containsKey(player.getUniqueId())) {
            Location location = this.plugin.getTrackerKeeper().getJunkRelog().remove(player.getUniqueId());
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                int slot;
                player.teleport(location);
                if (player.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
                    player.removePotionEffect(PotionEffectType.INVISIBILITY);
                }
                ResultSetTardisID rsid = new ResultSetTardisID(this.plugin);
                if (this.plugin.getConfig().getBoolean("creation.default_world") && !player.hasPermission("tardis.create_world") ? !rsid.fromTIPSSlot(slot = TARDISInteriorPostioning.getTIPSSlot(player.getLocation())) : !rsid.fromUUID(player.getUniqueId().toString())) {
                    return;
                }
                int id = rsid.getTardisId();
                HashMap<String, Object> wherei = new HashMap<String, Object>();
                wherei.put("tardis_id", id);
                wherei.put("uuid", player.getUniqueId().toString());
                this.plugin.getQueryFactory().doInsert("travellers", wherei);
                CameraLocation cl = CameraTracker.SPECTATING.get(player.getUniqueId());
                if (cl != null) {
                    CameraTracker.CAMERA_IN_USE.remove(cl.id());
                    CameraTracker.SPECTATING.remove(player.getUniqueId());
                }
            }, 2L);
        }
    }
}

