/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.junk;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.exterior.BuildData;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.SpaceTimeThrottle;
import me.eccentric_nz.TARDIS.junk.JunkItsDangerousRunnable;
import me.eccentric_nz.TARDIS.particles.TARDISParticles;
import me.eccentric_nz.TARDIS.utility.TARDISSounds;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

class JunkVortexRunnable
implements Runnable {
    private static final int LOOPS = 12;
    private final TARDIS plugin;
    private final Location vortexJunkLoc;
    private final Location effectsLoc;
    private final Location destJunkLoc;
    private final OfflinePlayer player;
    private final int id;
    private int i = 0;
    private int task;
    private int fryTask;

    JunkVortexRunnable(TARDIS plugin, Location vortexJunkLoc, OfflinePlayer player, int id) {
        this.plugin = plugin;
        this.vortexJunkLoc = vortexJunkLoc;
        this.effectsLoc = this.vortexJunkLoc.clone().add(0.5, 0.0, 0.5);
        this.destJunkLoc = this.plugin.getGeneralKeeper().getJunkDestination();
        this.player = player;
        this.id = id;
    }

    @Override
    public void run() {
        if (this.i < 12) {
            ++this.i;
            if (this.i == 1) {
                this.fryTask = this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new JunkItsDangerousRunnable(this.plugin, this.vortexJunkLoc), 0L, 1L);
            }
            if (this.plugin.getConfig().getBoolean("junk.particles")) {
                this.plugin.getUtils().getJunkTravellers(this.vortexJunkLoc).forEach(e -> {
                    if (e instanceof Player) {
                        Player p = (Player)e;
                        TARDISParticles.sendVortexParticles(this.effectsLoc, p);
                    }
                });
            }
            if (this.i == 2) {
                TARDISSounds.playTARDISSound(this.vortexJunkLoc, "junk_arc");
            }
            if (this.i == 11) {
                BuildData bd = new BuildData(null);
                bd.setDirection(COMPASS.SOUTH);
                bd.setLocation(this.destJunkLoc);
                bd.setMalfunction(false);
                bd.setOutside(true);
                bd.setPlayer(this.player);
                bd.setRebuild(false);
                bd.setSubmarine(false);
                bd.setTardisID(this.id);
                bd.setThrottle(SpaceTimeThrottle.JUNK);
                this.plugin.getPresetBuilder().buildPreset(bd);
            }
            if (this.i == 12) {
                this.getJunkTravellers().forEach(e -> {
                    if (e instanceof Player) {
                        Player p = (Player)e;
                        Location relativeLoc = this.getRelativeLocation(p);
                        p.teleport(relativeLoc);
                        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                            p.teleport(relativeLoc);
                            p.resetPlayerTime();
                        }, 2L);
                    }
                });
                this.plugin.getServer().getScheduler().cancelTask(this.fryTask);
                this.plugin.getServer().getScheduler().cancelTask(this.task);
                this.task = 0;
            }
        }
    }

    private List<Entity> getJunkTravellers() {
        Entity orb = this.vortexJunkLoc.getWorld().spawnEntity(this.vortexJunkLoc, EntityType.EXPERIENCE_ORB);
        List ents = orb.getNearbyEntities(4.0, 4.0, 4.0);
        orb.remove();
        return ents;
    }

    private Location getRelativeLocation(Player p) {
        Location playerLoc = p.getLocation();
        double x = this.destJunkLoc.getX() + (playerLoc.getX() - this.vortexJunkLoc.getX());
        double y = this.destJunkLoc.getY() + (playerLoc.getY() - this.vortexJunkLoc.getY()) + 0.5;
        double z = this.destJunkLoc.getZ() + (playerLoc.getZ() - this.vortexJunkLoc.getZ());
        return new Location(this.destJunkLoc.getWorld(), x, y, z, playerLoc.getYaw(), playerLoc.getPitch());
    }

    public void setTask(int task) {
        this.task = task;
    }
}

