/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.floodgate;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.companionGUI.CompanionAddGUIListener;
import me.eccentric_nz.TARDIS.companionGUI.VanishChecker;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisCompanions;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.geysermc.cumulus.form.Form;
import org.geysermc.cumulus.form.SimpleForm;
import org.geysermc.cumulus.response.SimpleFormResponse;
import org.geysermc.floodgate.api.FloodgateApi;
import org.geysermc.floodgate.api.player.FloodgatePlayer;

public class FloodgateAddCompanionsForm {
    private final TARDIS plugin;
    private final UUID uuid;
    private final Player player;

    public FloodgateAddCompanionsForm(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.player = this.plugin.getServer().getPlayer(this.uuid);
    }

    public void send() {
        SimpleForm.Builder builder = SimpleForm.builder();
        builder.title("TARDIS Add Companion");
        builder.content("To ADD a companion select a player button.");
        ResultSetTardisCompanions rs = new ResultSetTardisCompanions(this.plugin);
        List<Object> comps = rs.fromUUID(this.uuid.toString()) && rs.getCompanions() != null && !rs.getCompanions().isEmpty() ? List.of(rs.getCompanions().split(":")) : new ArrayList();
        for (Player p : this.plugin.getServer().getOnlinePlayers()) {
            UUID puid = p.getUniqueId();
            if (puid == this.uuid || comps.contains(puid.toString()) || !VanishChecker.canSee(this.player, p)) continue;
            builder.button(p.getName());
        }
        builder.button("Everyone");
        builder.validResultHandler(this::handleResponse);
        SimpleForm form = (SimpleForm)builder.build();
        FloodgatePlayer player = FloodgateApi.getInstance().getPlayer(this.uuid);
        player.sendForm((Form)form);
    }

    private void handleResponse(SimpleFormResponse response) {
        Player player = Bukkit.getPlayer((UUID)this.uuid);
        String label = response.clickedButton().text();
        HashMap<String, Object> wherea = new HashMap<String, Object>();
        wherea.put("uuid", player.getUniqueId().toString());
        ResultSetTardis rsa = new ResultSetTardis(this.plugin, wherea, "", false);
        if (rsa.resultSet()) {
            Tardis tardis = rsa.getTardis();
            int id = tardis.getTardisId();
            String comps = tardis.getCompanions();
            if (label.equals("Everyone")) {
                CompanionAddGUIListener.addCompanion(id, comps, "everyone");
                if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard")) {
                    String[] data = tardis.getChunk().split(":");
                    this.plugin.getWorldGuardUtils().removeAllMembersFromRegion(TARDISAliasResolver.getWorldFromAlias(data[0]), player.getName(), player.getUniqueId());
                    this.plugin.getWorldGuardUtils().setEntryExitFlags(data[0], player.getName(), true);
                }
                this.plugin.getMessenger().sendInsertedColour((CommandSender)player, "COMPANIONS_ADD", "everyone", this.plugin);
                this.plugin.getMessenger().sendColouredCommand((CommandSender)player, "COMPANIONS_EVERYONE", "/tardis remove all", this.plugin);
            } else {
                OfflinePlayer op = this.plugin.getServer().getOfflinePlayer(label);
                if (op != null) {
                    String u = op.getUniqueId().toString();
                    CompanionAddGUIListener.addCompanion(id, comps, u);
                    if (this.plugin.isWorldGuardOnServer() && this.plugin.getConfig().getBoolean("preferences.use_worldguard")) {
                        String[] data = tardis.getChunk().split(":");
                        CompanionAddGUIListener.addToRegion(data[0], tardis.getOwner(), label);
                        this.plugin.getWorldGuardUtils().setEntryExitFlags(data[0], label, false);
                    }
                    this.plugin.getMessenger().sendInsertedColour((CommandSender)player, "COMPANIONS_ADD", label, this.plugin);
                }
            }
        }
    }
}

