/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.desktop;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.builders.interior.TARDISInteriorPostioning;
import me.eccentric_nz.TARDIS.builders.interior.TIPSData;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;

class Delavafier {
    private final TARDIS plugin;
    private final UUID uuid;
    private final BlockData ORANGE = Material.ORANGE_TERRACOTTA.createBlockData();
    private final BlockData GLASS = Material.LIGHT_BLUE_STAINED_GLASS.createBlockData();

    Delavafier(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
    }

    void swap() {
        HashMap<String, Object> wheret = new HashMap<String, Object>();
        wheret.put("uuid", this.uuid.toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, wheret, "", false);
        if (rs.resultSet()) {
            int startz;
            int startx;
            Tardis tardis = rs.getTardis();
            int slot = tardis.getTIPS();
            if (slot != -1000001) {
                TARDISInteriorPostioning tintpos = new TARDISInteriorPostioning(this.plugin);
                TIPSData pos = tintpos.getTIPSData(slot);
                startx = pos.getCentreX();
                startz = pos.getCentreZ();
            } else {
                int[] gsl = this.plugin.getLocationUtils().getStartLocation(tardis.getTardisId());
                startx = gsl[0];
                startz = gsl[2];
            }
            World world = TARDISStaticLocationGetters.getWorldFromSplitString(tardis.getChunk());
            for (int level = 2; level < 6; ++level) {
                for (int row = 0; row < 32; ++row) {
                    for (int col = 0; col < 32; ++col) {
                        int x = startx + row;
                        int starty = 64;
                        int y = starty + level;
                        int z = startz + col;
                        Block b = world.getBlockAt(x, y, z);
                        Material type = b.getType();
                        if (type.equals((Object)Material.LAVA)) {
                            b.setBlockData(this.ORANGE);
                        }
                        if (!type.equals((Object)Material.WATER)) continue;
                        b.setBlockData(this.GLASS);
                    }
                }
            }
        }
    }
}

