/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.utils;

import java.util.Collection;
import java.util.List;
import me.eccentric_nz.TARDIS.commands.utils.Arguments;

public class ArgumentParser {
    private static final Collection<Character> QUOTATION_MARKS = List.of(Character.valueOf('\''), Character.valueOf('\"'));
    private static final Character SPACE = Character.valueOf(' ');

    private static void addAndClear(StringBuilder sb, Arguments arguments) {
        arguments.addArgument(sb.toString().trim());
        sb.setLength(0);
    }

    public Arguments parse(String raw) {
        char[] chars = raw.toCharArray();
        Arguments arguments = new Arguments();
        StringBuilder sb = new StringBuilder();
        boolean quote = false;
        int i = 0;
        for (char c : chars) {
            ++i;
            if (!quote && c == SPACE.charValue()) {
                ArgumentParser.addAndClear(sb, arguments);
                continue;
            }
            if (QUOTATION_MARKS.contains(Character.valueOf(c))) {
                boolean bl = quote = !quote;
                if (i != chars.length) continue;
                ArgumentParser.addAndClear(sb, arguments);
                continue;
            }
            sb.append(c);
            if (i < chars.length) continue;
            ArgumentParser.addAndClear(sb, arguments);
        }
        return arguments;
    }

    public String join(String[] args) {
        return String.join((CharSequence)" ", args);
    }
}

