/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.autonomous;

import java.util.ArrayList;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.GUIAutonomous;
import me.eccentric_nz.TARDIS.custommodels.keys.SwitchVariant;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAutonomousSave;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Material;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class AutonomousInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final UUID uuid;
    private final ItemStack off;
    private final Inventory inventory;

    public AutonomousInventory(TARDIS plugin, UUID uuid) {
        this.plugin = plugin;
        this.uuid = uuid;
        this.off = ItemStack.of((Material)Material.LIGHT_GRAY_CARPET, (int)1);
        ItemMeta offMeta = this.off.getItemMeta();
        offMeta.displayName((Component)Component.text((String)plugin.getLanguage().getString("SET_OFF", "OFF"), (TextColor)NamedTextColor.RED));
        this.off.setItemMeta(offMeta);
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 36, (Component)Component.text((String)"TARDIS Autonomous Menu", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack[] stack = new ItemStack[36];
        stack[12] = this.off;
        stack[13] = this.off;
        stack[14] = this.off;
        stack[15] = this.off;
        stack[16] = this.off;
        stack[30] = this.off;
        stack[31] = this.off;
        for (GUIAutonomous a : GUIAutonomous.values()) {
            CustomModelDataComponent component;
            ItemStack is = ItemStack.of((Material)a.getMaterial(), (int)1);
            ItemMeta im = is.getItemMeta();
            im.displayName((Component)(a.getName().contains("Selected") ? Component.text((String)this.plugin.getLanguage().getString("SET_ON", "ON"), (TextColor)NamedTextColor.GREEN) : Component.text((String)a.getName())));
            if (a == GUIAutonomous.AUTONOMOUS_TYPE) {
                component = im.getCustomModelDataComponent();
                component.setFloats(SwitchVariant.AUTO_TYPE.getFloats());
                im.setCustomModelDataComponent(component);
            }
            if (a == GUIAutonomous.FALLBACK) {
                component = im.getCustomModelDataComponent();
                component.setFloats(SwitchVariant.AUTO_DEFAULT.getFloats());
                im.setCustomModelDataComponent(component);
            }
            if (a == GUIAutonomous.SAVE_SELECTOR) {
                ResultSetAutonomousSave rsd;
                ArrayList<Component> lore = new ArrayList<Component>(a.getLore());
                ResultSetTardisID rst = new ResultSetTardisID(this.plugin);
                if (rst.fromUUID(this.uuid.toString()) && (rsd = new ResultSetAutonomousSave(this.plugin)).fromID(rst.getTardisId())) {
                    lore.add((Component)Component.text((String)rsd.getAutonomous(), (TextColor)NamedTextColor.GREEN));
                }
                im.lore(lore);
            } else if (a.getLore() != null) {
                im.lore(a.getLore());
            }
            is.setItemMeta(im);
            int slot = a.getSlot() == -1 ? this.findSlot(a) : a.getSlot();
            stack[slot] = is;
        }
        return stack;
    }

    private int findSlot(GUIAutonomous a) {
        ResultSetPlayerPrefs rsp = new ResultSetPlayerPrefs(this.plugin, this.uuid.toString());
        if (rsp.resultSet()) {
            return a.equals((Object)GUIAutonomous.SELECTED_TYPE) ? rsp.getAutoType().getSlot() : rsp.getAutoDefault().getSlot();
        }
        return 35;
    }
}

