/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.silurians;

import java.util.Collection;
import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngelSpawnEvent;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.equip.Equipper;
import me.eccentric_nz.tardisweepingangels.monsters.silurians.CaveFinder;
import me.eccentric_nz.tardisweepingangels.nms.MonsterSpawner;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import me.eccentric_nz.tardisweepingangels.utils.WorldGuardChecker;
import me.eccentric_nz.tardisweepingangels.utils.WorldProcessor;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Skeleton;
import org.bukkit.event.Event;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class SilurianRunnable
implements Runnable {
    private final TARDIS plugin;
    private final int spawn_rate;

    public SilurianRunnable(TARDIS plugin) {
        this.plugin = plugin;
        this.spawn_rate = plugin.getMonstersConfig().getInt("spawn_rate.how_many");
    }

    @Override
    public void run() {
        this.plugin.getServer().getWorlds().forEach(w -> {
            String name = WorldProcessor.sanitiseName(w.getName());
            if (this.plugin.getMonstersConfig().getInt("silurians.worlds." + name) > 0) {
                int silurians = 0;
                Collection skeletons = w.getEntitiesByClass(Skeleton.class);
                for (Skeleton s : skeletons) {
                    PersistentDataContainer pdc = s.getPersistentDataContainer();
                    if (!pdc.has(TARDISWeepingAngels.SILURIAN, PersistentDataType.INTEGER)) continue;
                    ++silurians;
                }
                if (silurians < this.plugin.getMonstersConfig().getInt("silurians.worlds." + name)) {
                    for (int i = 0; i < this.spawn_rate; ++i) {
                        this.spawnSilurian((World)w);
                    }
                }
            }
        });
    }

    private void spawnSilurian(World world) {
        List players = world.getPlayers();
        if (players.isEmpty()) {
            return;
        }
        for (Player p : players) {
            Location cave;
            Location playerLocation = p.getLocation();
            int y = playerLocation.getBlockY();
            if (y <= -55 || y >= 48 || (cave = CaveFinder.searchSpawnPoint(playerLocation, this.plugin.getMonstersConfig().getBoolean("silurians.check_slime_chunk"))) == null || this.plugin.isWorldGuardOnServer() && !WorldGuardChecker.canSpawn(cave)) continue;
            LivingEntity silurian = new MonsterSpawner().create(cave, Monster.SILURIAN);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                new Equipper(Monster.SILURIAN, silurian, false).setHelmetAndInvisibility();
                this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent((Entity)silurian, EntityType.SKELETON, Monster.SILURIAN, cave));
            }, 5L);
        }
    }
}

