/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.commands;

import java.util.Collection;
import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Bee;
import org.bukkit.entity.Drowned;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Husk;
import org.bukkit.entity.PigZombie;
import org.bukkit.entity.Skeleton;
import org.bukkit.entity.Stray;
import org.bukkit.entity.Zombie;
import org.bukkit.persistence.PersistentDataType;

public class KillCommand {
    private final TARDIS plugin;

    public KillCommand(TARDIS plugin) {
        this.plugin = plugin;
    }

    public boolean kill(CommandSender sender, String[] args) {
        Monster monster;
        if (args.length < 3) {
            return false;
        }
        String which = args[1].toUpperCase(Locale.ROOT);
        World w = this.plugin.getServer().getWorld(args[2]);
        if (w == null) {
            this.plugin.getMessenger().send(sender, TardisModule.MONSTERS, "COULD_NOT_FIND_WORLD");
            return true;
        }
        int count = 0;
        Object what = "Angels";
        try {
            monster = Monster.valueOf(which);
        }
        catch (IllegalArgumentException e) {
            if (which.equals("OLD_SILENT")) {
                Collection silence = w.getEntitiesByClass(Enderman.class);
                for (Enderman m : silence) {
                    if (m.getPassengers().isEmpty() || m.getPassengers().getFirst() == null || !((Entity)m.getPassengers().getFirst()).getType().equals((Object)EntityType.GUARDIAN)) continue;
                    ((Entity)m.getPassengers().getFirst()).remove();
                    m.remove();
                    ++count;
                }
                this.plugin.getMessenger().send(sender, TardisModule.MONSTERS, "WA_SILENT", count, "Silent Endermen", w.getName());
            } else {
                this.plugin.getMessenger().send(sender, TardisModule.MONSTERS, "WA_INVALID");
            }
            return true;
        }
        switch (monster) {
            case ANGEL_OF_LIBERTY: 
            case THE_BEAST: 
            case CYBERMAN: 
            case EMPTY_CHILD: 
            case NIMON: 
            case VASHTA_NERADA: 
            case CLOCKWORK_DROID: 
            case CYBERSHADE: 
            case HEAVENLY_HOST: 
            case OSSIFIED: 
            case SCARECROW: 
            case SLITHEEN: 
            case SMILER: 
            case SONTARAN: 
            case SYCORAX: 
            case ZYGON: {
                switch (monster) {
                    case ANGEL_OF_LIBERTY: {
                        what = "Angels of Liberty";
                        break;
                    }
                    case THE_BEAST: {
                        what = "The Beast";
                        break;
                    }
                    case CYBERMAN: {
                        what = "Cybermen";
                        break;
                    }
                    case EMPTY_CHILD: {
                        what = "Empty Children";
                        break;
                    }
                    case NIMON: {
                        what = "Nimon";
                        break;
                    }
                    case VASHTA_NERADA: {
                        what = "Vashta Nerada";
                        break;
                    }
                    default: {
                        what = monster.getName() + "s";
                    }
                }
                Collection zombies = w.getEntitiesByClass(Zombie.class);
                for (Zombie z : zombies) {
                    if (!z.getPersistentDataContainer().has(TARDISWeepingAngels.PDC_KEYS.get((Object)monster), PersistentDataType.INTEGER)) continue;
                    z.remove();
                    ++count;
                }
                break;
            }
            case DALEK: 
            case HEADLESS_MONK: 
            case MIRE: 
            case OMEGA: 
            case SILURIAN: 
            case WEEPING_ANGEL: {
                what = monster.getName() + "s";
                Collection skeletons = w.getEntitiesByClass(Skeleton.class);
                for (Skeleton s : skeletons) {
                    if (!s.getPersistentDataContainer().has(TARDISWeepingAngels.PDC_KEYS.get((Object)monster), PersistentDataType.INTEGER)) continue;
                    s.remove();
                    ++count;
                }
                break;
            }
            case SATURNYNIAN: 
            case SEA_DEVIL: 
            case VAMPIRE_OF_VENICE: {
                what = monster == Monster.VAMPIRE_OF_VENICE ? "Vampires of Venice" : monster.getName() + "s";
                Collection drowned = w.getEntitiesByClass(Drowned.class);
                for (Drowned d : drowned) {
                    if (!d.getPersistentDataContainer().has(TARDISWeepingAngels.PDC_KEYS.get((Object)monster), PersistentDataType.INTEGER)) continue;
                    d.remove();
                    ++count;
                }
                break;
            }
            case DALEK_SEC: 
            case DAVROS: 
            case HATH: 
            case ICE_WARRIOR: 
            case STRAX: {
                what = monster.equals((Object)Monster.ICE_WARRIOR) ? "Ice Warriors" : monster.getName();
                Collection pigZombies = w.getEntitiesByClass(PigZombie.class);
                for (PigZombie p : pigZombies) {
                    if (!p.getPersistentDataContainer().has(TARDISWeepingAngels.PDC_KEYS.get((Object)monster), PersistentDataType.INTEGER)) continue;
                    p.remove();
                    ++count;
                }
                break;
            }
            case SILENT: {
                what = "Silence";
                Collection silence = w.getEntitiesByClass(Skeleton.class);
                for (Skeleton m : silence) {
                    if (m.getPassengers().isEmpty() || m.getPassengers().getFirst() == null || !((Entity)m.getPassengers().getFirst()).getType().equals((Object)EntityType.GUARDIAN)) continue;
                    ((Entity)m.getPassengers().getFirst()).remove();
                    m.remove();
                    ++count;
                }
                break;
            }
            case SUTEKH: {
                what = "Sutekh";
                Collection strays = w.getEntitiesByClass(Stray.class);
                for (Stray s : strays) {
                    if (!s.getPersistentDataContainer().has(TARDISWeepingAngels.PDC_KEYS.get((Object)monster), PersistentDataType.INTEGER)) continue;
                    s.remove();
                    ++count;
                }
                break;
            }
            case OOD: 
            case JUDOON: 
            case K9: {
                Collection ood = w.getEntitiesByClass(Husk.class);
                for (Husk o : ood) {
                    if (o.getPersistentDataContainer().has(TARDISWeepingAngels.OOD, TARDISWeepingAngels.PersistentDataTypeUUID)) {
                        what = "Ood";
                        o.remove();
                        ++count;
                        continue;
                    }
                    if (o.getPersistentDataContainer().has(TARDISWeepingAngels.JUDOON, TARDISWeepingAngels.PersistentDataTypeUUID)) {
                        what = "Judoon";
                        o.remove();
                        ++count;
                        continue;
                    }
                    if (!o.getPersistentDataContainer().has(TARDISWeepingAngels.K9, TARDISWeepingAngels.PersistentDataTypeUUID)) continue;
                    what = "K9s";
                    o.remove();
                    ++count;
                }
                break;
            }
            case TOCLAFANE: {
                Collection toclafanes = w.getEntitiesByClass(ArmorStand.class);
                for (ArmorStand t : toclafanes) {
                    if (!t.getPersistentDataContainer().has(TARDISWeepingAngels.TOCLAFANE, PersistentDataType.INTEGER)) continue;
                    what = "Toclafane";
                    if (t.getVehicle() != null) {
                        Entity bee = t.getVehicle();
                        if (bee instanceof Bee) {
                            t.remove();
                            bee.remove();
                        }
                    } else {
                        t.remove();
                    }
                    ++count;
                }
                break;
            }
        }
        this.plugin.getMessenger().send(sender, TardisModule.MONSTERS, "WA_REMOVED", count, what, w.getName());
        return true;
    }
}

