/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisshop.listener;

import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import me.eccentric_nz.tardisshop.ShopItem;
import me.eccentric_nz.tardisshop.ShopItemGetter;
import me.eccentric_nz.tardisshop.TARDISShopItem;
import me.eccentric_nz.tardisshop.TARDISShopItemSpawner;
import me.eccentric_nz.tardisshop.database.DeleteShopItem;
import me.eccentric_nz.tardisshop.database.ResultSetShopItem;
import me.eccentric_nz.tardisshop.database.UpdateShopItem;
import org.bukkit.Location;
import org.bukkit.OfflinePlayer;
import org.bukkit.block.Block;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.Player;
import org.bukkit.entity.TextDisplay;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.block.Action;
import org.bukkit.event.player.PlayerInteractEvent;
import org.bukkit.inventory.EquipmentSlot;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.util.BoundingBox;

public class TARDISShopItemInteract
implements Listener {
    private final TARDIS plugin;

    public TARDISShopItemInteract(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.NORMAL)
    public void onInteract(PlayerInteractEvent event) {
        if (event.getHand() != EquipmentSlot.HAND) {
            return;
        }
        Block block = event.getClickedBlock();
        if (block != null && block.getType() == this.plugin.getShopSettings().getBlockMaterial()) {
            Location location = block.getLocation();
            if (event.getAction() == Action.RIGHT_CLICK_BLOCK) {
                Player player = event.getPlayer();
                UUID uuid = player.getUniqueId();
                if (this.plugin.getShopSettings().getSettingItem().containsKey(uuid)) {
                    TARDISShopItem item = this.plugin.getShopSettings().getSettingItem().get(uuid);
                    new TARDISShopItemSpawner(this.plugin).setItem(location, item);
                    new UpdateShopItem(this.plugin).addLocation(location.toString(), item.id());
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.SHOP, "SHOP_LOCATION_ADDED");
                    this.plugin.getShopSettings().getSettingItem().remove(uuid);
                } else if (this.plugin.getShopSettings().getRemovingItem().contains(uuid)) {
                    BoundingBox box = new BoundingBox((double)block.getX(), (double)block.getY(), (double)block.getZ(), (double)(block.getX() + 1), (double)block.getY() + 2.5, (double)(block.getZ() + 1));
                    for (Entity e : block.getWorld().getNearbyEntities(box)) {
                        if (!(e instanceof ItemDisplay) && !(e instanceof TextDisplay) && (!(e instanceof Item) || !e.getPersistentDataContainer().has(this.plugin.getShopSettings().getItemKey(), PersistentDataType.INTEGER)) && !(e instanceof ArmorStand)) continue;
                        e.remove();
                    }
                    if (new DeleteShopItem(this.plugin).removeByLocation(location.toString()) > 0) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.SHOP, "SHOP_ITEM_REMOVED");
                    } else {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.SHOP, "SHOP_NOT_FOUND");
                    }
                    this.plugin.getShopSettings().getRemovingItem().remove(uuid);
                } else {
                    ResultSetShopItem rs = new ResultSetShopItem(this.plugin);
                    if (rs.itemFromBlock(location.toString())) {
                        String message;
                        TARDISShopItem item = rs.getShopItem();
                        if (TARDISPermission.hasPermission(player, "tardis.admin") && this.plugin.getShopConfig().getBoolean("tardis_admin_free")) {
                            this.giveItem(item.item(), player);
                            message = "SHOP_FREE";
                        } else if (this.plugin.getShopSettings().getEconomy().getBalance((OfflinePlayer)player) > item.cost()) {
                            this.giveItem(item.item(), player);
                            this.plugin.getShopSettings().getEconomy().withdrawPlayer((OfflinePlayer)player, item.cost());
                            message = "SHOP_PURCHASED";
                        } else {
                            message = "SHOP_NO_FUNDS";
                        }
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.SHOP, message);
                    }
                }
            } else if (event.getAction() == Action.LEFT_CLICK_BLOCK) {
                ResultSetShopItem rs = new ResultSetShopItem(this.plugin);
                event.setCancelled(rs.itemFromBlock(location.toString()));
            }
        }
    }

    private void giveItem(String item, Player player) {
        try {
            ItemStack is;
            ShopItem recipe = ShopItem.valueOf(TARDISStringUtils.toEnumUppercase(item));
            switch (recipe.getRecipeType()) {
                case BLUEPRINT: {
                    ItemStack itemStack = ShopItemGetter.getBlueprintItem(recipe, player);
                    break;
                }
                case TWA: {
                    ItemStack itemStack = ShopItemGetter.getTWAItem(recipe);
                    break;
                }
                case SEED: {
                    ItemStack itemStack = ShopItemGetter.getSeedItem(recipe);
                    break;
                }
                default: {
                    ItemStack itemStack = is = ShopItemGetter.getShapeItem(recipe, player);
                }
            }
            if (is != null) {
                HashMap res = player.getInventory().addItem(new ItemStack[]{is});
                if (!res.isEmpty()) {
                    for (ItemStack stack : res.values()) {
                        player.getWorld().dropItem(player.getLocation(), stack);
                    }
                }
                player.updateInventory();
            }
        }
        catch (IllegalArgumentException e) {
            this.plugin.debug("Could not get ShopItemRecipe from item string. " + e.getMessage());
        }
    }
}

