/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.utility;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.database.converters.ShopTransfer;
import me.eccentric_nz.TARDIS.database.converters.VortexManipulatorTransfer;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.files.AllInOneConfigConverter;
import me.eccentric_nz.tardischemistry.block.ChemistryBlockRecipes;
import me.eccentric_nz.tardischemistry.lab.BleachRecipe;
import me.eccentric_nz.tardischemistry.lab.HeatBlockRunnable;
import me.eccentric_nz.tardischemistry.microscope.Microscope;
import me.eccentric_nz.tardischemistry.product.GlowStickRunnable;
import me.eccentric_nz.tardisregeneration.TARDISRegeneration;
import me.eccentric_nz.tardisshop.TARDISShop;
import me.eccentric_nz.tardisshop.TARDISShopDisplayConverter;
import me.eccentric_nz.tardissonicblaster.TARDISSonicBlaster;
import me.eccentric_nz.tardisvortexmanipulator.TARDISVortexManipulator;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.nms.TARDISEntityRegister;
import org.bukkit.command.CommandSender;
import org.bukkit.plugin.Plugin;

public class TARDISModuleLoader {
    private final TARDIS plugin;
    private int conversions = 0;

    public TARDISModuleLoader(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void enable() {
        if (this.plugin.getConfig().getBoolean("modules.chemistry")) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.CHEMISTRY, "Loading Chemistry Module");
            new Microscope(this.plugin).enable();
            new ChemistryBlockRecipes(this.plugin).addRecipes();
            new BleachRecipe(this.plugin).setRecipes();
            this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new GlowStickRunnable(this.plugin), 200L, 200L);
            this.plugin.getServer().getScheduler().scheduleSyncRepeatingTask((Plugin)this.plugin, (Runnable)new HeatBlockRunnable(this.plugin), 200L, 80L);
        }
        if (this.plugin.getConfig().getBoolean("modules.weeping_angels")) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.MONSTERS, "Loading Weeping Angels Module");
            new TARDISEntityRegister().inject();
            new TARDISWeepingAngels(this.plugin).enable();
            if (!this.plugin.getConfig().getBoolean("conversions.all_in_one.weeping_angels") && new AllInOneConfigConverter(this.plugin).transferConfig(TardisModule.MONSTERS)) {
                this.plugin.getConfig().set("conversions.all_in_one.weeping_angels", (Object)true);
                ++this.conversions;
            }
        }
        if (this.plugin.getConfig().getBoolean("modules.vortex_manipulator")) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.VORTEX_MANIPULATOR, "Loading Vortex Manipulator Module");
            new TARDISVortexManipulator(this.plugin).enable();
            if (!this.plugin.getConfig().getBoolean("conversions.all_in_one.vortex_manipulator")) {
                boolean cvm = new AllInOneConfigConverter(this.plugin).transferConfig(TardisModule.VORTEX_MANIPULATOR);
                boolean dvm = new VortexManipulatorTransfer(this.plugin).transferData();
                if (cvm && dvm) {
                    this.plugin.getConfig().set("conversions.all_in_one.vortex_manipulator", (Object)true);
                    ++this.conversions;
                }
            }
        }
        if (this.plugin.getConfig().getBoolean("modules.regeneration")) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.REGENERATION, "Loading Regeneration Module");
            new TARDISRegeneration(this.plugin).enable();
        }
        if (this.plugin.getConfig().getBoolean("modules.shop")) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.SHOP, "Loading Shop Module");
            new TARDISShop(this.plugin).enable();
            if (!this.plugin.getConfig().getBoolean("conversions.all_in_one.shop")) {
                boolean cs = new AllInOneConfigConverter(this.plugin).transferConfig(TardisModule.SHOP);
                boolean ds = new ShopTransfer(this.plugin).transferData();
                this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new TARDISShopDisplayConverter(this.plugin), 300L);
                if (cs && ds) {
                    this.plugin.getConfig().set("conversions.all_in_one.shop", (Object)true);
                    ++this.conversions;
                }
            }
        }
        if (this.plugin.getConfig().getBoolean("modules.sonic_blaster")) {
            this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.BLASTER, "Loading Sonic Blaster Module");
            new TARDISSonicBlaster(this.plugin).enable();
            if (!this.plugin.getConfig().getBoolean("conversions.all_in_one.sonic_blaster") && new AllInOneConfigConverter(this.plugin).transferConfig(TardisModule.BLASTER)) {
                this.plugin.getConfig().set("conversions.all_in_one.sonic_blaster", (Object)true);
                ++this.conversions;
            }
        }
        if (this.conversions > 0) {
            this.plugin.saveConfig();
        }
    }
}

