/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rotors;

import java.util.Locale;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.custommodels.keys.RotorVariant;
import me.eccentric_nz.TARDIS.rotors.Rotor;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import me.eccentric_nz.TARDIS.utility.TARDISStringUtils;
import org.bukkit.Material;
import org.bukkit.NamespacedKey;
import org.bukkit.plugin.Plugin;

public class CustomTimeRotorLoader {
    private final TARDIS plugin;

    public CustomTimeRotorLoader(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void addRotors() {
        Rotor early = new Rotor("early", RotorVariant.TIME_ROTOR_EARLY_OFF.getKey(), Material.BLACK_DYE, new int[]{0, 1, 2, 3, 4, 5, 6, 7}, 6L, false);
        Rotor console = new Rotor("console", RotorVariant.TIME_ROTOR_CONSOLE_OFF.getKey(), Material.RED_DYE, new int[]{0, 0, 1, 2, 3, 4, 3, 2, 1}, 2L, false);
        Rotor delta = new Rotor("delta", RotorVariant.TIME_ROTOR_DELTA_OFF.getKey(), Material.CYAN_DYE, new int[]{0, 1, 2, 3, 4, 5}, 4L, false);
        Rotor eleventh = new Rotor("eleventh", RotorVariant.TIME_ROTOR_ELEVENTH_OFF.getKey(), Material.BROWN_DYE, new int[]{0, 0, 1, 2, 3, 4, 3, 2, 1}, 2L, false);
        Rotor engine = new Rotor("engine", RotorVariant.ENGINE_OFF.getKey(), Material.LIGHT_BLUE_DYE, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12}, 2L, false);
        Rotor engine_rotor = new Rotor("engine_rotor", RotorVariant.ENGINE_ROTOR_OFF.getKey(), Material.BLUE_DYE, new int[]{0, 1, 2, 3, 4, 5, 4, 3, 2, 1}, 3L, false);
        Rotor hospital = new Rotor("hospital", RotorVariant.HOSPITAL_OFF.getKey(), Material.WHITE_DYE, new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11}, 2L, false);
        Rotor twelfth = new Rotor("twelfth", RotorVariant.TIME_ROTOR_TWELFTH_OFF.getKey(), Material.GRAY_DYE, new int[]{0}, 1L, false);
        Rotor rustic = new Rotor("rustic", RotorVariant.TIME_ROTOR_RUSTIC_OFF.getKey(), Material.GREEN_DYE, new int[]{0, 0, 1, 2, 3, 4, 3, 2, 1}, 2L, false);
        Rotor tennant = new Rotor("tennant", RotorVariant.TIME_ROTOR_TENNANT_OFF.getKey(), Material.ORANGE_DYE, new int[]{0, 0, 1, 2, 3, 4, 3, 2, 1}, 3L, false);
        Rotor.byMaterial.put(Material.BLACK_DYE, early);
        Rotor.byCustomModel.put(RotorVariant.TIME_ROTOR_EARLY_OFF.getKey(), early);
        Rotor.byName.put("TIME_ROTOR_EARLY", early);
        Rotor.byMaterial.put(Material.ORANGE_DYE, tennant);
        Rotor.byCustomModel.put(RotorVariant.TIME_ROTOR_TENNANT_OFF.getKey(), tennant);
        Rotor.byName.put("TIME_ROTOR_TENNANT", tennant);
        Rotor.byMaterial.put(Material.RED_DYE, console);
        Rotor.byCustomModel.put(RotorVariant.TIME_ROTOR_CONSOLE_OFF.getKey(), console);
        Rotor.byName.put("TIME_ROTOR_CONSOLE", console);
        Rotor.byMaterial.put(Material.GREEN_DYE, rustic);
        Rotor.byCustomModel.put(RotorVariant.TIME_ROTOR_RUSTIC_OFF.getKey(), rustic);
        Rotor.byName.put("TIME_ROTOR_RUSTIC", rustic);
        Rotor.byMaterial.put(Material.BROWN_DYE, eleventh);
        Rotor.byCustomModel.put(RotorVariant.TIME_ROTOR_ELEVENTH_OFF.getKey(), eleventh);
        Rotor.byName.put("TIME_ROTOR_ELEVENTH", eleventh);
        Rotor.byMaterial.put(Material.GRAY_DYE, twelfth);
        Rotor.byCustomModel.put(RotorVariant.TIME_ROTOR_TWELFTH_OFF.getKey(), twelfth);
        Rotor.byName.put("TIME_ROTOR_TWELFTH", twelfth);
        Rotor.byMaterial.put(Material.CYAN_DYE, delta);
        Rotor.byCustomModel.put(RotorVariant.TIME_ROTOR_DELTA_OFF.getKey(), delta);
        Rotor.byName.put("TIME_ROTOR_DELTA", delta);
        Rotor.byMaterial.put(Material.LIGHT_BLUE_DYE, engine);
        Rotor.byCustomModel.put(RotorVariant.ENGINE_OFF.getKey(), engine);
        Rotor.byName.put("TIME_ENGINE", engine);
        Rotor.byMaterial.put(Material.BLUE_DYE, engine_rotor);
        Rotor.byCustomModel.put(RotorVariant.ENGINE_ROTOR_OFF.getKey(), engine_rotor);
        Rotor.byName.put("TIME_ROTOR_ENGINE", engine_rotor);
        Rotor.byMaterial.put(Material.WHITE_DYE, hospital);
        Rotor.byCustomModel.put(RotorVariant.HOSPITAL_OFF.getKey(), hospital);
        Rotor.byName.put("TIME_ROTOR_HOSPITAL", hospital);
        for (String r : this.plugin.getCustomRotorsConfig().getKeys(false)) {
            try {
                Material material = Material.valueOf((String)this.plugin.getCustomRotorsConfig().getString(r + ".animated_material"));
                int[] frames = this.getFrames(this.plugin.getCustomRotorsConfig().getString(r + ".animation_sequence", "0,0"));
                NamespacedKey key = new NamespacedKey((Plugin)this.plugin, "time_rotor_" + TARDISStringUtils.toDashedLowercase(r) + "_off");
                Rotor column = new Rotor(r, key, material, frames, this.plugin.getCustomRotorsConfig().getInt(r + ".frame_rate"), true);
                Rotor.byMaterial.put(material, column);
                Rotor.byCustomModel.put(key, column);
                Rotor.byName.put("TIME_ROTOR_" + r.toUpperCase(Locale.ROOT), column);
            }
            catch (IllegalArgumentException e) {
                this.plugin.debug("Invalid custom rotor item material for " + r + "!");
            }
        }
    }

    private int[] getFrames(String sequence) {
        String[] split = sequence.split(",");
        int[] frames = new int[split.length];
        for (int n = 0; n < split.length; ++n) {
            frames[n] = TARDISNumberParsers.parseInt(split[n]);
        }
        return frames;
    }
}

