/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.playerprefs;

import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.playerprefs.TARDISKeyMenuListener;
import me.eccentric_nz.TARDIS.playerprefs.TARDISSonicMenuInventory;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import net.kyori.adventure.text.format.TextDecoration;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.ClickType;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.InventoryView;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class TARDISSonicMenuListener
extends TARDISMenuListener {
    private final TARDIS plugin;

    public TARDISSonicMenuListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    @EventHandler(ignoreCancelled=true)
    public void onSonicMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISSonicMenuInventory)) {
            return;
        }
        Player p = (Player)event.getWhoClicked();
        int slot = event.getRawSlot();
        if (slot < 0 || slot > 35) {
            ClickType click = event.getClick();
            if (click.equals((Object)ClickType.SHIFT_RIGHT) || click.equals((Object)ClickType.SHIFT_LEFT) || click.equals((Object)ClickType.DOUBLE_CLICK)) {
                TARDIS.plugin.debug("TARDISonicMenuListener");
                event.setCancelled(true);
            }
            return;
        }
        InventoryView view = event.getView();
        switch (slot) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 12: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 18: {
                event.setCancelled(true);
                ItemStack sonic = view.getItem(27);
                if (sonic == null || !sonic.getType().equals((Object)Material.BLAZE_ROD) || !sonic.hasItemMeta()) {
                    return;
                }
                ItemStack choice = view.getItem(slot);
                ItemMeta choice_im = choice.getItemMeta();
                ItemMeta sonic_im = sonic.getItemMeta();
                if (sonic_im.hasItemModel()) {
                    sonic_im.setItemModel(null);
                }
                CustomModelDataComponent component = sonic_im.getCustomModelDataComponent();
                component.setFloats(choice_im.getCustomModelDataComponent().getFloats());
                sonic_im.setCustomModelDataComponent(component);
                sonic.setItemMeta(sonic_im);
                break;
            }
            case 27: {
                ItemStack cursor = event.getCursor();
                if (cursor == null || !cursor.getType().equals((Object)Material.BLAZE_ROD) || !cursor.hasItemMeta()) {
                    return;
                }
                ItemMeta meta = cursor.getItemMeta();
                if (!meta.hasDisplayName()) {
                    return;
                }
                NamedTextColor color = TARDISStaticUtils.getColor(meta.displayName());
                Material material = TARDISKeyMenuListener.REVERSE_LOOKUP.getOrDefault(color, Material.WHITE_WOOL);
                ItemStack choice = view.getItem(28);
                ItemMeta cim = choice.getItemMeta();
                ItemStack wool = ItemStack.of((Material)material);
                wool.setItemMeta(cim);
                view.setItem(28, wool);
                break;
            }
            case 28: {
                event.setCancelled(true);
                ItemStack sonic = view.getItem(27);
                if (sonic == null || !sonic.getType().equals((Object)Material.BLAZE_ROD) || !sonic.hasItemMeta()) {
                    return;
                }
                ItemStack choice = view.getItem(28);
                Material wool = this.getNextWool(choice.getType());
                view.setItem(28, ItemStack.of((Material)wool));
                NamedTextColor display = TARDISKeyMenuListener.COLOUR_LOOKUP.get(wool);
                ItemMeta sonic_im = sonic.getItemMeta();
                sonic_im.displayName(Component.text((String)"Sonic Screwdriver", (TextColor)display).decorationIfAbsent(TextDecoration.ITALIC, TextDecoration.State.FALSE));
                sonic.setItemMeta(sonic_im);
                break;
            }
            case 35: {
                event.setCancelled(true);
                this.close(p);
                break;
            }
            default: {
                event.setCancelled(true);
            }
        }
    }

    private Material getNextWool(Material current) {
        Material index = TARDISKeyMenuListener.COLOUR_LOOKUP.higherKey(current);
        return index != null ? index : TARDISKeyMenuListener.COLOUR_LOOKUP.firstKey();
    }

    @EventHandler(ignoreCancelled=true)
    public void onSonicMenuClose(InventoryCloseEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISSonicMenuInventory)) {
            return;
        }
        InventoryView view = event.getView();
        ItemStack sonic = view.getItem(27);
        if (sonic == null) {
            return;
        }
        Player p = (Player)event.getPlayer();
        Location loc = p.getLocation();
        loc.getWorld().dropItemNaturally(loc, sonic);
        view.setItem(27, ItemStack.of((Material)Material.AIR));
    }
}

