/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.playerprefs;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.artron.BeaconToggler;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.commands.preferences.BuildCommand;
import me.eccentric_nz.TARDIS.commands.preferences.IsomorphicCommand;
import me.eccentric_nz.TARDIS.commands.preferences.LabelsCommand;
import me.eccentric_nz.TARDIS.custommodels.GUIPlayerPreferences;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetArtronLevel;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetControls;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetJunk;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.forcefield.ForceField;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.playerprefs.TARDISGeneralPrefsInventory;
import me.eccentric_nz.TARDIS.playerprefs.TARDISPrefsMenuInventory;
import me.eccentric_nz.TARDIS.upgrades.SystemTree;
import me.eccentric_nz.TARDIS.upgrades.SystemUpgradeChecker;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import net.kyori.adventure.text.Component;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.inventory.meta.components.CustomModelDataComponent;

public class TARDISGeneralPrefsListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final HashMap<String, String> lookup = new HashMap();

    public TARDISGeneralPrefsListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
        this.lookup.put("Announce Repeaters", "announce_repeaters_on");
        this.lookup.put("Auto Power Up", "auto_powerup_on");
        this.lookup.put("Auto-rescue", "auto_rescue_on");
        this.lookup.put("Autonomous Siege", "auto_siege_on");
        this.lookup.put("Autonomous", "auto_on");
        this.lookup.put("Beacon", "beacon_on");
        this.lookup.put("Close GUI", "close_gui_on");
        this.lookup.put("Companion Build", "build_on");
        this.lookup.put("Dialogs", "dialogs_on");
        this.lookup.put("Do Not Disturb", "dnd_on");
        this.lookup.put("Emergency Programme One", "eps_on");
        this.lookup.put("Exterior Rendering Room", "renderer_on");
        this.lookup.put("Hostile Action Displacement System", "hads_on");
        this.lookup.put("Interior SFX", "sfx_on");
        this.lookup.put("Info GUI", "info_on");
        this.lookup.put("Minecart Sounds", "minecart_on");
        this.lookup.put("Mob Farming", "farm_on");
        this.lookup.put("Preset Sign", "sign_on");
        this.lookup.put("Open Display Door", "open_display_door_on");
        this.lookup.put("Submarine Mode", "submarine_on");
        this.lookup.put("Telepathic Circuit", "telepathy_on");
        this.lookup.put("Travel Bar", "travelbar_on");
        this.lookup.put("Who Quotes", "quotes_on");
    }

    /*
     * Enabled aggressive block sorting
     */
    @EventHandler(ignoreCancelled=true)
    public void onPrefsMenuClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof TARDISGeneralPrefsInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        if (slot < 0) return;
        if (slot > 35) {
            return;
        }
        ItemStack is = event.getView().getItem(slot);
        if (is == null) {
            return;
        }
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        ItemMeta im = is.getItemMeta();
        if (slot == 33) {
            player.openInventory(new TARDISPrefsMenuInventory(this.plugin, uuid).getInventory());
            return;
        }
        if (slot == 35) {
            this.close(player);
            return;
        }
        if (slot == GUIPlayerPreferences.FORCE_FIELD.getSlot() && ComponentUtils.stripColour(im.displayName()).equals("Force Field")) {
            if (!TARDISPermission.hasPermission(player, "tardis.forcefield")) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NO_PERMS");
                return;
            }
            if (this.plugin.getConfig().getBoolean("difficulty.system_upgrades") && !new SystemUpgradeChecker(this.plugin).has(player.getUniqueId().toString(), SystemTree.FORCE_FIELD)) {
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "SYS_NEED", "Force Field");
                return;
            }
            List lore = im.lore();
            boolean bool = ComponentUtils.stripColour((Component)lore.getFirst()).equals(this.plugin.getLanguage().getString("SET_OFF", "OFF"));
            if (bool) {
                ResultSetArtronLevel rsal = new ResultSetArtronLevel(this.plugin, uuid.toString());
                if (!rsal.resultset()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_LEVEL");
                    return;
                }
                if (rsal.getArtronLevel() <= this.plugin.getArtronConfig().getInt("standby")) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "POWER_LOW");
                    return;
                }
                if (ForceField.addToTracker(player)) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PREF_WAS_ON", "The TARDIS force field");
                }
            } else {
                this.plugin.getTrackerKeeper().getActiveForceFields().remove(player.getUniqueId());
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "PREF_WAS_OFF", "The TARDIS force field");
            }
            this.close(player);
            return;
        }
        List lore = im.lore();
        boolean bool = ComponentUtils.stripColour((Component)lore.getFirst()).equals(this.plugin.getLanguage().getString("SET_ON", "ON"));
        String value = bool ? this.plugin.getLanguage().getString("SET_OFF", "OFF") : this.plugin.getLanguage().getString("SET_ON", "ON");
        int b = bool ? 0 : 1;
        String which = ComponentUtils.stripColour(im.displayName());
        Tardis tardis = null;
        HashMap<String, Object> wherep = new HashMap<String, Object>();
        wherep.put("uuid", uuid.toString());
        ResultSetTardis rsp = new ResultSetTardis(this.plugin, wherep, "", false);
        if (rsp.resultSet()) {
            tardis = rsp.getTardis();
        }
        switch (which) {
            case "Console Labels": {
                String[] args = new String[]{"console_labels", bool ? "off" : "on"};
                new LabelsCommand(this.plugin).toggle(player, args);
                return;
            }
            case "Isometric": {
                if (tardis == null || (!tardis.isIsomorphicOn() || bool) && (tardis.isIsomorphicOn() || !bool)) break;
                new IsomorphicCommand(this.plugin).toggleIsomorphicControls(player);
                break;
            }
            case "Junk TARDIS": {
                String cham_set;
                HashMap<String, Object> wheret = new HashMap<String, Object>();
                wheret.put("uuid", uuid);
                ResultSetTravellers rst = new ResultSetTravellers(this.plugin, wheret, false);
                if (rst.resultSet()) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "JUNK_PRESET_OUTSIDE");
                    return;
                }
                if (this.plugin.getTrackerKeeper().getRebuildCooldown().containsKey(uuid)) {
                    long now = System.currentTimeMillis();
                    long cooldown = this.plugin.getConfig().getLong("police_box.rebuild_cooldown");
                    long then = this.plugin.getTrackerKeeper().getRebuildCooldown().get(uuid) + cooldown;
                    if (now < then) {
                        this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "COOLDOWN", String.format("%d", cooldown / 1000L));
                        return;
                    }
                }
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", uuid.toString());
                ResultSetJunk rsj = new ResultSetJunk(this.plugin, where);
                boolean has = rsj.resultSet();
                if (tardis == null) break;
                String current = tardis.getPreset().toString();
                if (current.equals("JUNK_MODE") && !bool) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "JUNK_ALREADY_ON");
                    return;
                }
                if (!current.equals("JUNK_MODE") && bool) {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "JUNK_ALREADY_OFF");
                    return;
                }
                int id = tardis.getTardisId();
                HashMap<String, Object> setj = new HashMap<String, Object>();
                if (has) {
                    HashMap<String, Object> wherej = new HashMap<String, Object>();
                    wherej.put("uuid", uuid.toString());
                    setj.put("preset", current);
                    this.plugin.getQueryFactory().doSyncUpdate("junk", setj, wherej);
                } else {
                    setj.put("uuid", uuid.toString());
                    setj.put("tardis_id", id);
                    setj.put("preset", current);
                    this.plugin.getQueryFactory().doSyncInsert("junk", setj);
                }
                HashMap<String, Object> whereu = new HashMap<String, Object>();
                whereu.put("uuid", uuid.toString());
                HashMap<String, Object> sett = new HashMap<String, Object>();
                String message = "JUNK_PRESET_ON";
                if (bool) {
                    String preset = has ? rsj.getPreset().toString() : current;
                    sett.put("chameleon_preset", preset);
                    sett.put("chameleon_demat", "JUNK_MODE");
                    message = "JUNK_PRESET_OFF";
                    cham_set = preset;
                    this.plugin.getTrackerKeeper().getJunkPlayers().remove(uuid);
                } else {
                    sett.put("chameleon_preset", "JUNK_MODE");
                    sett.put("chameleon_demat", current);
                    sett.put("adapti_on", 0);
                    cham_set = "JUNK_MODE";
                    this.plugin.getTrackerKeeper().getJunkPlayers().put(uuid, id);
                }
                this.plugin.getQueryFactory().doSyncUpdate("tardis", sett, whereu);
                HashMap<String, Object> wherec = new HashMap<String, Object>();
                wherec.put("tardis_id", id);
                wherec.put("type", 31);
                ResultSetControls rsc = new ResultSetControls(this.plugin, wherec, true);
                if (rsc.resultSet()) {
                    for (HashMap<String, String> map : rsc.getData()) {
                        TARDISStaticUtils.setSign(map.get("location"), 3, cham_set, player);
                    }
                }
                this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, message);
                player.performCommand("tardis rebuild");
                break;
            }
            case "Companion Build": {
                String[] args = new String[]{"", value};
                new BuildCommand(this.plugin).toggleCompanionBuilding(player, args);
                break;
            }
            case "Lock Containers": {
                if (bool) {
                    this.plugin.getWorldGuardUtils().unlockContainers(player.getWorld(), player.getName());
                    break;
                }
                this.plugin.getWorldGuardUtils().lockContainers(player.getWorld(), player.getName());
                break;
            }
            default: {
                HashMap<String, Object> set = new HashMap<String, Object>();
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("uuid", uuid.toString());
                if (ComponentUtils.stripColour(im.displayName()).equals("HADS Type")) {
                    value = ComponentUtils.stripColour((Component)lore.getFirst()).equals("DISPLACEMENT") ? "DISPERSAL" : "DISPLACEMENT";
                    set.put("hads_type", value);
                } else {
                    set.put(this.lookup.get(ComponentUtils.stripColour(im.displayName())), b);
                }
                this.plugin.getQueryFactory().doUpdate("player_prefs", set, where);
            }
        }
        lore.set(0, Component.text((String)value));
        im.lore(lore);
        GUIPlayerPreferences gui = GUIPlayerPreferences.fromString(which);
        CustomModelDataComponent component = im.getCustomModelDataComponent();
        component.setFloats(value.equals(this.plugin.getLanguage().getString("SET_ON", "ON")) ? gui.getOnFloats() : gui.getOffFloats());
        im.setCustomModelDataComponent(component);
        is.setItemMeta(im);
        if (!ComponentUtils.stripColour(im.displayName()).equals("Beacon")) return;
        ResultSetTardisID rsi = new ResultSetTardisID(this.plugin);
        if (!rsi.fromUUID(uuid.toString())) return;
        new BeaconToggler(this.plugin).flickSwitch(uuid, rsi.getTardisId(), !bool);
    }
}

