/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.mapping;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.api.TARDISData;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.files.FileCopier;
import me.eccentric_nz.TARDIS.mapping.TARDISGetter;
import me.eccentric_nz.TARDIS.mapping.TARDISMapper;
import me.eccentric_nz.TARDIS.mapping.TARDISServerListener;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.dynmap.DynmapAPI;
import org.dynmap.markers.GenericMarker;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.MarkerSet;

public class TARDISDynmap
implements TARDISMapper {
    private final TARDIS plugin;
    private MarkerSet markerSet;
    private Map<String, Marker> markers = new HashMap<String, Marker>();
    private Plugin dynmap;
    private DynmapAPI api;
    private MarkerAPI markerapi;
    private boolean reload = false;
    private boolean stop;
    private TARDISLayer tardisLayer;

    public TARDISDynmap(TARDIS plugin) {
        this.plugin = plugin;
    }

    @Override
    public void disable() {
        if (this.tardisLayer != null) {
            this.tardisLayer.cleanup();
            this.tardisLayer = null;
        }
        this.stop = true;
    }

    @Override
    public void enable() {
        this.dynmap = this.plugin.getPM().getPlugin("dynmap");
        this.api = (DynmapAPI)this.dynmap;
        this.plugin.getPM().registerEvents((Listener)new TARDISServerListener("dynmap", this), (Plugin)this.plugin);
        if (this.dynmap != null && this.dynmap.isEnabled()) {
            this.activate();
            this.checkIcon();
        }
    }

    @Override
    public void activate() {
        if (this.dynmap.isEnabled()) {
            this.markerapi = this.api.getMarkerAPI();
            if (this.markerapi == null) {
                this.plugin.debug("Error loading Dynmap marker API!");
                return;
            }
            if (this.reload) {
                if (this.tardisLayer != null) {
                    if (this.markerSet != null) {
                        this.markerSet.deleteMarkerSet();
                        this.markerSet = null;
                    }
                    this.tardisLayer = null;
                }
            } else {
                this.reload = true;
            }
            this.tardisLayer = new TARDISLayer();
            this.tardisLayer.updateMarkerSet();
            this.stop = false;
            this.updateMarkerSet(this.plugin.getConfig().getLong("mapping.update_period") * 20L / 3L);
        }
    }

    @Override
    public void updateMarkerSet(long period) {
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, (Runnable)new DynmapMarkerUpdate(), period);
    }

    private void checkIcon() {
        String path = "plugins/dynmap/web/tiles/_markers_/tardis.png";
        File icon = new File(path);
        if (!icon.exists()) {
            FileCopier.copy(path, this.plugin.getResource("tardis.png"), true);
            this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "dmarker addicon id:tardis newlabel:tardis file:plugins/dynmap/web/tiles/_markers_/tardis.png");
        }
    }

    private class TARDISLayer {
        MarkerIcon markerIcon;
        String labelFormat;

        TARDISLayer() {
            TARDISDynmap.this.markerSet = TARDISDynmap.this.markerapi.getMarkerSet("tardis");
            if (TARDISDynmap.this.markerSet == null) {
                TARDISDynmap.this.markerSet = TARDISDynmap.this.markerapi.createMarkerSet("tardis", "TARDISes", null, false);
            } else {
                TARDISDynmap.this.markerSet.setMarkerSetLabel("TARDISes");
            }
            if (TARDISDynmap.this.markerSet == null) {
                TARDISDynmap.this.plugin.getMessenger().message((CommandSender)TARDISDynmap.this.plugin.getConsole(), TardisModule.WARNING, "Error creating tardis marker set");
                return;
            }
            TARDISDynmap.this.markerSet.setLayerPriority(0);
            TARDISDynmap.this.markerSet.setHideByDefault(false);
            this.markerIcon = TARDISDynmap.this.markerapi.getMarkerIcon("tardis");
            this.labelFormat = "%name% (TARDIS)";
        }

        void cleanup() {
            if (TARDISDynmap.this.markerSet != null) {
                TARDISDynmap.this.markerSet.deleteMarkerSet();
                TARDISDynmap.this.markerSet = null;
            }
            TARDISDynmap.this.markers.clear();
        }

        public void updateMarkerSet() {
            HashMap<String, Marker> newMarkerMap = new HashMap<String, Marker>();
            TARDISGetter getter = new TARDISGetter(TARDISDynmap.this.plugin, null);
            getter.resultSetAsync(results -> results.forEach(value -> {
                Location loc = value.location();
                World w = loc.getWorld();
                if (w != null) {
                    String world = w.getName();
                    String id = world + "/" + value.owner();
                    String label = this.labelFormat.replace("%name%", value.owner());
                    Marker marker = TARDISDynmap.this.markers.remove(id);
                    if (marker == null) {
                        marker = TARDISDynmap.this.markerSet.createMarker(id, label, world, loc.getX(), loc.getY(), loc.getZ(), this.markerIcon, false);
                    } else {
                        marker.setLocation(world, loc.getX(), loc.getY(), loc.getZ());
                        marker.setLabel(label);
                        marker.setMarkerIcon(this.markerIcon);
                    }
                    String desc = TARDISDynmap.this.formatInfoWindow((TARDISData)value);
                    marker.setDescription(desc);
                    newMarkerMap.put(id, marker);
                }
            }));
            TARDISDynmap.this.markers.values().forEach(GenericMarker::deleteMarker);
            TARDISDynmap.this.markers.clear();
            TARDISDynmap.this.markers = newMarkerMap;
        }
    }

    private class DynmapMarkerUpdate
    implements Runnable {
        final Map<String, Marker> newmap = new HashMap<String, Marker>();
        ArrayList<World> worldsToDo = null;
        List<TARDISData> toDo = null;
        int tardisIndex = 0;
        World curWorld = null;

        private DynmapMarkerUpdate() {
        }

        @Override
        public void run() {
            if (TARDISDynmap.this.stop || TARDISDynmap.this.markerSet == null) {
                return;
            }
            if (this.worldsToDo == null) {
                this.worldsToDo = new ArrayList();
                for (String planet : TARDISDynmap.this.plugin.getPlanetsConfig().getConfigurationSection("planets").getKeys(false)) {
                    World world;
                    if (!TARDISDynmap.this.plugin.getPlanetsConfig().getBoolean("planets." + planet + ".time_travel") || (world = TARDISDynmap.this.plugin.getServer().getWorld(planet)) == null) continue;
                    this.worldsToDo.add(world);
                }
            }
            while (this.toDo == null) {
                if (this.worldsToDo.isEmpty()) {
                    for (Marker oldm : TARDISDynmap.this.markers.values()) {
                        oldm.deleteMarker();
                    }
                    TARDISDynmap.this.markers = this.newmap;
                    long delay = TARDISDynmap.this.plugin.getConfig().getLong("mapping.update_period", 30L) * 20L;
                    TARDISDynmap.this.updateMarkerSet(delay);
                    break;
                }
                this.curWorld = this.worldsToDo.removeFirst();
                TARDISGetter getter = new TARDISGetter(TARDISDynmap.this.plugin, this.curWorld);
                getter.resultSetAsync(results -> {
                    this.toDo = results;
                    this.tardisIndex = 0;
                    if (this.toDo != null && this.toDo.isEmpty()) {
                        this.toDo = null;
                    } else {
                        int limit = TARDISDynmap.this.plugin.getConfig().getInt("mapping.updates_per_tick", 10);
                        for (int cnt = 0; cnt < limit; ++cnt) {
                            if (this.tardisIndex >= this.toDo.size()) {
                                this.toDo = null;
                                break;
                            }
                            TARDISData data = this.toDo.get(this.tardisIndex);
                            ++this.tardisIndex;
                            Location loc = data.location();
                            String world = loc.getWorld().getName();
                            String id = world + "/" + data.owner();
                            String label = String.format("%s (TARDIS)", data.owner());
                            MarkerIcon markerIcon = TARDISDynmap.this.markerapi.getMarkerIcon("tardis");
                            Marker marker = TARDISDynmap.this.markers.remove(id);
                            if (marker == null) {
                                marker = TARDISDynmap.this.markerSet.createMarker(id, label, world, loc.getX(), loc.getY(), loc.getZ(), markerIcon, false);
                            } else {
                                marker.setLocation(world, loc.getX(), loc.getY(), loc.getZ());
                                marker.setLabel(label);
                                marker.setMarkerIcon(markerIcon);
                            }
                            if (marker == null) continue;
                            String desc = TARDISDynmap.this.formatInfoWindow(data);
                            marker.setDescription(desc);
                            this.newmap.put(id, marker);
                        }
                    }
                });
            }
        }
    }
}

