/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import io.papermc.paper.event.player.AsyncChatEvent;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerCommandPreprocessEvent;
import org.bukkit.plugin.Plugin;

public class TARDISZeroRoomChatListener
implements Listener {
    private final TARDIS plugin;

    public TARDISZeroRoomChatListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.HIGH, ignoreCancelled=true)
    public void onChat(AsyncChatEvent event) {
        Player zero = event.getPlayer();
        if (this.plugin.getTrackerKeeper().getZeroRoomOccupants().contains(zero.getUniqueId())) {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)zero, TardisModule.TARDIS, "NOT_IN_ZERO");
        } else if (this.plugin.getServer().getWorld("TARDIS_Zero_Room") != null) {
            List inZeroRoom = this.plugin.getServer().getWorld("TARDIS_Zero_Room").getPlayers();
            inZeroRoom.forEach(p -> event.viewers().remove(p));
        }
    }

    @EventHandler(ignoreCancelled=true)
    public void onPlayerCommandPreprocessEvent(PlayerCommandPreprocessEvent event) {
        Player player = event.getPlayer();
        if (this.plugin.getTrackerKeeper().getZeroRoomOccupants().contains(player.getUniqueId())) {
            event.setCancelled(true);
            this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "NOT_IN_ZERO");
            return;
        }
        UUID uuid = player.getUniqueId();
        String resend = event.getMessage();
        String command = resend.toLowerCase(Locale.ROOT);
        if (this.plugin.getTrackerKeeper().getTelepaths().containsKey(uuid)) {
            if (command.contains("tardis ") || command.contains("tardistravel ") || command.contains("ttravel ")) {
                UUID owner = this.plugin.getTrackerKeeper().getTelepaths().get(uuid);
                Player timelord = this.plugin.getServer().getPlayer(owner);
                if (timelord != null && timelord.isOnline()) {
                    this.plugin.getMessenger().message((CommandSender)this.plugin.getConsole(), TardisModule.TARDIS, " Companion [" + player.getName() + "] ran a telepathic command as Time Lord [" + timelord.getName() + "]");
                    if (command.contains("rescue") && command.contains(timelord.getName().toLowerCase(Locale.ROOT))) {
                        this.plugin.getTrackerKeeper().getTelepathicRescue().put(owner, uuid);
                    }
                    timelord.performCommand(command);
                    event.setCancelled(true);
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> this.plugin.getServer().dispatchCommand((CommandSender)timelord, resend.substring(1)), 2L);
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TELEPATHIC_RUN", resend);
                } else {
                    this.plugin.getMessenger().send((CommandSender)player, TardisModule.TARDIS, "TELEPATHIC_ONLINE");
                }
            }
            this.plugin.getTrackerKeeper().getTelepaths().remove(uuid);
        }
    }
}

