/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.listeners;

import java.util.HashMap;
import java.util.Optional;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.arch.ArchPersister;
import me.eccentric_nz.TARDIS.artron.AdaptiveBoxLampToggler;
import me.eccentric_nz.TARDIS.artron.BeaconToggler;
import me.eccentric_nz.TARDIS.artron.PresetLampToggler;
import me.eccentric_nz.TARDIS.camera.CameraTracker;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetCurrentFromId;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardis;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import org.bukkit.Chunk;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.plugin.Plugin;

public class TARDISQuitListener
implements Listener {
    private final TARDIS plugin;

    public TARDISQuitListener(TARDIS plugin) {
        this.plugin = plugin;
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onPlayerQuit(PlayerQuitEvent event) {
        Player player = event.getPlayer();
        UUID uuid = player.getUniqueId();
        if (CameraTracker.SPECTATING.containsKey(uuid)) {
            this.plugin.getTrackerKeeper().getJunkRelog().put(uuid, CameraTracker.SPECTATING.get(uuid).location());
            CameraTracker.SPECTATING.remove(uuid);
        }
        if (this.plugin.getGeneralKeeper().getJunkTravellers().contains(uuid)) {
            if (this.plugin.getUtils().inTARDISWorld(player)) {
                this.plugin.getTrackerKeeper().getJunkRelog().put(uuid, this.plugin.getGeneralKeeper().getJunkDestination());
            }
            this.plugin.getGeneralKeeper().getJunkTravellers().remove(uuid);
        }
        Optional.ofNullable(this.plugin.getTrackerKeeper().getFlyingReturnLocation().get(uuid)).ifPresent(value -> this.plugin.getServer().getScheduler().cancelTask(value.sound()));
        HashMap<String, Object> wherep = new HashMap<String, Object>();
        wherep.put("uuid", uuid.toString());
        ResultSetTardis rs = new ResultSetTardis(this.plugin, wherep, "", false);
        if (rs.resultSet()) {
            World w;
            ResultSetCurrentFromId rsc;
            Tardis tardis = rs.getTardis();
            if (this.plugin.getConfig().getBoolean("police_box.keep_chunk_force_loaded") && (rsc = new ResultSetCurrentFromId(this.plugin, tardis.getTardisId())).resultSet() && (w = rsc.getCurrent().location().getWorld()) != null) {
                Chunk chunk = w.getChunkAt(rsc.getCurrent().location());
                chunk.removePluginChunkTicket((Plugin)this.plugin);
            }
            if (this.plugin.getConfig().getBoolean("allow.power_down") && this.plugin.getConfig().getBoolean("allow.power_down_on_quit") && tardis.isPoweredOn()) {
                int id = tardis.getTardisId();
                if (!tardis.isTardisInit() || this.isTravelling(id) || !tardis.isHandbrakeOn()) {
                    return;
                }
                ChameleonPreset preset = tardis.getPreset();
                boolean hidden = tardis.isHidden();
                boolean lights = tardis.isLightsOn();
                long delay = 1L;
                if (hidden) {
                    this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "tardisremote " + player.getName() + " rebuild");
                    delay = 20L;
                }
                if (preset.equals((Object)ChameleonPreset.ADAPTIVE) || preset.usesArmourStand()) {
                    this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> new AdaptiveBoxLampToggler(this.plugin).toggleLamp(id, false, preset), delay);
                }
                if (lights) {
                    new PresetLampToggler(this.plugin).flickSwitch(id, uuid, true, tardis.getSchematic().getLights());
                }
                new BeaconToggler(this.plugin).flickSwitch(uuid, id, false);
                this.plugin.getTrackerKeeper().getActiveForceFields().remove(uuid);
                HashMap<String, Object> wheret = new HashMap<String, Object>();
                wheret.put("tardis_id", id);
                HashMap<String, Object> sett = new HashMap<String, Object>();
                sett.put("powered_on", 0);
                this.plugin.getQueryFactory().doUpdate("tardis", sett, wheret);
            }
            if (this.plugin.isDisguisesOnServer()) {
                if (this.plugin.getConfig().getBoolean("arch.enabled") && this.plugin.getTrackerKeeper().getJohnSmith().containsKey(uuid)) {
                    new ArchPersister(this.plugin).save(uuid);
                }
                this.plugin.getTrackerKeeper().getGeneticallyModified().remove(uuid);
            }
        }
    }

    private boolean isTravelling(int id) {
        return this.plugin.getTrackerKeeper().getDematerialising().contains(id) || this.plugin.getTrackerKeeper().getMaterialising().contains(id) || this.plugin.getTrackerKeeper().getInVortex().contains(id);
    }
}

