/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.howto;

import java.util.List;
import me.eccentric_nz.TARDIS.TARDIS;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.format.NamedTextColor;
import net.kyori.adventure.text.format.TextColor;
import org.bukkit.Difficulty;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

class SeedRecipeInventory
implements InventoryHolder {
    private final TARDIS plugin;
    private final Material block;
    private final Inventory inventory;

    SeedRecipeInventory(TARDIS plugin, Material block) {
        this.plugin = plugin;
        this.block = block;
        this.inventory = plugin.getServer().createInventory((InventoryHolder)this, 54, (Component)Component.text((String)"TARDIS Seed Recipe", (TextColor)NamedTextColor.DARK_RED));
        this.inventory.setContents(this.getItemStack());
    }

    public Inventory getInventory() {
        return this.inventory;
    }

    private ItemStack[] getItemStack() {
        ItemStack[] stack = new ItemStack[27];
        Material torch = Material.REDSTONE_TORCH;
        if (!this.plugin.getConfig().getBoolean("creation.seed_block.legacy")) {
            World world = (World)this.plugin.getServer().getWorlds().getFirst();
            String difficulty = switch (world.getDifficulty()) {
                case Difficulty.HARD -> "hard";
                case Difficulty.NORMAL -> "normal";
                default -> "easy";
            };
            try {
                torch = Material.valueOf((String)this.plugin.getConfig().getString("creation.seed_block." + difficulty));
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        ItemStack red = ItemStack.of((Material)torch, (int)1);
        ItemStack lapis = ItemStack.of((Material)Material.LAPIS_BLOCK, (int)1);
        ItemStack in_wall = ItemStack.of((Material)Material.ORANGE_WOOL, (int)1);
        ItemMeta in_meta = in_wall.getItemMeta();
        in_meta.displayName((Component)Component.text((String)"Interior walls"));
        in_meta.lore(List.of(Component.text((String)"Any valid Wall/Floor block"), Component.text((String)"Click to see blocks...")));
        in_wall.setItemMeta(in_meta);
        ItemStack in_floor = ItemStack.of((Material)Material.LIGHT_GRAY_WOOL, (int)1);
        ItemMeta fl_meta = in_floor.getItemMeta();
        fl_meta.displayName((Component)Component.text((String)"Interior floors"));
        fl_meta.lore(List.of(Component.text((String)"Any valid Wall/Floor block"), Component.text((String)"Click to see blocks...")));
        in_floor.setItemMeta(fl_meta);
        ItemStack tardis = ItemStack.of((Material)this.block, (int)1);
        stack[0] = red;
        stack[9] = lapis;
        stack[11] = in_wall;
        stack[18] = tardis;
        stack[20] = in_floor;
        ItemStack close = ItemStack.of((Material)Material.BOWL, (int)1);
        ItemMeta close_im = close.getItemMeta();
        close_im.displayName((Component)Component.text((String)this.plugin.getLanguage().getString("BUTTON_CLOSE", "Close")));
        close.setItemMeta(close_im);
        stack[26] = close;
        ItemStack back = ItemStack.of((Material)Material.BOWL, (int)1);
        ItemMeta back_im = back.getItemMeta();
        back_im.displayName((Component)Component.text((String)"Back"));
        back.setItemMeta(back_im);
        stack[8] = back;
        return stack;
    }
}

