/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.forcefield;

import org.bukkit.Location;
import org.bukkit.World;

public class ForceFieldLocation {
    private final Location topFrontLeft;
    private final Location topFrontRight;
    private final Location topBacktLeft;
    private final Location topBackRight;
    private final Location bottomFrontLeft;
    private final Location bottomFrontRight;
    private final Location bottomBackLeft;
    private final Location bottomBackRight;

    public ForceFieldLocation(Location location, double range) {
        double minX = location.getX() - range;
        double minY = location.getY();
        double minZ = location.getZ() - range;
        double maxX = location.getX() + range;
        double maxY = location.getY() + 1.0;
        double maxZ = location.getZ() + range;
        World world = location.getWorld();
        this.topFrontLeft = new Location(world, minX, maxY, minZ);
        this.topFrontRight = new Location(world, maxX, maxY, minZ);
        this.topBacktLeft = new Location(world, minX, maxY, maxZ);
        this.topBackRight = new Location(world, maxX, maxY, maxZ);
        this.bottomFrontLeft = new Location(world, minX, minY, minZ);
        this.bottomFrontRight = new Location(world, maxX, minY, minZ);
        this.bottomBackLeft = new Location(world, minX, minY, maxZ);
        this.bottomBackRight = new Location(world, maxX, minY, maxZ);
    }

    public Location getTopFrontLeft() {
        return this.topFrontLeft;
    }

    public Location getTopFrontRight() {
        return this.topFrontRight;
    }

    public Location getTopBackLeft() {
        return this.topBacktLeft;
    }

    public Location getTopBackRight() {
        return this.topBackRight;
    }

    public Location getBottomFrontLeft() {
        return this.bottomFrontLeft;
    }

    public Location getBottomFrontRight() {
        return this.bottomFrontRight;
    }

    public Location getBottomBackLeft() {
        return this.bottomBackLeft;
    }

    public Location getBottomBackRight() {
        return this.bottomBackRight;
    }
}

