/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.destroyers;

import java.util.Collections;
import java.util.HashMap;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.builders.exterior.MaterialisationData;
import me.eccentric_nz.TARDIS.customblocks.TARDISBlockDisplayItem;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetBlocks;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisPreset;
import me.eccentric_nz.TARDIS.doors.inner.Inner;
import me.eccentric_nz.TARDIS.doors.inner.InnerDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.inner.InnerDoor;
import me.eccentric_nz.TARDIS.doors.inner.InnerMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDisplayDoorCloser;
import me.eccentric_nz.TARDIS.doors.outer.OuterDoor;
import me.eccentric_nz.TARDIS.doors.outer.OuterMinecraftDoorCloser;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISSponge;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.entity.ArmorStand;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Interaction;
import org.bukkit.entity.ItemFrame;
import org.bukkit.plugin.Plugin;

public class InstantPresetDestroyer {
    private final TARDIS plugin;

    public InstantPresetDestroyer(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void instaDestroyPreset(MaterialisationData dd, boolean hide, ChameleonPreset preset) {
        Interaction interaction;
        Location l = dd.getLocation();
        COMPASS d = dd.getDirection().forPreset();
        int id = dd.getTardisID();
        boolean sub = dd.isSubmarine();
        this.plugin.getTrackerKeeper().getPortals().remove(l);
        ResultSetTardisPreset rs = new ResultSetTardisPreset(this.plugin);
        if (rs.fromID(id)) {
            UUID playerUUID = dd.getPlayer().getUniqueId();
            Inner innerDisplayDoor = new InnerDoor(this.plugin, id).get();
            if (innerDisplayDoor.display()) {
                new InnerDisplayDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, playerUUID, true);
            } else {
                new InnerMinecraftDoorCloser(this.plugin).close(innerDisplayDoor.block(), id, playerUUID);
            }
            boolean outerDisplayDoor = rs.getPreset().usesArmourStand();
            if (outerDisplayDoor) {
                new OuterDisplayDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getDisplay(), id, playerUUID);
            } else if (rs.getPreset().hasDoor()) {
                new OuterMinecraftDoorCloser(this.plugin).close(new OuterDoor(this.plugin, id).getMinecraft(), id, playerUUID);
            }
        }
        if ((interaction = TARDISDisplayItemUtils.getInteraction(dd.getLocation())) != null) {
            interaction.remove();
        }
        World w = l.getWorld();
        Chunk chunk = w.getChunkAt(l);
        while (!chunk.isLoaded()) {
            chunk.load();
        }
        if (preset.usesArmourStand()) {
            for (Entity e : w.getNearbyEntities(dd.getLocation(), 1.0, 1.0, 1.0)) {
                if (e instanceof ItemFrame) {
                    ItemFrame frame = (ItemFrame)e;
                    frame.setItem(null, false);
                    frame.remove();
                }
                if (!(e instanceof ArmorStand)) continue;
                ArmorStand stand = (ArmorStand)e;
                stand.remove();
            }
            if (!hide) {
                this.plugin.getPresetDestroyer().removeBlockProtection(id);
            }
        } else {
            int sbx = l.getBlockX() - 1;
            int sby = preset.equals((Object)ChameleonPreset.SUBMERGED) ? l.getBlockY() - 1 : l.getBlockY();
            int sbz = l.getBlockZ() - 1;
            switch (preset) {
                case GRAVESTONE: {
                    int flowerx;
                    int flowery = l.getBlockY() + 1;
                    TARDISBlockSetters.setBlock(w, flowerx, flowery, switch (d) {
                        case COMPASS.NORTH -> {
                            flowerx = l.getBlockX();
                            yield l.getBlockZ() + 1;
                        }
                        case COMPASS.WEST -> {
                            flowerx = l.getBlockX() + 1;
                            yield l.getBlockZ();
                        }
                        case COMPASS.SOUTH -> {
                            flowerx = l.getBlockX();
                            yield l.getBlockZ() - 1;
                        }
                        default -> {
                            flowerx = l.getBlockX() - 1;
                            yield l.getBlockZ();
                        }
                    }, Material.AIR);
                    break;
                }
                case DUCK: {
                    this.plugin.getPresetDestroyer().destroyDuckEyes(l, d);
                    break;
                }
                case MINESHAFT: {
                    this.plugin.getPresetDestroyer().destroyMineshaftTorches(l, d);
                    break;
                }
                case LAMP: {
                    this.plugin.getPresetDestroyer().destroyLampTrapdoors(l, d);
                    break;
                }
                case JUNK_MODE: {
                    this.plugin.getPresetDestroyer().destroyHandbrake(l, d);
                    break;
                }
                case SWAMP: {
                    int swampYTop = dd.getLocation().getBlockY() + 2;
                    int swampYBottom = dd.getLocation().getBlockY() + 1;
                    int swampYUnder = dd.getLocation().getBlockY();
                    TARDISBlockSetters.setBlock(w, dd.getLocation().getBlockX(), swampYTop, dd.getLocation().getBlockZ(), Material.AIR);
                    TARDISBlockSetters.setBlock(w, dd.getLocation().getBlockX(), swampYBottom, dd.getLocation().getBlockZ(), Material.AIR);
                    TARDISBlockSetters.setBlock(w, dd.getLocation().getBlockX(), swampYUnder, dd.getLocation().getBlockZ(), Material.AIR);
                    break;
                }
                case PUNKED: {
                    this.plugin.getPresetDestroyer().destroyPistons(l);
                    break;
                }
            }
            this.plugin.getPresetDestroyer().destroyDoor(id);
            this.plugin.getPresetDestroyer().destroyLamp(l, preset);
            this.plugin.getPresetDestroyer().destroySign(l, d, preset);
            for (int yy = 3; yy >= 0; --yy) {
                for (int xx = 0; xx < 3; ++xx) {
                    for (int zz = 0; zz < 3; ++zz) {
                        Block b = w.getBlockAt(sbx + xx, sby + yy, sbz + zz);
                        if (b.getType().isAir()) continue;
                        b.setBlockData(TARDISConstants.AIR);
                        if (preset != ChameleonPreset.JUNK_MODE) continue;
                        TARDISDisplayItemUtils.remove(b);
                    }
                }
            }
            l.getChunk().removePluginChunkTicket((Plugin)this.plugin);
            if (sub && this.plugin.isWorldGuardOnServer()) {
                HashMap<String, Object> where = new HashMap<String, Object>();
                where.put("tardis_id", id);
                where.put("data", "minecraft:sponge");
                ResultSetBlocks rsb = new ResultSetBlocks(this.plugin, where, false);
                rsb.resultSetAsync((hasResult, resultSetBlocks) -> {
                    if (hasResult && rsb.getReplacedBlock().getLocation() != null) {
                        Block b = rsb.getReplacedBlock().getLocation().getBlock();
                        TARDISSponge.addWater(b);
                    }
                });
            }
        }
        HashMap<String, Object> tid = new HashMap<String, Object>();
        tid.put("tardis_id", id);
        tid.put("police_box", 1);
        ResultSetBlocks rsb = new ResultSetBlocks(this.plugin, tid, true);
        if (rsb.resultSet()) {
            rsb.getData().forEach(rb -> TARDISBlockSetters.setBlock(rb.getLocation(), rb.getBlockData()));
        }
        if (!hide) {
            this.plugin.getPresetDestroyer().removeBlockProtection(id);
        }
        if (dd.isSiege()) {
            Block siege = dd.getLocation().getBlock();
            siege.setBlockData(TARDISConstants.BARRIER);
            TARDISDisplayItemUtils.remove(siege);
            TARDISDisplayItemUtils.set(TARDISBlockDisplayItem.SIEGE_CUBE, siege, id);
        }
        this.plugin.getTrackerKeeper().getDematerialising().removeAll(Collections.singleton(id));
        this.plugin.getTrackerKeeper().getInVortex().removeAll(Collections.singleton(id));
    }
}

