/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.database.resultset;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.database.TARDISDatabaseConnection;
import me.eccentric_nz.TARDIS.database.data.Tardis;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Desktops;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;

public class ResultSetTardis {
    private final TARDISDatabaseConnection service = TARDISDatabaseConnection.getINSTANCE();
    private final Connection connection = this.service.getConnection();
    private final TARDIS plugin;
    private final HashMap<String, Object> where;
    private final String limit;
    private final boolean multiple;
    private final List<Tardis> data = new ArrayList<Tardis>();
    private final String prefix;
    private Tardis tardis;

    public ResultSetTardis(TARDIS plugin, HashMap<String, Object> where, String limit, boolean multiple) {
        this.plugin = plugin;
        this.where = where;
        this.limit = limit;
        this.multiple = multiple;
        this.prefix = this.plugin.getPrefix();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean resultSet() {
        block39: {
            Statement statement = null;
            ResultSet rs = null;
            Object wheres = "";
            Object thelimit = "";
            if (this.where != null) {
                StringBuilder sbw = new StringBuilder();
                this.where.forEach((key, value) -> sbw.append((String)key).append(" = ? AND "));
                wheres = " WHERE " + sbw.substring(0, sbw.length() - 5);
            }
            if (!this.limit.isEmpty()) {
                thelimit = " LIMIT " + this.limit;
            }
            String query = "SELECT * FROM " + this.prefix + "tardis" + (String)wheres + (String)thelimit;
            try {
                this.service.testConnection(this.connection);
                statement = this.connection.prepareStatement(query);
                if (this.where != null) {
                    int s = 1;
                    for (Map.Entry<String, Object> entry : this.where.entrySet()) {
                        if (entry.getValue() instanceof String || entry.getValue() instanceof UUID) {
                            statement.setString(s, entry.getValue().toString());
                        } else {
                            statement.setInt(s, (Integer)entry.getValue());
                        }
                        ++s;
                    }
                    this.where.clear();
                }
                if ((rs = statement.executeQuery()).isBeforeFirst()) {
                    while (rs.next()) {
                        ChameleonPreset demat;
                        String[] split;
                        ChameleonPreset preset;
                        String uid = rs.getString("uuid");
                        if (rs.wasNull() || uid.isEmpty()) {
                            uid = UUID.randomUUID().toString();
                        }
                        String companions = rs.getString("companions");
                        if (rs.wasNull()) {
                            companions = "";
                        }
                        String zero = rs.getString("zero");
                        if (rs.wasNull()) {
                            zero = "";
                        }
                        UUID frame = null;
                        String rotor = rs.getString("rotor");
                        if (!rs.wasNull() && !rotor.isEmpty()) {
                            frame = rotor.contains("Location") ? TARDISConstants.UUID_ZERO : UUID.fromString(rotor);
                        }
                        String itemPreset = "";
                        String itemDemat = "";
                        UUID uuid = UUID.fromString(uid);
                        try {
                            String p = rs.getString("chameleon_preset");
                            if (p.startsWith("ITEM:")) {
                                preset = ChameleonPreset.ITEM;
                                split = p.split(":");
                                if (split.length > 1) {
                                    itemPreset = split[1];
                                } else {
                                    itemPreset = "Bad Wolf";
                                    TARDISStaticUtils.warnPreset(uuid);
                                }
                            } else {
                                preset = ChameleonPreset.valueOf(p);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            preset = ChameleonPreset.FACTORY;
                        }
                        try {
                            String d = rs.getString("chameleon_demat");
                            if (d.startsWith("ITEM:")) {
                                demat = ChameleonPreset.ITEM;
                                split = d.split(":");
                                if (split.length > 1) {
                                    itemPreset = split[1];
                                } else {
                                    itemPreset = "Bad Wolf";
                                    TARDISStaticUtils.warnPreset(uuid);
                                }
                            } else {
                                demat = ChameleonPreset.valueOf(d);
                            }
                        }
                        catch (IllegalArgumentException e) {
                            demat = ChameleonPreset.FACTORY;
                        }
                        this.tardis = new Tardis(rs.getInt("tardis_id"), uuid, rs.getString("owner"), rs.getString("last_known_name"), rs.getString("chunk"), rs.getInt("tips"), Desktops.schematicFor(rs.getString("size").toLowerCase(Locale.ROOT)), rs.getBoolean("abandoned"), companions, preset, demat, itemPreset, itemDemat, rs.getInt("adapti_on"), rs.getInt("artron_level"), rs.getString("creeper"), rs.getString("beacon"), rs.getBoolean("handbrake_on"), rs.getBoolean("tardis_init"), rs.getBoolean("recharging"), rs.getBoolean("hidden"), rs.getLong("lastuse"), rs.getBoolean("iso_on"), rs.getString("eps"), rs.getString("rail"), rs.getString("renderer"), zero, frame, rs.getBoolean("powered_on"), rs.getBoolean("lights_on"), rs.getBoolean("siege_on"), rs.getInt("monsters"), rs.getInt("furnaces"));
                        if (!this.multiple) continue;
                        this.data.add(this.tardis);
                    }
                    break block39;
                }
                boolean uid = false;
                return uid;
            }
            catch (SQLException e) {
                this.plugin.debug("ResultSet error for tardis table! " + e.getMessage());
                boolean bl = false;
                return bl;
            }
            finally {
                try {
                    if (rs != null) {
                        rs.close();
                    }
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (SQLException e) {
                    this.plugin.debug("Error closing tardis table! " + e.getMessage());
                }
            }
        }
        return true;
    }

    public Tardis getTardis() {
        return this.tardis;
    }

    public List<Tardis> getData() {
        return this.data;
    }
}

