/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.commands.sudo;

import com.google.common.collect.ImmutableList;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonArray;
import com.google.gson.JsonParser;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.commands.TARDISCompleter;
import me.eccentric_nz.TARDIS.commands.preferences.IsomorphicCommand;
import me.eccentric_nz.TARDIS.commands.remote.BackCommand;
import me.eccentric_nz.TARDIS.commands.remote.ComehereCommand;
import me.eccentric_nz.TARDIS.commands.remote.HideCommand;
import me.eccentric_nz.TARDIS.commands.remote.RebuildCommand;
import me.eccentric_nz.TARDIS.commands.sudo.SudoARS;
import me.eccentric_nz.TARDIS.commands.sudo.SudoAssemble;
import me.eccentric_nz.TARDIS.commands.sudo.SudoChameleon;
import me.eccentric_nz.TARDIS.commands.sudo.SudoDeadlock;
import me.eccentric_nz.TARDIS.commands.sudo.SudoDesiege;
import me.eccentric_nz.TARDIS.commands.sudo.SudoHandbrake;
import me.eccentric_nz.TARDIS.commands.sudo.SudoRepair;
import me.eccentric_nz.TARDIS.commands.sudo.SudoUpdate;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetARS;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetAreas;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisConsole;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTardisID;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.Schematic;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.enumeration.Updateable;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.ConsoleCommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;

public class TARDISSudoCommand
extends TARDISCompleter
implements CommandExecutor,
TabCompleter {
    private final TARDIS plugin;
    private final List<String> SUDOS = List.of("ars", "assemble", "back", "chameleon", "clean", "comehere", "deadlock", "desiege", "handbrake", "hide", "isomorphic", "rebuild", "repair", "travel", "update");
    private final List<String> CHAM_SUBS = new ArrayList<String>();
    private final ImmutableList<String> TRAVEL_SUBS = ImmutableList.of((Object)"home", (Object)"area", (Object)"back");
    private final List<String> AREA_SUBS = new ArrayList<String>();
    private final List<String> UPD_SUBS = new ArrayList<String>();

    public TARDISSudoCommand(TARDIS plugin) {
        this.plugin = plugin;
        for (ChameleonPreset p : ChameleonPreset.values()) {
            this.CHAM_SUBS.add(p.toString());
        }
        ResultSetAreas rsa = new ResultSetAreas(plugin, null, false, true);
        if (rsa.resultSet()) {
            this.AREA_SUBS.addAll(rsa.getNames());
        }
        for (Updateable u : Updateable.values()) {
            this.UPD_SUBS.add(u.getName());
        }
    }

    public boolean onCommand(CommandSender sender, Command cmd, String label, String[] args) {
        if (cmd.getName().equalsIgnoreCase("tardissudo")) {
            if (sender instanceof ConsoleCommandSender || sender.hasPermission("tardis.admin")) {
                if (args.length < 2) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "TOO_FEW_ARGS");
                    return true;
                }
                OfflinePlayer offlinePlayer = Bukkit.getOfflinePlayer((String)args[0]);
                if (offlinePlayer.getName() == null) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "COULD_NOT_FIND_NAME");
                    return true;
                }
                ResultSetTardisID rs = new ResultSetTardisID(this.plugin);
                UUID uuid = offlinePlayer.getUniqueId();
                if (!rs.fromUUID(uuid.toString())) {
                    this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "PLAYER_NO_TARDIS");
                    return true;
                }
                String which = args[1].toLowerCase(Locale.ROOT);
                if (this.SUDOS.contains(which)) {
                    switch (which) {
                        case "ars": {
                            if (sender instanceof ConsoleCommandSender) {
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_NO_CONSOLE");
                                return true;
                            }
                            HashMap<String, Object> wherer = new HashMap<String, Object>();
                            wherer.put("tardis_id", rs.getTardisId());
                            ResultSetARS rsa = new ResultSetARS(this.plugin, wherer);
                            if (!rsa.resultSet()) {
                                String[][][] empty = new String[3][9][9];
                                for (int y = 0; y < 3; ++y) {
                                    for (int x = 0; x < 9; ++x) {
                                        for (int z = 0; z < 9; ++z) {
                                            empty[y][x][z] = "STONE";
                                        }
                                    }
                                }
                                ResultSetTardisConsole rstc = new ResultSetTardisConsole(this.plugin);
                                if (rstc.fromUUID(uuid.toString())) {
                                    Schematic schm = rstc.getSchematic();
                                    String controlBlock = schm.getSeedMaterial().toString();
                                    if (schm.getPermission().equals("coral") || schm.getPermission().equals("deluxe") || schm.getPermission().equals("eleventh") || schm.getPermission().equals("master")) {
                                        empty[0][4][4] = controlBlock;
                                        empty[0][4][5] = controlBlock;
                                        empty[0][5][4] = controlBlock;
                                        empty[0][5][5] = controlBlock;
                                        empty[1][4][5] = controlBlock;
                                        empty[1][5][4] = controlBlock;
                                        empty[1][5][5] = controlBlock;
                                    } else if (schm.getPermission().equals("bigger") || schm.getPermission().equals("division") || schm.getPermission().equals("redstone") || schm.getPermission().equals("twelfth") || schm.getPermission().equals("thirteenth")) {
                                        empty[1][4][5] = controlBlock;
                                        empty[1][5][4] = controlBlock;
                                        empty[1][5][5] = controlBlock;
                                    }
                                    empty[1][4][4] = controlBlock;
                                    Gson gson = new GsonBuilder().disableHtmlEscaping().create();
                                    JsonArray json = JsonParser.parseString((String)gson.toJson((Object)empty)).getAsJsonArray();
                                    HashMap<String, Object> seta = new HashMap<String, Object>();
                                    seta.put("tardis_id", rs.getTardisId());
                                    seta.put("uuid", uuid);
                                    seta.put("json", json.toString());
                                    this.plugin.getQueryFactory().doInsert("ars", seta);
                                }
                            }
                            return new SudoARS(this.plugin).showARS((Player)sender, uuid);
                        }
                        case "assemble": {
                            return new SudoAssemble(this.plugin).restore(sender, uuid, offlinePlayer.getName());
                        }
                        case "back": {
                            return new BackCommand(this.plugin).sendBack(sender, rs.getTardisId(), offlinePlayer);
                        }
                        case "chameleon": {
                            return new SudoChameleon(this.plugin).setPreset(sender, rs.getTardisId(), args, offlinePlayer);
                        }
                        case "clean": {
                            return new SudoRepair(this.plugin, uuid, true).repair();
                        }
                        case "comehere": {
                            if (sender instanceof ConsoleCommandSender) {
                                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_NO_CONSOLE");
                                return true;
                            }
                            return new ComehereCommand(this.plugin).doRemoteComeHere((Player)sender, uuid);
                        }
                        case "deadlock": {
                            return new SudoDeadlock(this.plugin).toggleDeadlock(uuid, sender);
                        }
                        case "desiege": {
                            if (offlinePlayer.isOnline()) {
                                return new SudoDesiege(this.plugin).restore(sender, uuid, rs.getTardisId());
                            }
                            this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "NOT_ONLINE");
                            return true;
                        }
                        case "handbrake": {
                            return new SudoHandbrake(this.plugin).toggle(sender, args, uuid);
                        }
                        case "hide": {
                            return new HideCommand(this.plugin).doRemoteHide(sender, rs.getTardisId());
                        }
                        case "isomorphic": {
                            return new IsomorphicCommand(this.plugin).toggleIsomorphicControls(uuid, sender);
                        }
                        case "rebuild": {
                            return new RebuildCommand(this.plugin).doRemoteRebuild(sender, rs.getTardisId(), offlinePlayer, true);
                        }
                        case "repair": {
                            return new SudoRepair(this.plugin, uuid, false).repair();
                        }
                        case "travel": {
                            return this.plugin.getServer().dispatchCommand((CommandSender)this.plugin.getConsole(), "tardisremote " + offlinePlayer.getName() + " travel " + String.join((CharSequence)" ", Arrays.copyOfRange(args, 2, args.length)));
                        }
                    }
                    if (sender instanceof ConsoleCommandSender) {
                        this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_NO_CONSOLE");
                        return true;
                    }
                    return new SudoUpdate(this.plugin).initiate((Player)sender, args, rs.getTardisId(), uuid);
                }
            } else {
                this.plugin.getMessenger().send(sender, TardisModule.TARDIS, "CMD_ADMIN");
            }
            return true;
        }
        return false;
    }

    public List<String> onTabComplete(CommandSender sender, Command command, String label, String[] args) {
        if (args.length == 1) {
            return null;
        }
        if (args.length == 2) {
            return this.partial(args[1], this.SUDOS);
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("chameleon")) {
            return this.partial(args[2], this.CHAM_SUBS);
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("travel")) {
            return this.partial(args[2], (Collection<String>)this.TRAVEL_SUBS);
        }
        if (args.length == 3 && args[1].equalsIgnoreCase("update")) {
            return this.partial(args[2], this.UPD_SUBS);
        }
        if (args.length == 4 && args[2].equalsIgnoreCase("area")) {
            return this.partial(args[3], this.AREA_SUBS);
        }
        return ImmutableList.of();
    }
}

