/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.areas;

import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.areas.EditAreasInventory;
import me.eccentric_nz.TARDIS.listeners.TARDISMenuListener;
import me.eccentric_nz.TARDIS.utility.ComponentUtils;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import net.kyori.adventure.text.Component;
import org.bukkit.Location;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

public class EditAreasListener
extends TARDISMenuListener {
    private final TARDIS plugin;
    private final HashMap<UUID, Integer> selected = new HashMap();

    public EditAreasListener(TARDIS plugin) {
        super(plugin);
        this.plugin = plugin;
    }

    private void removeLocation(List<Component> lore) {
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("area_id", this.getValueFromLore(lore.get(4)));
        where.put("world", ComponentUtils.stripColour(lore.getFirst()));
        where.put("x", this.getValueFromLore(lore.get(1)));
        where.put("y", this.getValueFromLore(lore.get(2)));
        where.put("z", this.getValueFromLore(lore.get(3)));
        this.plugin.getQueryFactory().doDelete("area_locations", where);
    }

    @EventHandler(priority=EventPriority.MONITOR, ignoreCancelled=true)
    public void onCompanionGUIClick(InventoryClickEvent event) {
        if (!(event.getInventory().getHolder(false) instanceof EditAreasInventory)) {
            return;
        }
        event.setCancelled(true);
        int slot = event.getRawSlot();
        Player player = (Player)event.getWhoClicked();
        UUID uuid = player.getUniqueId();
        if (slot < 0 || slot > 53) {
            return;
        }
        ItemStack is = event.getView().getItem(slot);
        if (is == null) {
            return;
        }
        switch (slot) {
            case 45: {
                break;
            }
            case 48: {
                ItemMeta meta = is.getItemMeta();
                Object area_id = this.getValueFromLore((Component)meta.lore().getFirst());
                Location location = player.getLocation();
                HashMap<String, Object> add = new HashMap<String, Object>();
                add.put("area_id", area_id);
                add.put("world", location.getWorld().getName());
                add.put("x", location.getBlockX());
                add.put("y", location.getBlockY());
                add.put("z", location.getBlockZ());
                this.plugin.getQueryFactory().doInsert("area_locations", add);
                this.close(player);
                break;
            }
            case 50: {
                if (!this.selected.containsKey(uuid)) break;
                ItemStack map = event.getView().getItem(this.selected.get(uuid).intValue());
                ItemMeta meta = map.getItemMeta();
                List lore = meta.lore();
                this.removeLocation(lore);
                this.close(player);
                break;
            }
            case 53: {
                this.close(player);
                break;
            }
            default: {
                this.selected.put(uuid, slot);
            }
        }
    }

    private Object getValueFromLore(Component s) {
        String[] split = ComponentUtils.stripColour(s).split(": ");
        return TARDISNumberParsers.parseInt(split[1]);
    }
}

