/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardisweepingangels.monsters.angel_of_liberty;

import java.util.Collection;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngelSpawnEvent;
import me.eccentric_nz.tardisweepingangels.TARDISWeepingAngels;
import me.eccentric_nz.tardisweepingangels.equip.Equipper;
import me.eccentric_nz.tardisweepingangels.nms.MonsterSpawner;
import me.eccentric_nz.tardisweepingangels.utils.Monster;
import me.eccentric_nz.tardisweepingangels.utils.WaterChecker;
import me.eccentric_nz.tardisweepingangels.utils.WorldGuardChecker;
import me.eccentric_nz.tardisweepingangels.utils.WorldProcessor;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Zombie;
import org.bukkit.event.Event;
import org.bukkit.persistence.PersistentDataContainer;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;

public class AngelOfLibertyRunnable
implements Runnable {
    private final TARDIS plugin;

    public AngelOfLibertyRunnable(TARDIS plugin) {
        this.plugin = plugin;
    }

    @Override
    public void run() {
        this.plugin.getServer().getWorlds().forEach(w -> {
            String name = WorldProcessor.sanitiseName(w.getName());
            if (this.plugin.getMonstersConfig().getInt("angel_of_liberty.worlds." + name) > 0) {
                int angel_of_liberty = 0;
                Collection zombies = w.getEntitiesByClass(Zombie.class);
                for (Zombie z : zombies) {
                    PersistentDataContainer pdc = z.getPersistentDataContainer();
                    if (!pdc.has(TARDISWeepingAngels.ANGEL_OF_LIBERTY, PersistentDataType.INTEGER)) continue;
                    ++angel_of_liberty;
                }
                if (angel_of_liberty < this.plugin.getMonstersConfig().getInt("angel_of_liberty.worlds." + name)) {
                    this.spawnAngelOfLiberty((World)w);
                }
            }
        });
    }

    private void spawnAngelOfLiberty(World world) {
        int z;
        int y;
        Chunk chunk;
        int x;
        Location l;
        int players = world.getPlayers().size();
        if (players == 0) {
            return;
        }
        Chunk[] chunks = world.getLoadedChunks();
        if (chunks.length > 0 && WaterChecker.isNotWater(l = new Location(world, (double)(x = (chunk = chunks[TARDISConstants.RANDOM.nextInt(chunks.length)]).getX() * 16 + TARDISConstants.RANDOM.nextInt(16)), (double)((y = world.getHighestBlockYAt(x, z = chunk.getZ() * 16 + TARDISConstants.RANDOM.nextInt(16))) + 1), (double)z))) {
            if (this.plugin.isWorldGuardOnServer() && !WorldGuardChecker.canSpawn(l)) {
                return;
            }
            LivingEntity angel_of_liberty = new MonsterSpawner().create(l, Monster.ANGEL_OF_LIBERTY);
            this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
                new Equipper(Monster.ANGEL_OF_LIBERTY, angel_of_liberty, false).setHelmetAndInvisibility();
                this.plugin.getServer().getPluginManager().callEvent((Event)new TARDISWeepingAngelSpawnEvent((Entity)angel_of_liberty, EntityType.ZOMBIE, Monster.ANGEL_OF_LIBERTY, l));
            }, 5L);
        }
    }
}

