/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.worldgen.populators;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.enumeration.Room;
import me.eccentric_nz.TARDIS.rooms.TARDISWalls;
import me.eccentric_nz.TARDIS.schematic.SchematicGZip;
import me.eccentric_nz.tardischunkgenerator.worldgen.utils.RoomsUtility;
import org.bukkit.Keyed;
import org.bukkit.Material;
import org.bukkit.Tag;
import org.bukkit.block.Banner;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.FaceAttachable;
import org.bukkit.block.data.type.Switch;
import org.bukkit.generator.BlockPopulator;
import org.bukkit.generator.LimitedRegion;
import org.bukkit.generator.WorldInfo;

public class RoomPopulator
extends BlockPopulator {
    private final TARDIS plugin;
    private final List<String> rooms = List.of("ALLAY", "APIARY", "AQUARIUM", "ARBORETUM", "ARCHITECTURAL", "BAKER", "BAMBOO", "BEDROOM", "BIRDCAGE", "CLOISTER", "CHEMISTRY", "EMPTY", "EYE", "FARM", "GALLERY", "GARDEN", "GEODE", "GREENHOUSE", "HAPPY", "HARMONY", "HUTCH", "IGLOO", "IISTUBIL", "KITCHEN", "LAUNDRY", "LAVA", "LAZARUS", "LIBRARY", "MANGROVE", "MUSHROOM", "NAUTILUS", "NETHER", "OBSERVATORY", "PASSAGE", "PEN", "POOL", "RAIL", "SHELL", "SMELTER", "STABLE", "STALL", "SURGERY", "TRENZALORE", "VAULT", "VILLAGE", "WARDROBE", "WOOD", "WORKSHOP");

    public RoomPopulator(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void populate(WorldInfo worldInfo, Random random, int x, int z, LimitedRegion limitedRegion) {
        String room = this.rooms.get(random.nextInt(this.rooms.size()));
        JsonObject obj = SchematicGZip.getObject(this.plugin, "rooms", room.toLowerCase(Locale.ROOT), false);
        if (obj != null) {
            int level = 0;
            int row = 0;
            JsonObject dim = obj.get("dimensions").getAsJsonObject();
            int h = dim.get("height").getAsInt() - 1;
            int w = dim.get("width").getAsInt();
            int l = dim.get("length").getAsInt() - 1;
            int startX = x * 16;
            int startY = 64;
            int startZ = z * 16;
            BlockData orange = TARDISWalls.BLOCKS.get(random.nextInt(TARDISWalls.BLOCKS.size())).createBlockData();
            BlockData lightGray = TARDISWalls.BLOCKS.get(random.nextInt(TARDISWalls.BLOCKS.size())).createBlockData();
            JsonArray arr = obj.get("input").getAsJsonArray();
            while (level <= h && row < w) {
                JsonArray floor = arr.get(level).getAsJsonArray();
                JsonArray r = floor.get(row).getAsJsonArray();
                for (int col = 0; col <= l; ++col) {
                    JsonObject c = r.get(col).getAsJsonObject();
                    int lrX = startX + row;
                    int lrY = startY + level;
                    int lrZ = startZ + col;
                    BlockData data = this.plugin.getServer().createBlockData(c.get("data").getAsString());
                    Material type = data.getMaterial();
                    if (limitedRegion.isInRegion(lrX, lrY, lrZ)) {
                        if (type.equals((Object)Material.SPAWNER) && room.equals("FARM")) {
                            data = Material.LIGHT_GRAY_WOOL.createBlockData();
                        }
                        if (type.equals((Object)Material.ORANGE_WOOL)) {
                            data = orange;
                        }
                        if (type.equals((Object)Material.LIGHT_GRAY_WOOL)) {
                            data = lightGray;
                        }
                        if (type.equals((Object)Material.MUSHROOM_STEM) && !room.equals("MUSHROOM")) {
                            data = Material.REPEATER.createBlockData();
                        }
                        if (type.equals((Object)Material.CAKE)) {
                            Switch lever = (Switch)Material.LEVER.createBlockData();
                            lever.setAttachedFace(FaceAttachable.AttachedFace.FLOOR);
                            lever.setFacing(BlockFace.SOUTH);
                            data = lever;
                        }
                        if (type.equals((Object)Material.SOUL_SAND) && (room.equals("STABLE") || room.equals("VILLAGE") || room.equals("LAVA") || room.equals("ALLAY") || room.equals("GEODE") || room.equals("HUTCH") || room.equals("IGLOO") || room.equals("IISTUBIL") || room.equals("MANGROVE") || room.equals("PEN") || room.equals("STALL") || room.equals("BAMBOO") || room.equals("BIRDCAGE") || room.equals("GARDEN") || room.equals("NAUTILUS"))) {
                            switch (Room.valueOf(room)) {
                                case ALLAY: {
                                    data = Material.LIGHT_GRAY_WOOL.createBlockData();
                                    break;
                                }
                                case VILLAGE: {
                                    data = Material.COBBLESTONE.createBlockData();
                                    break;
                                }
                                case HUTCH: 
                                case STABLE: 
                                case STALL: 
                                case MAZE: 
                                case GARDEN: {
                                    data = Material.GRASS_BLOCK.createBlockData();
                                    break;
                                }
                                case BAMBOO: 
                                case BIRDCAGE: {
                                    data = Material.PODZOL.createBlockData();
                                    break;
                                }
                                case GEODE: {
                                    data = Material.CLAY.createBlockData();
                                    break;
                                }
                                case IGLOO: {
                                    data = Material.PACKED_ICE.createBlockData();
                                    break;
                                }
                                case IISTUBIL: {
                                    data = Material.TERRACOTTA.createBlockData();
                                    break;
                                }
                                case LAVA: {
                                    data = Material.NETHERRACK.createBlockData();
                                    break;
                                }
                                case MANGROVE: {
                                    data = TARDISConstants.WATER;
                                    break;
                                }
                                case NAUTILUS: {
                                    data = TARDISConstants.GLASS;
                                    break;
                                }
                                case PEN: {
                                    data = Material.MOSS_BLOCK.createBlockData();
                                    break;
                                }
                                case ZERO: {
                                    data = Material.PINK_CARPET.createBlockData();
                                    break;
                                }
                                default: {
                                    data = TARDISConstants.BLACK;
                                }
                            }
                        }
                        if ((type.equals((Object)Material.SOUL_SAND) || type.equals((Object)Material.CARVED_PUMPKIN)) && room.equals("SMELTER")) {
                            data = Material.CHEST.createBlockData();
                        }
                        if (type.equals((Object)Material.DEAD_HORN_CORAL_BLOCK) && room.equals("AQUARIUM")) {
                            data = Material.LIGHT_GRAY_WOOL.createBlockData();
                        }
                        if (type.equals((Object)Material.DEAD_BUBBLE_CORAL_BLOCK) && room.equals("NAUTILUS")) {
                            data = Material.ICE.createBlockData();
                        }
                        if (type.equals((Object)Material.BEDROCK) && !room.equals("SHELL") || type.equals((Object)Material.SOUL_SAND) && room.equals("SHELL") || type.equals((Object)Material.SPONGE)) {
                            data = TARDISConstants.AIR;
                        }
                        limitedRegion.setBlockData(lrX, lrY, lrZ, data);
                        if (Tag.BANNERS.isTagged((Keyed)type)) {
                            JsonObject state;
                            JsonObject jsonObject = state = c.has("banner") ? c.get("banner").getAsJsonObject() : null;
                            if (state != null) {
                                Banner banner = (Banner)limitedRegion.getBlockState(lrX, lrY, lrZ);
                                RoomsUtility.flag(state, banner);
                            }
                        }
                    }
                    if (col == l && row < w) {
                        ++row;
                    }
                    if (col != l || row != w || level >= h) continue;
                    row = 0;
                    ++level;
                }
            }
            if (obj.has("paintings")) {
                JsonArray paintings = obj.get("paintings").getAsJsonArray();
                for (int i = 0; i < paintings.size(); ++i) {
                    RoomsUtility.hang(paintings.get(i).getAsJsonObject(), limitedRegion, startX, startZ);
                }
            }
            if (obj.has("item_frames")) {
                JsonArray frames = obj.get("item_frames").getAsJsonArray();
                for (int i = 0; i < frames.size(); ++i) {
                    RoomsUtility.curate(frames.get(i).getAsJsonObject(), limitedRegion, startX, startZ);
                }
            }
            if (obj.has("item_displays")) {
                JsonArray displays = obj.get("item_displays").getAsJsonArray();
                for (int i = 0; i < displays.size(); ++i) {
                    RoomsUtility.fakeBlock(displays.get(i).getAsJsonObject(), limitedRegion, startX, startZ);
                }
            }
        }
    }
}

