/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.tardischunkgenerator.custombiome;

import java.util.List;
import java.util.Locale;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Holder;
import net.minecraft.core.Registry;
import net.minecraft.core.WritableRegistry;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.Identifier;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.dedicated.DedicatedServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkAccess;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.craftbukkit.CraftChunk;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.CraftWorld;

public class BiomeHelper {
    public static Registry<Biome> getRegistry() {
        DedicatedServer dedicatedServer = ((CraftServer)Bukkit.getServer()).getServer();
        return (Registry)dedicatedServer.registryAccess().lookup(Registries.BIOME).get();
    }

    public static void refreshChunk(Chunk chunk) {
        CraftChunk craftChunk = (CraftChunk)chunk;
        ServerLevel level = craftChunk.getCraftWorld().getHandle();
        level.getChunkSource().chunkMap.resendBiomesForChunks(List.of(craftChunk.getHandle(ChunkStatus.BIOMES)));
    }

    public void setCustomBiome(String newBiomeName, Chunk chunk, int startY) {
        ResourceKey key;
        WritableRegistry registryWritable = (WritableRegistry)BiomeHelper.getRegistry();
        Biome base = (Biome)registryWritable.getValueOrThrow(key = ResourceKey.create((ResourceKey)Registries.BIOME, (Identifier)Identifier.fromNamespaceAndPath((String)"tardis", (String)newBiomeName.toLowerCase(Locale.ROOT))));
        if (base == null) {
            if (newBiomeName.contains(":")) {
                ResourceKey newKey = ResourceKey.create((ResourceKey)Registries.BIOME, (Identifier)Identifier.fromNamespaceAndPath((String)newBiomeName.split(":")[0].toLowerCase(Locale.ROOT), (String)newBiomeName.split(":")[1].toLowerCase(Locale.ROOT)));
                base = (Biome)registryWritable.getValueOrThrow(newKey);
                if (base == null) {
                    return;
                }
            } else {
                return;
            }
        }
        Holder biomeHolder = registryWritable.wrapAsHolder((Object)base);
        ServerLevel w = ((CraftWorld)chunk.getWorld()).getHandle();
        int cx = chunk.getX() * 16;
        int cz = chunk.getZ() * 16;
        for (int x = 0; x <= 15; ++x) {
            for (int z = 0; z <= 15; ++z) {
                for (int y = startY; y < startY + 16; ++y) {
                    this.setCustomBiome(cx + x, y, cz + z, (Level)w, (Holder<Biome>)biomeHolder);
                }
            }
        }
        BiomeHelper.refreshChunk(chunk);
    }

    public boolean setCustomBiome(String newBiomeName, Location location) {
        ResourceKey key;
        WritableRegistry registrywritable = (WritableRegistry)BiomeHelper.getRegistry();
        Biome base = (Biome)registrywritable.getValueOrThrow(key = ResourceKey.create((ResourceKey)Registries.BIOME, (Identifier)Identifier.withDefaultNamespace((String)newBiomeName.toLowerCase(Locale.ROOT))));
        if (base == null) {
            if (newBiomeName.contains(":")) {
                ResourceKey newKey = ResourceKey.create((ResourceKey)Registries.BIOME, (Identifier)Identifier.fromNamespaceAndPath((String)newBiomeName.split(":")[0].toLowerCase(Locale.ROOT), (String)newBiomeName.split(":")[1].toLowerCase(Locale.ROOT)));
                base = (Biome)registrywritable.getValueOrThrow(newKey);
                if (base == null) {
                    return false;
                }
            } else {
                return false;
            }
        }
        this.setCustomBiome(location.getBlockX(), location.getBlockY(), location.getBlockZ(), (Level)((CraftWorld)location.getWorld()).getHandle(), (Holder<Biome>)registrywritable.wrapAsHolder((Object)base));
        BiomeHelper.refreshChunk(location.getChunk());
        return true;
    }

    private void setCustomBiome(int x, int y, int z, Level w, Holder<Biome> bb) {
        ChunkAccess chunk;
        BlockPos pos = new BlockPos(x, 0, z);
        if (w.isLoaded(pos) && (chunk = w.getChunk(pos)) != null) {
            chunk.setBiome(x >> 2, y >> 2, z >> 2, bb);
        }
    }
}

