/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.travel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.api.Parameters;
import me.eccentric_nz.TARDIS.blueprints.TARDISPermission;
import me.eccentric_nz.TARDIS.customblocks.TARDISDisplayItemUtils;
import me.eccentric_nz.TARDIS.customblocks.TARDISMushroomBlockData;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetPlayerPrefs;
import me.eccentric_nz.TARDIS.database.resultset.ResultSetTravellers;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.Flag;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.TARDISMaterials;
import me.eccentric_nz.TARDIS.utility.TARDISStaticLocationGetters;
import me.eccentric_nz.TARDIS.utility.TARDISStaticUtils;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.BlockFace;
import org.bukkit.block.data.BlockData;
import org.bukkit.block.data.MultipleFacing;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.ItemDisplay;
import org.bukkit.entity.ItemFrame;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class TARDISTimeTravel {
    private final TARDIS plugin;
    private final int attempts;
    private Location dest;

    public TARDISTimeTravel(TARDIS plugin) {
        this.plugin = plugin;
        this.attempts = plugin.getConfig().getInt("travel.random_attempts");
    }

    public static int safeLocation(int startx, int starty, int startz, int resetx, int resetz, World w, COMPASS d) {
        int rowcount;
        int count = 0;
        int colcount = switch (d) {
            case COMPASS.EAST, COMPASS.WEST -> {
                rowcount = 3;
                yield 4;
            }
            default -> {
                rowcount = 4;
                yield 3;
            }
        };
        for (int level = 0; level < 4; ++level) {
            for (int row = 0; row < rowcount; ++row) {
                for (int col = 0; col < colcount; ++col) {
                    Material mat;
                    Block block = w.getBlockAt(startx, starty, startz);
                    if (level == 0) {
                        for (Entity e : w.getNearbyEntities(block.getLocation(), 1.5, 1.5, 1.5)) {
                            if (!(e instanceof ItemFrame)) continue;
                            ++count;
                            break;
                        }
                    }
                    if (!TARDISConstants.GOOD_MATERIALS.contains(mat = block.getType())) {
                        if (TARDIS.plugin.getConfig().getBoolean("siege.enabled") && (mat.equals((Object)Material.BROWN_MUSHROOM_BLOCK) || mat.equals((Object)Material.BARRIER))) {
                            MultipleFacing mf;
                            BlockData blockData = block.getBlockData();
                            if (blockData instanceof MultipleFacing && !(mf = (MultipleFacing)blockData).getAsString().equals(TARDISMushroomBlockData.BROWN_MUSHROOM_DATA.get(2))) {
                                ++count;
                                break;
                            }
                            ItemDisplay tdi = TARDISDisplayItemUtils.get(block);
                            if (tdi == null || tdi.getItemStack() == null || tdi.getItemStack().getType() != Material.CYAN_CONCRETE) {
                                ++count;
                                break;
                            }
                        } else if (!w.getName().equals("siluria") || !mat.equals((Object)Material.BAMBOO)) {
                            ++count;
                        }
                    }
                    ++startx;
                }
                startx = resetx;
                ++startz;
            }
            startz = resetz;
            ++starty;
        }
        return count;
    }

    public static int[] getStartLocation(Location loc, COMPASS d) {
        int[] startLocation = new int[4];
        switch (d) {
            case EAST: {
                startLocation[0] = loc.getBlockX() - 2;
                startLocation[1] = startLocation[0];
                startLocation[2] = loc.getBlockZ() - 1;
                startLocation[3] = startLocation[2];
                break;
            }
            case SOUTH: {
                startLocation[0] = loc.getBlockX() - 1;
                startLocation[1] = startLocation[0];
                startLocation[2] = loc.getBlockZ() - 2;
                startLocation[3] = startLocation[2];
                break;
            }
            default: {
                startLocation[0] = loc.getBlockX() - 1;
                startLocation[1] = startLocation[0];
                startLocation[2] = loc.getBlockZ() - 1;
                startLocation[3] = startLocation[2];
            }
        }
        return startLocation;
    }

    public Location randomDestination(Player player, int rx, int rz, int ry, COMPASS d, String e, World this_world, boolean malfunction, Location current) {
        Set worldlist = this.plugin.getPlanetsConfig().getConfigurationSection("planets").getKeys(false);
        ArrayList<World> allowedWorlds = new ArrayList<World>();
        if (e.equals("THIS") && this.plugin.getPlanetsConfig().getBoolean("planets." + this_world.getName() + ".time_travel")) {
            allowedWorlds.add(this_world);
        } else {
            worldlist.forEach(o -> {
                World ww = TARDISAliasResolver.getWorldFromAlias(o);
                if (ww != null) {
                    String env = ww.getEnvironment().toString();
                    if (!env.equals("NETHER") && !env.equals("THE_END")) {
                        env = "NORMAL";
                    }
                    if (e.equalsIgnoreCase(env)) {
                        if (this.plugin.getConfig().getBoolean("travel.include_default_world") || !this.plugin.getConfig().getBoolean("creation.default_world")) {
                            if (this.plugin.getPlanetsConfig().getBoolean("planets." + o + ".time_travel") || malfunction) {
                                allowedWorlds.add(ww);
                            }
                        } else if (!o.equals(this.plugin.getConfig().getString("creation.default_world_name")) && (this.plugin.getPlanetsConfig().getBoolean("planets." + o + ".time_travel") || malfunction)) {
                            allowedWorlds.add(ww);
                        }
                    }
                    if (!(this_world == null || allowedWorlds.size() <= 1 && this.plugin.getPlanetsConfig().getBoolean("planets." + this_world.getName() + ".time_travel"))) {
                        allowedWorlds.remove(this_world);
                    }
                    if (allowedWorlds.size() > 1 && this.plugin.getConfig().getBoolean("travel.per_world_perms") && !TARDISPermission.hasPermission(player, "tardis.travel." + o)) {
                        allowedWorlds.remove(ww);
                    }
                }
            });
        }
        int listlen = allowedWorlds.size();
        World randworld = (World)allowedWorlds.get(TARDISConstants.RANDOM.nextInt(listlen));
        return this.getDestination(randworld, rx, rz, ry, d, e, current, player);
    }

    /*
     * Unable to fully structure code
     */
    public Location getDestination(World randworld, int rx, int rz, int ry, COMPASS d, String e, Location current, Player p) {
        max = this.plugin.getConfig().getInt("travel.tp_radius");
        quarter = (max + 4 - 1) / 4;
        range = quarter + 1;
        wherex = 0;
        highest = 252;
        wherez = 0;
        switch (1.$SwitchMap$org$bukkit$World$Environment[randworld.getEnvironment().ordinal()]) {
            case 1: {
                for (n = 0; n < this.attempts && !this.safeNether(randworld, wherex = this.randomX(range, quarter, rx, ry, e, current), wherez = this.randomZ(range, quarter, rz, ry, e, current), d, p); ++n) {
                }
                break;
            }
            case 2: {
                if (this.plugin.getPlanetsConfig().getBoolean("planets." + randworld.getName() + ".void")) {
                    voidx = this.randomX(range, quarter, rx, ry, e, current);
                    voidy = TARDISConstants.RANDOM.nextInt(240) + 5;
                    voidz = this.randomZ(range, quarter, rz, ry, e, current);
                    return new Location(randworld, (double)voidx, (double)voidy, (double)voidz);
                }
                for (n = 0; n < this.attempts; ++n) {
                    wherex = TARDISConstants.RANDOM.nextInt(240);
                    wherez = TARDISConstants.RANDOM.nextInt(240);
                    endSpawn = randworld.getSpawnLocation();
                    highest = TARDISStaticLocationGetters.getHighestYin3x3(randworld, endSpawn.getBlockX() + (wherex -= 120), endSpawn.getBlockZ() + (wherez -= 120));
                    if (highest > 40) {
                        currentBlock = randworld.getBlockAt(wherex, highest, wherez);
                        chunk_loc = currentBlock.getLocation();
                        if (this.plugin.getPluginRespect().getRespect(chunk_loc, new Parameters(p, Flag.getNoMessageFlags()))) {
                            while (!randworld.getChunkAt(chunk_loc).isLoaded()) {
                                randworld.getChunkAt(chunk_loc).load();
                            }
                            gsl = TARDISTimeTravel.getStartLocation(chunk_loc, d);
                            startx = gsl[0];
                            resetx = gsl[1];
                            starty = chunk_loc.getBlockY() + 1;
                            startz = gsl[2];
                            resetz = gsl[3];
                            count = TARDISTimeTravel.safeLocation(startx, starty, startz, resetx, resetz, randworld, d);
                        } else {
                            count = 1;
                        }
                    } else {
                        count = 1;
                    }
                    if (count == 0) break;
                }
                this.dest = highest > 0 ? new Location(randworld, (double)wherex, (double)highest, (double)wherez) : null;
                break;
            }
            default: {
                if (this.plugin.getPlanetsConfig().getBoolean("planets." + randworld.getName() + ".false_nether")) {
                    for (n = 0; n < this.attempts && !this.safeNether(randworld, wherex = this.randomX(range, quarter, rx, ry, e, current), wherez = this.randomZ(range, quarter, rz, ry, e, current), d, p); ++n) {
                    }
                    break;
                }
                if (this.plugin.getPlanetsConfig().getBoolean("planets." + randworld.getName() + ".void")) {
                    voidx = this.randomX(range, quarter, rx, ry, e, current);
                    voidy = TARDISConstants.RANDOM.nextInt(240) + 5;
                    voidz = this.randomZ(range, quarter, rz, ry, e, current);
                    return new Location(randworld, (double)voidx, (double)voidy, (double)voidz);
                }
                timeout = System.currentTimeMillis() + this.plugin.getConfig().getLong("travel.timeout") * 1000L;
                while (System.currentTimeMillis() < timeout) {
                    count = 0;
                    wherex = this.randomX(range, quarter, rx, ry, e, current);
                    highest = TARDISStaticLocationGetters.getHighestYin3x3(randworld, wherex, wherez = this.randomZ(range, quarter, rz, ry, e, current));
                    if (highest > 3) {
                        currentBlock = randworld.getBlockAt(wherex, highest, wherez);
                        if (currentBlock.getRelative(BlockFace.DOWN).getType().equals((Object)Material.WATER) && !this.plugin.getConfig().getBoolean("travel.land_on_water")) {
                            rsp = new ResultSetPlayerPrefs(this.plugin, p.getUniqueId().toString());
                            if (rsp.resultSet()) {
                                if (rsp.isSubmarineOn() && TARDISStaticUtils.isOceanBiome(currentBlock.getLocation().getBlock().getBiome())) {
                                    this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "SUB_SEARCH");
                                    underwater = this.submarine(currentBlock, d);
                                    if (underwater != null) {
                                        wherep = new HashMap<String, Object>();
                                        wherep.put("uuid", p.getUniqueId().toString());
                                        rst = new ResultSetTravellers(this.plugin, wherep, false);
                                        if (rst.resultSet()) {
                                            this.plugin.getTrackerKeeper().getSubmarine().add(rst.getTardis_id());
                                        }
                                        return underwater;
                                    }
                                    count = 1;
                                } else if (!rsp.isSubmarineOn()) {
                                    count = 1;
                                }
                            } else {
                                count = 1;
                            }
                        } else {
                            if (TARDISConstants.GOOD_MATERIALS.contains(currentBlock.getType())) {
                                currentBlock = currentBlock.getRelative(BlockFace.DOWN);
                            }
                            chunk_loc = currentBlock.getLocation();
                            if (this.plugin.getPluginRespect().getRespect(chunk_loc, new Parameters(p, Flag.getNoMessageFlags()))) {
                                while (!randworld.getChunkAt(chunk_loc).isLoaded()) {
                                    randworld.getChunkAt(chunk_loc).load();
                                }
                                gsl = TARDISTimeTravel.getStartLocation(chunk_loc, d);
                                startx = gsl[0];
                                resetx = gsl[1];
                                starty = chunk_loc.getBlockY() + 1;
                                startz = gsl[2];
                                resetz = gsl[3];
                                count = TARDISTimeTravel.safeLocation(startx, starty, startz, resetx, resetz, randworld, d);
                            } else {
                                count = 1;
                            }
                        }
                    } else {
                        count = 1;
                    }
                    if (count != 0) continue;
                    ** GOTO lbl109
                }
                if (!this.plugin.getPluginRespect().getRespect(new Location(randworld, (double)wherex, (double)highest, (double)wherez), new Parameters(p, Flag.getNoMessageFlags()))) {
                    return null;
                }
                highest = this.plugin.getConfig().getInt("travel.timeout_height");
lbl109:
                // 2 sources

                this.dest = new Location(randworld, (double)wherex, (double)highest, (double)wherez);
            }
        }
        return this.dest;
    }

    public void testSafeLocation(Location location, COMPASS direction, Player player) {
        int row;
        int sx;
        World w = location.getWorld();
        int starty = location.getBlockY();
        int sz = switch (direction) {
            case COMPASS.EAST -> {
                sx = location.getBlockX() - 2;
                yield location.getBlockZ() - 1;
            }
            case COMPASS.SOUTH -> {
                sx = location.getBlockX() - 1;
                yield location.getBlockZ() - 2;
            }
            default -> {
                sx = location.getBlockX() - 1;
                yield location.getBlockZ() - 1;
            }
        };
        int col = switch (direction) {
            case COMPASS.EAST, COMPASS.WEST -> {
                row = 2;
                yield 3;
            }
            default -> {
                row = 3;
                yield 2;
            }
        };
        HashSet<Block> markers = new HashSet<Block>();
        markers.add(w.getBlockAt(sx, starty, sz));
        markers.add(w.getBlockAt(sx, starty, sz + row));
        markers.add(w.getBlockAt(sx + col, starty, sz));
        markers.add(w.getBlockAt(sx + col, starty, sz + row));
        markers.add(w.getBlockAt(sx, starty + 3, sz));
        markers.add(w.getBlockAt(sx + col, starty + 3, sz));
        markers.add(w.getBlockAt(sx, starty + 3, sz + row));
        markers.add(w.getBlockAt(sx + col, starty + 3, sz + row));
        for (Block block : markers) {
            player.sendBlockChange(block.getLocation(), TARDISConstants.SNOW_BLOCK);
        }
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            for (Block block : markers) {
                block.getState().update();
            }
        }, 300L);
    }

    public boolean safeNether(World nether, int wherex, int wherez, COMPASS d, Player p) {
        boolean safe = false;
        int wherey = 100;
        Block startBlock = nether.getBlockAt(wherex, wherey, wherez);
        while (!startBlock.getType().isAir()) {
            startBlock = startBlock.getRelative(BlockFace.DOWN);
        }
        int air = 0;
        while (startBlock.getType().isAir() && startBlock.getLocation().getBlockY() > 30) {
            startBlock = startBlock.getRelative(BlockFace.DOWN);
            ++air;
        }
        Material mat = startBlock.getType();
        if (air >= 4 && (this.plugin.getGeneralKeeper().getGoodNether().contains(mat) || this.plugin.getPlanetsConfig().getBoolean("planets." + nether.getName() + ".false_nether"))) {
            int count;
            Location netherLocation = startBlock.getLocation();
            netherLocation.setY(netherLocation.getY() + 1.0);
            if (this.plugin.getPluginRespect().getRespect(netherLocation, new Parameters(p, Flag.getNoMessageFlags()))) {
                int[] gsl = TARDISTimeTravel.getStartLocation(netherLocation, d);
                int startx = gsl[0];
                int resetx = gsl[1];
                int starty = netherLocation.getBlockY();
                int startz = gsl[2];
                int resetz = gsl[3];
                count = TARDISTimeTravel.safeLocation(startx, starty, startz, resetx, resetz, nether, d);
            } else {
                count = 1;
            }
            if (count == 0) {
                safe = true;
                this.dest = netherLocation;
            }
        }
        return safe;
    }

    private int randomX(int range, int quarter, int rx, int ry, String e, Location l) {
        int currentx = e.equals("THIS") ? l.getBlockX() : 0;
        int wherex = TARDISConstants.RANDOM.nextInt(range);
        wherex += quarter * rx;
        if (TARDISConstants.RANDOM.nextInt(2) == 1) {
            wherex = -wherex;
        }
        return (wherex *= ry) + currentx;
    }

    private int randomZ(int range, int quarter, int rz, int ry, String e, Location l) {
        int currentz = e.equals("THIS") ? l.getBlockZ() : 0;
        int wherez = TARDISConstants.RANDOM.nextInt(range);
        wherez += quarter * rz;
        if (TARDISConstants.RANDOM.nextInt(2) == 1) {
            wherez = -wherez;
        }
        return (wherez *= ry) + currentz;
    }

    public Location submarine(Block b, COMPASS d) {
        Material type;
        Block block = b;
        while (TARDISMaterials.submarine_blocks.contains(type = (block = block.getRelative(BlockFace.DOWN)).getType())) {
        }
        Location loc = block.getRelative(BlockFace.UP).getLocation();
        for (int n = 0; n < this.attempts; ++n) {
            if (this.isSafeSubmarine(loc, d)) {
                return loc;
            }
            loc.setY(loc.getY() + 1.0);
        }
        return this.isSafeSubmarine(loc, d) ? loc : null;
    }

    public boolean isSafeSubmarine(Location l, COMPASS d) {
        int rowcount;
        int[] s = TARDISTimeTravel.getStartLocation(l, d);
        int count = 0;
        int starty = l.getBlockY();
        int colcount = switch (d) {
            case COMPASS.EAST, COMPASS.WEST -> {
                rowcount = 3;
                yield 4;
            }
            default -> {
                rowcount = 4;
                yield 3;
            }
        };
        for (int level = 0; level < 4; ++level) {
            for (int row = 0; row < rowcount; ++row) {
                for (int col = 0; col < colcount; ++col) {
                    Material mat = l.getWorld().getBlockAt(s[0], starty, s[2]).getType();
                    if (!TARDISConstants.GOOD_WATER.contains(mat)) {
                        ++count;
                    }
                    s[0] = s[0] + 1;
                }
                s[0] = s[1];
                s[2] = s[2] + 1;
            }
            s[2] = s[3];
            ++starty;
        }
        return count == 0;
    }
}

