/*
 * Decompiled with CFR 0.152.
 */
package me.eccentric_nz.TARDIS.rooms;

import java.util.HashMap;
import me.eccentric_nz.TARDIS.TARDIS;
import me.eccentric_nz.TARDIS.TARDISConstants;
import me.eccentric_nz.TARDIS.chameleon.utils.ChameleonColumn;
import me.eccentric_nz.TARDIS.enumeration.COMPASS;
import me.eccentric_nz.TARDIS.enumeration.ChameleonPreset;
import me.eccentric_nz.TARDIS.enumeration.TardisModule;
import me.eccentric_nz.TARDIS.planets.TARDISAliasResolver;
import me.eccentric_nz.TARDIS.utility.TARDISBlockSetters;
import me.eccentric_nz.TARDIS.utility.TARDISEntityTracker;
import me.eccentric_nz.TARDIS.utility.TARDISNumberParsers;
import org.bukkit.Keyed;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.Sound;
import org.bukkit.Tag;
import org.bukkit.World;
import org.bukkit.block.Block;
import org.bukkit.block.data.BlockData;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Item;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class ExteriorRenderer {
    private final TARDIS plugin;

    public ExteriorRenderer(TARDIS plugin) {
        this.plugin = plugin;
    }

    public void render(String interior, Location exterior, int id, Player p, COMPASS d, long time, String biome) {
        World ew = exterior.getWorld();
        int epbx = exterior.getBlockX();
        int epby = exterior.getBlockY();
        int epbz = exterior.getBlockZ();
        String isRendered = ew.getName() + ":" + epbx + ":" + epby + ":" + epbz;
        String[] idata = interior.split(":");
        World iw = TARDISAliasResolver.getWorldFromAlias(idata[0]);
        int ipbx = TARDISNumberParsers.parseInt(idata[1]);
        int ipby = TARDISNumberParsers.parseInt(idata[2]) + 2;
        int ipbz = TARDISNumberParsers.parseInt(idata[3]);
        Location location = new Location(iw, (double)ipbx, (double)ipby, (double)ipbz);
        if (this.plugin.getTrackerKeeper().getRenderer().containsKey(id) && this.plugin.getTrackerKeeper().getRenderer().get(id).equals(isRendered)) {
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "DEST_NO_CHANGE");
        } else {
            BlockData base;
            BlockData sky;
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "RENDER_START");
            int xx = 0;
            int yy = 0;
            int zz = 0;
            int isx = ipbx - 6;
            int isy = ipby - 1;
            int isz = ipbz - 6;
            int esx = epbx - 6;
            int esy = epby - 1;
            int esz = epbz - 6;
            int bwx = epbx - 1;
            int bex = epbx + 1;
            int buy = epby + 3;
            int bnz = epbz - 1;
            int bsz = epbz + 1;
            ew.getChunkAt(exterior).load();
            for (int y = esy; y < esy + 8; ++y) {
                for (int x = esx; x < esx + 13; ++x) {
                    for (int z = esz; z < esz + 13; ++z) {
                        if (y < epby || y > buy || x < bwx || x > bex || z < bnz || z > bsz) {
                            Block eb = ew.getBlockAt(x, y, z);
                            Block ib = iw.getBlockAt(isx + xx, isy + yy, isz + zz);
                            switch (eb.getType()) {
                                case WATER: {
                                    ib.setBlockData(Material.LIGHT_BLUE_STAINED_GLASS.createBlockData(), true);
                                    break;
                                }
                                case LAVA: {
                                    ib.setBlockData(Material.ORANGE_WOOL.createBlockData(), true);
                                    break;
                                }
                                default: {
                                    ib.setBlockData(eb.getBlockData(), true);
                                }
                            }
                        }
                        ++zz;
                    }
                    zz = 0;
                    ++xx;
                }
                xx = 0;
                ++yy;
            }
            int x = location.getBlockX();
            int plusx = location.getBlockX() + 1;
            int minusx = location.getBlockX() - 1;
            int y = location.getBlockY();
            int z = location.getBlockZ();
            int plusz = location.getBlockZ() + 1;
            int minusz = location.getBlockZ() - 1;
            ChameleonColumn column = this.plugin.getPresets().getGlass(ChameleonPreset.RENDER, d);
            BlockData[][] data = column.blockData();
            for (int i = 0; i < 9; ++i) {
                int px;
                BlockData[] coldatas = data[i];
                int pz = switch (i) {
                    case 0 -> {
                        px = minusx;
                        yield minusz;
                    }
                    case 1 -> {
                        px = x;
                        yield minusz;
                    }
                    case 2 -> {
                        px = plusx;
                        yield minusz;
                    }
                    case 3 -> {
                        px = plusx;
                        yield z;
                    }
                    case 4 -> {
                        px = plusx;
                        yield plusz;
                    }
                    case 5 -> {
                        px = x;
                        yield plusz;
                    }
                    case 6 -> {
                        px = minusx;
                        yield plusz;
                    }
                    case 7 -> {
                        px = minusx;
                        yield z;
                    }
                    default -> {
                        px = x;
                        yield z;
                    }
                };
                for (int py = 0; py < 4; ++py) {
                    TARDISBlockSetters.setBlock(iw, px, y + py, pz, coldatas[py]);
                }
            }
            BlockData stone = switch (biome) {
                case "THE_END" -> {
                    sky = TARDISConstants.BLACK;
                    base = Material.END_STONE.createBlockData();
                    yield Material.OBSIDIAN.createBlockData();
                }
                case "NETHER_WASTES", "SOUL_SAND_VALLEY", "CRIMSON_FOREST", "WARPED_FOREST", "BASALT_DELTAS" -> {
                    sky = TARDISConstants.BLACK;
                    base = Material.NETHERRACK.createBlockData();
                    yield Material.NETHER_QUARTZ_ORE.createBlockData();
                }
                default -> {
                    sky = time > 12500L ? TARDISConstants.BLACK : Material.LIGHT_BLUE_WOOL.createBlockData();
                    base = Material.DIRT.createBlockData();
                    yield Material.STONE.createBlockData();
                }
            };
            int endx = isx + 13;
            int topy = isy + 8;
            int endz = isz + 13;
            for (int cx = isx; cx < isx + 13; ++cx) {
                for (int cz = isz; cz < isz + 13; ++cz) {
                    Block skyBlock = iw.getBlockAt(cx, topy, cz);
                    if (!Tag.WOOL.isTagged((Keyed)skyBlock.getType())) continue;
                    skyBlock.setBlockData(sky);
                }
            }
            for (int x1 = isx - 1; x1 <= endx; ++x1) {
                block50: for (int y1 = isy; y1 < topy; ++y1) {
                    Block first = iw.getBlockAt(x1, y1, isz - 1);
                    switch (first.getType()) {
                        case LIGHT_BLUE_WOOL: 
                        case BLACK_WOOL: {
                            first.setBlockData(sky);
                            break;
                        }
                        case DIRT: 
                        case END_STONE: 
                        case NETHERRACK: {
                            first.setBlockData(base);
                            break;
                        }
                        default: {
                            first.setBlockData(stone);
                        }
                    }
                    Block third = iw.getBlockAt(x1, y1, endz);
                    switch (third.getType()) {
                        case LIGHT_BLUE_WOOL: 
                        case BLACK_WOOL: {
                            third.setBlockData(sky);
                            continue block50;
                        }
                        case DIRT: 
                        case END_STONE: 
                        case NETHERRACK: {
                            third.setBlockData(base);
                            continue block50;
                        }
                        default: {
                            third.setBlockData(stone);
                        }
                    }
                }
            }
            for (int z2 = isz - 1; z2 <= endz; ++z2) {
                block52: for (int y2 = isy; y2 < topy; ++y2) {
                    Block second = iw.getBlockAt(isx - 1, y2, z2);
                    switch (second.getType()) {
                        case LIGHT_BLUE_WOOL: 
                        case BLACK_WOOL: {
                            second.setBlockData(sky);
                            break;
                        }
                        case DIRT: 
                        case END_STONE: 
                        case NETHERRACK: {
                            second.setBlockData(base);
                            break;
                        }
                        default: {
                            second.setBlockData(stone);
                        }
                    }
                    Block fourth = iw.getBlockAt(endx, y2, z2);
                    switch (fourth.getType()) {
                        case LIGHT_BLUE_WOOL: 
                        case BLACK_WOOL: {
                            fourth.setBlockData(sky);
                            continue block52;
                        }
                        case DIRT: 
                        case END_STONE: 
                        case NETHERRACK: {
                            fourth.setBlockData(base);
                            continue block52;
                        }
                        default: {
                            fourth.setBlockData(stone);
                        }
                    }
                }
            }
            this.plugin.getTrackerKeeper().getRenderer().put(id, isRendered);
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "RENDER_DONE");
            for (Entity e : location.getChunk().getEntities()) {
                if (!(e instanceof Item)) continue;
                e.remove();
            }
        }
        if (this.plugin.getConfig().getBoolean("preferences.render_entities")) {
            new TARDISEntityTracker(this.plugin).addNPCs(exterior, location, p.getUniqueId());
        }
        HashMap<String, Object> where = new HashMap<String, Object>();
        where.put("tardis_id", id);
        this.plugin.getQueryFactory().alterEnergyLevel("tardis", -this.plugin.getArtronConfig().getInt("render"), where, p);
        this.plugin.getTrackerKeeper().getRenderRoomOccupants().add(p.getUniqueId());
        this.plugin.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this.plugin, () -> {
            this.transmat(p, d, location);
            p.playSound(location, Sound.ENTITY_ENDERMAN_TELEPORT, 1.0f, 1.0f);
            this.plugin.getMessenger().send((CommandSender)p, TardisModule.TARDIS, "RENDER_EXIT");
        }, 10L);
    }

    public void transmat(Player player, COMPASS d, Location loc) {
        float yaw = player.getLocation().getYaw();
        float pitch = player.getLocation().getPitch();
        loc.setPitch(pitch);
        loc.setYaw(yaw);
        double ex = loc.getX();
        double ez = loc.getZ();
        switch (d) {
            case NORTH: {
                loc.setX(ex + 0.5);
                loc.setZ(ez + 2.5);
                break;
            }
            case EAST: {
                loc.setX(ex - 1.5);
                loc.setZ(ez + 0.5);
                break;
            }
            case SOUTH: {
                loc.setX(ex + 0.5);
                loc.setZ(ez - 1.5);
                break;
            }
            default: {
                loc.setX(ex + 2.5);
                loc.setZ(ez + 0.5);
            }
        }
        player.teleport(loc);
    }
}

